/* $Id: ConnectionInfo.java,v 1.1 2007/10/29 02:55:41 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.client;

/**
 * クライアントが使用する接続情報。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class ConnectionInfo {

	/** エンジン名 */
	private String engineName;
	/** スコープ */
	private String scope;
	/** ユーザID */
	private String userID;
	/** パスワード */
	private String password;

	/**
	 * 接続情報を生成する。
	 *
	 * @param engineName エンジン接続名
	 * @param scope スコープ
	 * @param user ユーザID
	 * @param pass パスワード
	 */
	public ConnectionInfo(String engineName, String scope,
			String user, String pass) {
	    this.engineName = engineName;
	    this.scope = scope;
	    this.userID = user;
	    this.password = pass;
	}
	
	/**
	 * エンジン接続名を返す。
	 *
	 * @return エンジン接続名
	 */
	public String getEngineName() {

		return engineName;
	}

	/**
	 * スコープを返す。
	 *
	 * @return スコープ
	 */
	public String getScope() {

		return scope;
	}

	/**
	 * ユーザIDを返す。
	 *
	 * @return ユーザID
	 */
	public String getUserID() {

		return userID;
	}

	/**
	 * パスワードを返す。
	 *
	 * @return passwordの値
	 */
	public String getPassword() {

		return password;
	}
	
	/**
	 * 接続情報の文字列表現を返す
	 * 
	 * @return	接続情報の文字列表現
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
	    StringBuffer buf = new StringBuffer("[エンジン名=");
	    buf.append(this.engineName).append("]");
	    buf.append("[スコープ=").append(this.scope).append("]");
	    buf.append("[ユーザID=").append(this.userID).append("]");
	    buf.append("[パスワード=").append(this.password).append("]");
	    return new String(buf);
	}
}
