/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.data;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.StoreLocation;
import org.apache.activemq.kaha.impl.data.DataFile;
import org.apache.activemq.kaha.impl.data.DataItem;
import org.apache.activemq.kaha.impl.data.RedoListener;
import org.apache.activemq.kaha.impl.data.StoreDataReader;
import org.apache.activemq.kaha.impl.data.StoreDataWriter;
import org.apache.activemq.kaha.impl.index.RedoStoreIndexItem;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DataManager {
    private static final Log log = LogFactory.getLog((Class)DataManager.class);
    public static long MAX_FILE_LENGTH = 0x2000000L;
    private static final String NAME_PREFIX = "data-";
    private final File dir;
    private final String name;
    private StoreDataReader reader;
    private StoreDataWriter writer;
    private DataFile currentWriteFile;
    private long maxFileLength = MAX_FILE_LENGTH;
    Map fileMap = new HashMap();
    public static final int ITEM_HEAD_SIZE = 5;
    public static final byte DATA_ITEM_TYPE = 1;
    public static final byte REDO_ITEM_TYPE = 2;
    Marshaller redoMarshaller = RedoStoreIndexItem.MARSHALLER;
    private String dataFilePrefix;

    public DataManager(File dir, String name) {
        this.dir = dir;
        this.name = name;
        this.reader = new StoreDataReader(this);
        this.writer = new StoreDataWriter(this);
        this.dataFilePrefix = NAME_PREFIX + name + "-";
        File[] files = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String n) {
                return dir.equals(dir) && n.startsWith(DataManager.this.dataFilePrefix);
            }
        });
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String n = file.getName();
                String numStr = n.substring(this.dataFilePrefix.length(), n.length());
                int num = Integer.parseInt(numStr);
                DataFile dataFile = new DataFile(file, num);
                this.fileMap.put(dataFile.getNumber(), dataFile);
                if (this.currentWriteFile != null && this.currentWriteFile.getNumber() >= num) continue;
                this.currentWriteFile = dataFile;
            }
        }
    }

    private DataFile createAndAddDataFile(int num) {
        String fileName = this.dataFilePrefix + num;
        File file = new File(this.dir, fileName);
        DataFile result = new DataFile(file, num);
        this.fileMap.put(result.getNumber(), result);
        return result;
    }

    public String getName() {
        return this.name;
    }

    DataFile findSpaceForData(DataItem item) throws IOException {
        if (this.currentWriteFile == null || this.currentWriteFile.getLength() + (long)item.getSize() > this.maxFileLength) {
            int nextNum;
            int n = nextNum = this.currentWriteFile != null ? this.currentWriteFile.getNumber() + 1 : 1;
            if (this.currentWriteFile != null && this.currentWriteFile.isUnused()) {
                this.removeDataFile(this.currentWriteFile);
            }
            this.currentWriteFile = this.createAndAddDataFile(nextNum);
        }
        item.setOffset(this.currentWriteFile.getLength());
        item.setFile(this.currentWriteFile.getNumber());
        return this.currentWriteFile;
    }

    RandomAccessFile getDataFile(StoreLocation item) throws IOException {
        Integer key = new Integer(item.getFile());
        DataFile dataFile = (DataFile)this.fileMap.get(key);
        if (dataFile != null) {
            return dataFile.getRandomAccessFile();
        }
        log.error((Object)("Looking for key " + key + " but not found in fileMap: " + this.fileMap));
        throw new IOException("Could not locate data file data-" + this.name + "-" + item.getFile());
    }

    public synchronized Object readItem(Marshaller marshaller, StoreLocation item) throws IOException {
        return this.reader.readItem(marshaller, item);
    }

    public synchronized StoreLocation storeDataItem(Marshaller marshaller, Object payload) throws IOException {
        return this.writer.storeItem(marshaller, payload, (byte)1);
    }

    public synchronized StoreLocation storeRedoItem(Object payload) throws IOException {
        return this.writer.storeItem(this.redoMarshaller, payload, (byte)2);
    }

    public synchronized void updateItem(StoreLocation location, Marshaller marshaller, Object payload) throws IOException {
        this.writer.updateItem(location, marshaller, payload, (byte)1);
    }

    public synchronized void recoverRedoItems(RedoListener listener) throws IOException {
        if (this.currentWriteFile == null) {
            return;
        }
        DataItem item = new DataItem();
        item.setFile(this.currentWriteFile.getNumber());
        item.setOffset(0L);
        while (true) {
            byte type;
            try {
                type = this.reader.readDataItemSize(item);
            }
            catch (IOException ignore) {
                log.trace((Object)("End of data file reached at (header was invalid): " + item));
                return;
            }
            if (type == 2) {
                Object object;
                try {
                    object = this.readItem(this.redoMarshaller, item);
                }
                catch (IOException e1) {
                    log.trace((Object)("End of data file reached at (payload was invalid): " + item));
                    return;
                }
                try {
                    listener.onRedoItem(item, object);
                    item = item.copy();
                }
                catch (Exception e) {
                    throw IOExceptionSupport.create("Recovery handler failed: " + e, e);
                }
            }
            item.setOffset(item.getOffset() + 5L + (long)item.getSize());
        }
    }

    public synchronized void close() throws IOException {
        Iterator i = this.fileMap.values().iterator();
        while (i.hasNext()) {
            DataFile dataFile = (DataFile)i.next();
            dataFile.force();
            dataFile.close();
        }
        this.fileMap.clear();
    }

    public synchronized void force() throws IOException {
        Iterator i = this.fileMap.values().iterator();
        while (i.hasNext()) {
            DataFile dataFile = (DataFile)i.next();
            dataFile.force();
        }
    }

    public synchronized boolean delete() throws IOException {
        boolean result = true;
        Iterator i = this.fileMap.values().iterator();
        while (i.hasNext()) {
            DataFile dataFile = (DataFile)i.next();
            result &= dataFile.delete();
        }
        this.fileMap.clear();
        return result;
    }

    public synchronized void addInterestInFile(int file) throws IOException {
        if (file >= 0) {
            Integer key = new Integer(file);
            DataFile dataFile = (DataFile)this.fileMap.get(key);
            if (dataFile == null) {
                dataFile = this.createAndAddDataFile(file);
            }
            this.addInterestInFile(dataFile);
        }
    }

    void addInterestInFile(DataFile dataFile) {
        if (dataFile != null) {
            dataFile.increment();
        }
    }

    public synchronized void removeInterestInFile(int file) throws IOException {
        if (file >= 0) {
            Integer key = new Integer(file);
            DataFile dataFile = (DataFile)this.fileMap.get(key);
            this.removeInterestInFile(dataFile);
        }
    }

    synchronized void removeInterestInFile(DataFile dataFile) throws IOException {
        if (dataFile != null && dataFile.decrement() <= 0 && dataFile != this.currentWriteFile) {
            this.removeDataFile(dataFile);
        }
    }

    public synchronized void consolidateDataFiles() throws IOException {
        DataFile dataFile;
        ArrayList<DataFile> purgeList = new ArrayList<DataFile>();
        Iterator i = this.fileMap.values().iterator();
        while (i.hasNext()) {
            dataFile = (DataFile)i.next();
            if (!dataFile.isUnused() || dataFile == this.currentWriteFile) continue;
            purgeList.add(dataFile);
        }
        for (int i2 = 0; i2 < purgeList.size(); ++i2) {
            dataFile = (DataFile)purgeList.get(i2);
            this.removeDataFile(dataFile);
        }
    }

    private void removeDataFile(DataFile dataFile) throws IOException {
        this.fileMap.remove(dataFile.getNumber());
        boolean result = dataFile.delete();
        log.debug((Object)("discarding data file " + dataFile + (result ? "successful " : "failed")));
    }

    public Marshaller getRedoMarshaller() {
        return this.redoMarshaller;
    }

    public void setRedoMarshaller(Marshaller redoMarshaller) {
        this.redoMarshaller = redoMarshaller;
    }

    public long getMaxFileLength() {
        return this.maxFileLength;
    }

    public void setMaxFileLength(long maxFileLength) {
        this.maxFileLength = maxFileLength;
    }

    public String toString() {
        return "DataManager:(data-" + this.name + ")";
    }
}

