/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.log;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public class GeronimoLogging {
    private static final Map levels = new HashMap();
    public static final GeronimoLogging TRACE = new GeronimoLogging("TRACE");
    public static final GeronimoLogging DEBUG = new GeronimoLogging("DEBUG");
    public static final GeronimoLogging INFO = new GeronimoLogging("INFO");
    public static final GeronimoLogging WARN = new GeronimoLogging("WARN");
    public static final GeronimoLogging ERROR = new GeronimoLogging("ERROR");
    public static final GeronimoLogging FATAL = new GeronimoLogging("FATAL");
    private static boolean initialized = false;
    private static GeronimoLogging consoleLogLevel = ERROR;
    private static GeronimoLogging defaultLevel;
    private final String level;

    public static void initialize(GeronimoLogging level) {
        if (!initialized) {
            defaultLevel = level;
            consoleLogLevel = level;
            LogFactory.getLog(GeronimoLogging.class);
            initialized = true;
        }
    }

    public static void setDefaultLogLevel(GeronimoLogging level) {
        defaultLevel = level;
    }

    public static GeronimoLogging getDefaultLevel() {
        return defaultLevel;
    }

    public static GeronimoLogging getConsoleLogLevel() {
        return consoleLogLevel;
    }

    public static void setConsoleLogLevel(GeronimoLogging consoleLogLevel) {
        GeronimoLogging.consoleLogLevel = consoleLogLevel;
    }

    public static GeronimoLogging getGeronimoLogging(String level) {
        return (GeronimoLogging)levels.get(level);
    }

    private GeronimoLogging(String level) {
        this.level = level;
        levels.put(level, this);
    }

    public String toString() {
        return this.level;
    }

    public static boolean isBootstrapLoggingInitializationEnabled() {
        String value = System.getProperty("geronimo.bootstrap.logging.enabled");
        if (value == null) {
            return true;
        }
        return Boolean.valueOf(value);
    }
}

