/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config.xstream;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.IOException;
import org.apache.geronimo.kernel.config.xstream.XStreamGBeanState;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XStreamGBeanStateConverter
implements Converter {
    public boolean canConvert(Class clazz) {
        return XStreamGBeanState.class.isAssignableFrom(clazz);
    }

    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext marshallingContext) {
        XStreamGBeanState gbeanState = (XStreamGBeanState)object;
        Element element = null;
        try {
            element = gbeanState.getGBeanState();
        }
        catch (IOException e) {
            throw new ConversionException("Cannot get xml version of gbeans", (Exception)e);
        }
        marshallingContext.convertAnother((Object)element);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext unmarshallingContext) {
        Element element = (Element)unmarshallingContext.convertAnother((Object)reader, Element.class);
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Element)) continue;
            element = (Element)node;
            return new XStreamGBeanState(element);
        }
        throw new ConversionException("No nested nodes found");
    }
}

