/*
 * Decompiled with CFR 0.152.
 */
package pnuts.xml;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pnuts.lib.AggregateConfiguration;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import pnuts.lang.Configuration;
import pnuts.lang.Context;
import pnuts.xml.DOMAttributeMap;

public class XMLConfiguration
extends AggregateConfiguration {
    private static final String TEXT = "text".intern();
    private static final String TEXT_TRIM = "textTrim".intern();
    private static final String GET_CHILDREN = "getChildren".intern();
    private static final String GET_CHILD = "getChild".intern();
    private static final String ATTRIBUTES = "attributes".intern();

    public XMLConfiguration() {
    }

    public XMLConfiguration(Configuration base) {
        super(base);
    }

    static List findNodes(Node node, String name) {
        NodeList nodeList = node.getChildNodes();
        ArrayList<Node> lst = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            if (!n.getNodeName().equals(name)) continue;
            lst.add(n);
        }
        return lst;
    }

    static String getText(Node node) {
        NodeList nodeList = node.getChildNodes();
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nodeList.item(i);
            if (!(n instanceof Text)) continue;
            return n.getNodeValue();
        }
        return "";
    }

    static Element getElement(NodeList nodeList, String skey) {
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Element e;
            Node n = nodeList.item(i);
            if (!(n instanceof Element) || !(e = (Element)n).getTagName().equals(skey)) continue;
            return e;
        }
        return null;
    }

    static Element getElement(NodeList nodeList, int idx) {
        int len = nodeList.getLength();
        int count2 = 0;
        for (int i = 0; i < len; ++i) {
            Node n = nodeList.item(i);
            if (!(n instanceof Element)) continue;
            if (idx == count2) {
                return (Element)n;
            }
            ++count2;
        }
        return null;
    }

    public Object getElement(Context context, Object target, Object key) {
        String skey = null;
        int idx = 0;
        if (key instanceof Number) {
            idx = ((Number)key).intValue();
        } else if (key instanceof String) {
            skey = (String)key;
        } else {
            return super.getElement(context, target, key);
        }
        if (target instanceof Element && skey != null) {
            if (skey.charAt(0) == '@') {
                return ((Element)target).getAttribute(skey.substring(1));
            }
            return XMLConfiguration.getElement(((Element)target).getChildNodes(), skey);
        }
        if (target instanceof NodeList) {
            NodeList nodeList = (NodeList)target;
            if (skey == null) {
                return XMLConfiguration.getElement(nodeList, idx);
            }
            return XMLConfiguration.getElement(nodeList, skey);
        }
        if (target instanceof NamedNodeMap) {
            NamedNodeMap nodeMap = (NamedNodeMap)target;
            if (skey != null) {
                return nodeMap.getNamedItem(skey);
            }
            return nodeMap.item(idx);
        }
        return super.getElement(context, target, key);
    }

    public void setElement(Context context, Object target, Object key, Object value) {
        String skey = null;
        if (key instanceof String) {
            skey = (String)key;
            if (target instanceof Element) {
                if (skey.charAt(0) == '@') {
                    skey = skey.substring(1);
                }
                ((Element)target).setAttribute(skey, (String)value);
                return;
            }
        }
        super.setElement(context, target, key, value);
    }

    public Object getField(Context context, Object target, String name) {
        if (target instanceof Node) {
            if (name == TEXT) {
                return XMLConfiguration.getText((Node)target);
            }
            if (name == TEXT_TRIM) {
                return XMLConfiguration.getText((Node)target).trim();
            }
            if (name == ATTRIBUTES) {
                NamedNodeMap nodeMap = ((Node)target).getAttributes();
                Element element2 = null;
                if (target instanceof Element) {
                    element2 = (Element)target;
                }
                return new DOMAttributeMap(element2, nodeMap);
            }
            List lst = XMLConfiguration.findNodes((Node)target, name);
            int size2 = lst.size();
            if (size2 == 0) {
                if (name.charAt(0) == '@' && target instanceof Element) {
                    return ((Element)target).getAttribute(name.substring(1));
                }
                return null;
            }
            return lst;
        }
        if (target instanceof NamedNodeMap) {
            NamedNodeMap m = (NamedNodeMap)target;
            return m.getNamedItem(name);
        }
        return super.getField(context, target, name);
    }

    public void putField(Context context, Object target, String name, Object value) {
        if (target instanceof Element) {
            if (name == TEXT) {
                if (value instanceof String) {
                    ((Element)target).setTextContent((String)value);
                }
            } else if (name == ATTRIBUTES) {
                if (value instanceof Map) {
                    Element element2 = (Element)target;
                    NamedNodeMap m = element2.getAttributes();
                    int len = m.getLength();
                    for (int i = 0; i < len; ++i) {
                        Attr attr = (Attr)m.item(i);
                        element2.removeAttributeNode(attr);
                    }
                    Iterator it = ((Map)value).entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        element2.setAttribute((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            } else if (name.charAt(0) == '@' && value instanceof String) {
                ((Element)target).setAttribute(name.substring(1), (String)value);
            } else {
                super.putField(context, target, name, value);
            }
        } else {
            super.putField(context, target, name, value);
        }
    }

    public Object callMethod(Context context, Class c, String name, Object[] args, Class[] types, Object target) {
        if (target instanceof Node) {
            Node node = (Node)target;
            if (name == GET_CHILD && args.length == 1) {
                String tag = (String)args[0];
                NodeList nodeList = node.getChildNodes();
                int len = nodeList.getLength();
                for (int i = 0; i < len; ++i) {
                    Node n = nodeList.item(i);
                    if (!(n instanceof Element) || !((Element)n).getTagName().equals(tag)) continue;
                    return n;
                }
                return null;
            }
            if (name == GET_CHILDREN) {
                ArrayList<Node> list2 = new ArrayList<Node>();
                NodeList nodeList = node.getChildNodes();
                if (args.length == 1) {
                    String tag = (String)args[0];
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node n = nodeList.item(i);
                        if (!(n instanceof Element) || !((Element)n).getTagName().equals(tag)) continue;
                        list2.add(n);
                    }
                } else if (args.length == 0) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node n = nodeList.item(i);
                        if (!(n instanceof Element)) continue;
                        list2.add(n);
                    }
                }
                return list2;
            }
        }
        return super.callMethod(context, c, name, args, types, target);
    }

    public Enumeration toEnumeration(Object object) {
        if (object instanceof NodeList) {
            return new NodeListEnum((NodeList)object);
        }
        return super.toEnumeration(object);
    }

    static class NodeListEnum
    implements Enumeration {
        NodeList nodeList;
        int idx;
        int len;

        NodeListEnum(NodeList nodeList) {
            this.nodeList = nodeList;
            this.idx = 0;
            this.len = nodeList.getLength();
        }

        public boolean hasMoreElements() {
            return this.idx < this.len;
        }

        public Object nextElement() {
            return this.nodeList.item(this.idx++);
        }
    }
}

