/*
 * Decompiled with CFR 0.152.
 */
package pnuts.xml;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.xml.sax.Attributes;
import pnuts.xml.SAXAttributeMap;

class LocalNameMap
extends SAXAttributeMap {
    HashMap map;
    ArrayList entries;

    LocalNameMap() {
    }

    void setAttributes(Attributes attributes) {
        super.setAttributes(attributes);
        this.map = null;
        this.entries = null;
    }

    public int size() {
        if (this.map == null) {
            return this.attributes.getLength();
        }
        return this.map.size();
    }

    public Object get(Object key) {
        if (this.map == null) {
            this.prepareLocalNameMap();
        }
        return this.map.get(key);
    }

    private void prepareLocalNameMap() {
        this.entries = new ArrayList();
        this.map = new HashMap();
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            String name = this.attributes.getLocalName(i);
            String value = this.attributes.getValue(i);
            this.entries.add(new Entry(name, value));
            this.map.put(name, value);
        }
    }

    public Set keySet() {
        if (this.entries == null) {
            this.prepareLocalNameMap();
        }
        return new KeySet();
    }

    public Collection values() {
        if (this.entries == null) {
            this.prepareLocalNameMap();
        }
        return new ValueSet();
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.prepareLocalNameMap();
        }
        return new EntrySet();
    }

    class KeySetIterator
    extends EntrySetIterator {
        KeySetIterator() {
        }

        protected Object get(int idx) {
            return ((Map.Entry)LocalNameMap.this.entries.get(idx)).getKey();
        }
    }

    class ValueSetIterator
    extends EntrySetIterator {
        ValueSetIterator() {
        }

        protected Object get(int idx) {
            return ((Map.Entry)LocalNameMap.this.entries.get(idx)).getValue();
        }
    }

    class EntrySetIterator
    implements Iterator {
        private int max;
        private int pos;

        EntrySetIterator() {
            this.max = LocalNameMap.this.entries.size();
            this.pos = 0;
        }

        public boolean hasNext() {
            return this.pos <= this.max - 1;
        }

        protected Object get(int idx) {
            return LocalNameMap.this.entries.get(idx);
        }

        public Object next() {
            if (this.pos > this.max - 1) {
                throw new NoSuchElementException();
            }
            return this.get(this.pos++);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class KeySet
    extends EntrySet {
        KeySet() {
        }

        public Iterator iterator() {
            return new KeySetIterator();
        }
    }

    class ValueSet
    extends EntrySet {
        ValueSet() {
        }

        public Iterator iterator() {
            return new ValueSetIterator();
        }
    }

    class EntrySet
    extends AbstractCollection
    implements Set {
        EntrySet() {
        }

        public int size() {
            return LocalNameMap.this.entries.size();
        }

        public boolean isEmpty() {
            return LocalNameMap.this.entries.isEmpty();
        }

        public Iterator iterator() {
            return new EntrySetIterator();
        }
    }

    static class Entry
    implements Map.Entry {
        Object key;
        Object value;

        Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

