/*
 * Decompiled with CFR 0.152.
 */
package pnuts.xml;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMAttributeMap
extends AbstractMap {
    private NamedNodeMap map;
    private Element element;
    private transient Set entrySet = null;
    transient int size;

    public DOMAttributeMap(Element element2, NamedNodeMap map2) {
        this.element = element2;
        this.map = map2;
    }

    public Set entrySet() {
        Set es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    public Object get(Object key) {
        Node item = this.getNamedItem((String)key);
        if (item instanceof Attr) {
            return ((Attr)item).getValue();
        }
        return null;
    }

    public Object put(Object key, Object value) {
        if (!(key instanceof String)) {
            throw new IllegalArgumentException(String.valueOf(key));
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException(String.valueOf(value));
        }
        String name = (String)key;
        Node old = this.map.getNamedItem(name);
        if (old instanceof Attr) {
            ((Attr)old).setValue((String)value);
        } else if (this.element != null) {
            this.element.setAttribute(name, (String)value);
        }
        return old;
    }

    public Object remove(Object key) {
        return this.map.removeNamedItem((String)key);
    }

    Node getNamedItem(String name) {
        return this.map.getNamedItem(name);
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new AttrIterator();
        }

        public boolean contains(Object o) {
            if (!(o instanceof AttrEntry)) {
                return false;
            }
            AttrEntry e = (AttrEntry)o;
            Object key = e.getKey();
            Object value = e.getValue();
            if (!(key instanceof String)) {
                return false;
            }
            if (!(value instanceof String)) {
                return false;
            }
            if (value == null) {
                return DOMAttributeMap.this.getNamedItem((String)key) == null;
            }
            return value.equals(DOMAttributeMap.this.getNamedItem((String)key));
        }

        public boolean remove(Object o) {
            if (!(o instanceof AttrEntry)) {
                return false;
            }
            AttrEntry e = (AttrEntry)o;
            Object key = e.getKey();
            Object value = e.getValue();
            Node item = DOMAttributeMap.this.getNamedItem((String)key);
            if (item instanceof Attr) {
                Attr attr = (Attr)item;
                if (value == null) {
                    if (attr.getValue() == null) {
                        DOMAttributeMap.this.map.removeNamedItem((String)key);
                        return true;
                    }
                } else if (value.equals(attr.getValue())) {
                    DOMAttributeMap.this.map.removeNamedItem((String)key);
                    return true;
                }
            }
            return false;
        }

        public int size() {
            return DOMAttributeMap.this.size;
        }

        public void clear() {
            DOMAttributeMap.this.clear();
        }
    }

    private class AttrIterator
    implements Iterator {
        int idx = 0;
        int len = DOMAttributeMap.access$100(DOMAttributeMap.this).getLength();

        private AttrIterator() {
        }

        Map.Entry nextEntry() {
            Attr attr = (Attr)DOMAttributeMap.this.map.item(this.idx++);
            return new AttrEntry(attr);
        }

        public Object next() {
            return this.nextEntry();
        }

        public boolean hasNext() {
            return this.idx < this.len;
        }

        public void remove() {
            Attr attr = (Attr)DOMAttributeMap.this.map.item(this.idx);
            DOMAttributeMap.this.map.removeNamedItem(attr.getName());
        }
    }

    private class AttrEntry
    implements Map.Entry {
        private Attr attr;

        AttrEntry(Attr attr) {
            this.attr = attr;
        }

        public Object getKey() {
            return this.attr.getName();
        }

        public Object getValue() {
            return this.attr.getValue();
        }

        public Object setValue(Object value) {
            String old = this.attr.getValue();
            this.attr.setValue((String)value);
            return old;
        }

        public int hashCode() {
            return this.attr.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof AttrEntry) {
                return this.attr.equals(((AttrEntry)obj).attr);
            }
            return false;
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

