/*
 * Decompiled with CFR 0.152.
 */
package pnuts.text;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import pnuts.lang.Context;
import pnuts.lang.PnutsFunction;
import pnuts.lang.Runtime;

public class Template {
    private String text;
    private int[] startIndexes;
    private int[] endIndexes;
    private String[] keys;

    public Template(String text, int[] startIndexes, int[] endIndexes, String[] keys) {
        this.text = text;
        this.startIndexes = startIndexes;
        this.endIndexes = endIndexes;
        this.keys = keys;
    }

    static void apply(Object val, Writer writer2, Context context) throws IOException {
        if (val instanceof String) {
            writer2.write((String)val);
        } else if (val instanceof PnutsFunction) {
            ((PnutsFunction)val).call(new Object[]{writer2}, context);
        } else if (val instanceof Collection) {
            Collection col = (Collection)val;
            Iterator it = col.iterator();
            while (it.hasNext()) {
                Template.apply(it.next(), writer2, context);
            }
        } else if (val instanceof Iterator) {
            Iterator it = (Iterator)val;
            while (it.hasNext()) {
                Template.apply(it.next(), writer2, context);
            }
        } else if (val instanceof Enumeration) {
            Enumeration en = (Enumeration)val;
            while (en.hasMoreElements()) {
                Template.apply(en.nextElement(), writer2, context);
            }
        } else if (Runtime.isArray((Object)val)) {
            int len = Runtime.getArrayLength((Object)val);
            for (int i = 0; i < len; ++i) {
                Template.apply(Array.get(val, i), writer2, context);
            }
        } else if (val != null) {
            writer2.write(val.toString());
        }
    }

    public void format(Map def, Writer writer2, Context context) throws IOException {
        int offset = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            writer2.write(this.text, offset, this.startIndexes[i] - offset);
            Template.apply(def.get(this.keys[i]), writer2, context);
            offset = this.endIndexes[i];
        }
        writer2.write(this.text, offset, this.text.length() - offset);
    }

    public String toString() {
        return this.text;
    }
}

