/*
 * Decompiled with CFR 0.152.
 */
package pnuts.servlet;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import pnuts.lang.Context;
import pnuts.servlet.PnutsServlet;

class ResponseWriter
extends Writer {
    private ServletResponse response;
    private Context context;
    private Writer writer;
    private ByteArrayOutputStream bout;
    private boolean buffering;

    public ResponseWriter(ServletResponse response, Context context, boolean buffering) {
        this.response = response;
        this.context = context;
        this.buffering = buffering;
    }

    private Writer getWriter() throws IOException {
        Writer w = (Writer)this.context.get(PnutsServlet.SERVLET_WRITER);
        if (w == null) {
            if (this.buffering) {
                this.bout = new ByteArrayOutputStream();
                w = new BufferedWriter(new OutputStreamWriter((OutputStream)this.bout, this.response.getCharacterEncoding()));
            } else {
                w = this.response.getWriter();
            }
            this.context.set(PnutsServlet.SERVLET_WRITER, (Object)w);
        }
        return w;
    }

    public void write(int c) throws IOException {
        if (this.writer == null) {
            this.writer = this.getWriter();
        }
        this.writer.write(c);
    }

    public void write(char[] cbuf) throws IOException {
        if (this.writer == null) {
            this.writer = this.getWriter();
        }
        this.writer.write(cbuf);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.writer == null) {
            this.writer = this.getWriter();
        }
        this.writer.write(cbuf, off, len);
    }

    public void write(String str) throws IOException {
        if (this.writer == null) {
            this.writer = this.getWriter();
        }
        this.writer.write(str);
    }

    public void write(String str, int off, int len) throws IOException {
        if (this.writer == null) {
            this.writer = this.getWriter();
        }
        this.writer.write(str, off, len);
    }

    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public void flushBuffer() throws IOException {
        int size2;
        if (this.buffering && this.bout != null && (size2 = this.bout.size()) > 0) {
            this.response.setContentLength(this.bout.size());
            ServletOutputStream out = this.response.getOutputStream();
            this.bout.writeTo((OutputStream)out);
            this.bout.reset();
        }
    }
}

