/*
 * Decompiled with CFR 0.152.
 */
package pnuts.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import pnuts.compiler.Compiler;
import pnuts.compiler.CompilerPnutsImpl;
import pnuts.lang.Context;
import pnuts.lang.Implementation;
import pnuts.lang.Package;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsImpl;
import pnuts.lang.Runtime;
import pnuts.servlet.PnutsServletContext;
import pnuts.servlet.ResponseWriter;

public class PnutsServlet
extends HttpServlet {
    public static final String SYMBOL_THIS = "this".intern();
    public static final String SYMBOL_REQUEST = "request".intern();
    public static final String SYMBOL_RESPONSE = "response".intern();
    public static final String SERVLET_REQUEST = "request".intern();
    public static final String SERVLET_RESPONSE = "response".intern();
    public static final String SERVLET_BUFFER = "pnuts.servlet.buffer".intern();
    public static final String EXECUTE_LATEST_SCRIPT = "pnuts.servlet.latest.script".intern();
    public static final String SERVLET_WRITER = "pnuts.servlet.writer".intern();
    public static final String SERVLET_MULTIPART_PARAM = "pnuts.servlet.multipart.param".intern();
    public static final String SERVLET_PARAM = "pnuts.servlet.parameters".intern();
    public static final String SERVLET_COOKIE = "pnuts.servlet.cookies".intern();
    public static final String SERVLET_FILE = "pnuts.servlet.file".intern();
    public static final String SERVLET_BASEDIR = "pnuts.servlet.dir".intern();
    public static final String REQUEST_SCOPE = "pnuts.servlet.request.scope".intern();
    public static final String SERVLET_COMPILER = "pnuts.servlet.compiler".intern();
    private static final String LOCALE_KEY = "pnuts$lib$locale".intern();
    private static final String TIMEZONE_KEY = "pnuts$lib$timezone".intern();
    boolean debug;
    boolean buffering;
    boolean checkUpdate = true;
    boolean compile = true;
    Compiler compiler;
    File scriptFile;
    String encoding;
    boolean isolation;
    URL baseURL;
    String errorPage;
    private PnutsServletContext pnutsServletContext;
    private Hashtable contexts = new Hashtable();
    private Context context = new Context();
    private Package pkg;

    public void init() throws ServletException {
        StringTokenizer st;
        String _isolation;
        String _compile;
        boolean compile2;
        String path;
        File f;
        ServletConfig conf = this.getServletConfig();
        this.debug = Boolean.valueOf(conf.getInitParameter("debug"));
        String module = conf.getInitParameter("module");
        String script = conf.getInitParameter("script");
        ServletContext servletContext = this.getServletContext();
        if (script != null && (f = new File(path = servletContext.getRealPath(script))).exists()) {
            this.scriptFile = f;
        }
        if (compile2 = (this.compile = Boolean.valueOf(_compile = conf.getInitParameter("compile")).booleanValue())) {
            this.compiler = new Compiler(null, false, true);
            this.context.set(SERVLET_COMPILER, (Object)this.compiler);
        }
        String locale2 = conf.getInitParameter("locale");
        String timezone = conf.getInitParameter("timezone");
        Object pnutsImpl = compile2 ? new CompilerPnutsImpl(true, true) : PnutsImpl.getDefault();
        this.context.setImplementation((Implementation)pnutsImpl);
        String _buffering = conf.getInitParameter("buffering");
        this.buffering = _buffering != null ? Boolean.valueOf(_buffering) : true;
        String check = conf.getInitParameter("execute-latest-script");
        if (check != null) {
            this.checkUpdate = Boolean.valueOf(check);
        }
        if (this.checkUpdate) {
            this.context.set(EXECUTE_LATEST_SCRIPT, (Object)Boolean.TRUE);
        }
        this.encoding = conf.getInitParameter("encoding");
        if (this.encoding != null) {
            this.context.setScriptEncoding(this.encoding);
        }
        this.isolation = (_isolation = conf.getInitParameter("isolation")) != null ? Boolean.valueOf(_isolation) : true;
        this.errorPage = conf.getInitParameter("error-page");
        if (locale2 != null) {
            Locale loc;
            st = new StringTokenizer(locale2, "_");
            int n = st.countTokens();
            switch (n) {
                case 0: {
                    loc = new Locale("");
                    break;
                }
                case 1: {
                    loc = new Locale(st.nextToken(), "", "");
                    break;
                }
                case 2: {
                    loc = new Locale(st.nextToken(), st.nextToken(), "");
                    break;
                }
                default: {
                    loc = new Locale(st.nextToken(), st.nextToken(), st.nextToken());
                }
            }
            this.context.set(LOCALE_KEY, (Object)loc);
        }
        if (timezone != null) {
            this.context.set(TIMEZONE_KEY, (Object)TimeZone.getTimeZone(timezone));
        }
        this.pkg = new Package("root", null);
        this.context.setCurrentPackage(this.pkg);
        if (module != null) {
            st = new StringTokenizer(module, ",", false);
            while (st.hasMoreTokens()) {
                String mod = st.nextToken().trim();
                this.context.usePackage(mod);
            }
        }
        this.context.set(SYMBOL_THIS, (Object)this);
        this.context.set(SERVLET_BASEDIR, (Object)new File(servletContext.getRealPath("/")));
        String initialScript = conf.getInitParameter("initialScript");
        try {
            this.baseURL = new File(servletContext.getRealPath("/")).toURL();
            if (initialScript != null) {
                String path2 = servletContext.getRealPath(initialScript);
                File f2 = new File(path2);
                if (f2.exists()) {
                    File dir = f2.getParentFile();
                    this.context.set(SERVLET_FILE, (Object)f2);
                    this.pkg.set(SYMBOL_THIS, (Object)this, this.context);
                    ClassLoader ccl = this.getContextClassLoader();
                    URL[] urls = new URL[]{dir.toURL(), this.baseURL};
                    URLClassLoader loader = new URLClassLoader(urls, ccl);
                    this.context.setClassLoader((ClassLoader)loader);
                    Pnuts.require((String)initialScript, (Context)this.context);
                } else {
                    System.err.println(path2 + " is not found");
                }
            }
            if (this.scriptFile != null) {
                this.pnutsServletContext = this.createPnutsServletContext(this.scriptFile);
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.do_service(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.do_service(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.do_service(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.do_service(request, response);
    }

    protected ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void do_service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Context c = null;
        Package p = null;
        Pnuts script = null;
        long time = 0L;
        try {
            Object servletPath;
            File file = this.scriptFile;
            if (file == null) {
                String real_path;
                String path = "";
                servletPath = request.getServletPath();
                if (servletPath != null) {
                    path = servletPath;
                }
                if (path == null) {
                    path = request.getPathInfo();
                }
                if ((real_path = this.getServletContext().getRealPath(path)) != null) {
                    file = new File(real_path);
                }
            }
            if (file == null || !file.exists()) {
                if (this.debug) {
                    throw new FileNotFoundException();
                }
                response.sendError(404);
                return;
            }
            PnutsServletContext ctx = this.pnutsServletContext;
            if (ctx == null) {
                servletPath = this.contexts;
                synchronized (servletPath) {
                    ctx = (PnutsServletContext)this.contexts.get(file);
                    if (ctx == null) {
                        ctx = this.createPnutsServletContext(file);
                        c = ctx.context;
                        p = ctx.basePackage;
                        this.contexts.put(file, ctx);
                        if (this.debug) {
                            c.setVerbose(true);
                        }
                    } else {
                        c = ctx.context;
                        p = ctx.basePackage;
                        script = ctx.script;
                        time = ctx.time;
                    }
                }
            } else {
                c = ctx.context;
                p = ctx.basePackage;
                script = ctx.script;
                time = ctx.time;
            }
            c = (Context)c.clone();
            Thread.currentThread().setContextClassLoader(c.getClassLoader());
            boolean buffering = this.buffering;
            ResponseWriter rw = new ResponseWriter((ServletResponse)response, c, buffering);
            c.setWriter((Writer)rw);
            p.set(SYMBOL_THIS, (Object)this, c);
            Package pkg = new Package(null, p);
            pkg.set(SYMBOL_RESPONSE, (Object)response, c);
            pkg.set(SYMBOL_REQUEST, (Object)request, c);
            c.set(SERVLET_RESPONSE, (Object)response);
            c.set(SERVLET_REQUEST, (Object)request);
            c.set(REQUEST_SCOPE, (Object)pkg);
            c.setCurrentPackage(pkg);
            if (script == null) {
                script = this.readScript(file, this.encoding, ctx);
            } else if (this.checkUpdate && ctx.needToUpdate()) {
                script = this.readScript(file, this.encoding, ctx);
            }
            script.run(c);
            if (buffering) {
                rw.flushBuffer();
            }
        }
        catch (Throwable e) {
            if (this.debug) {
                e.printStackTrace();
            } else {
                System.err.println(e);
            }
            if (this.errorPage != null) {
                response.sendRedirect(this.errorPage);
            }
            response.sendError(500, "");
        }
    }

    PnutsServletContext createPnutsServletContext(File file) throws MalformedURLException {
        ClassLoader ccl = this.getContextClassLoader();
        File dir = file.getParentFile();
        URL[] urls = new URL[]{dir.toURL(), this.baseURL};
        URLClassLoader loader = new URLClassLoader(urls, ccl);
        Context c = this.isolation ? new Context(this.context) : (Context)this.context.clone();
        c.setClassLoader((ClassLoader)loader);
        c.set(SERVLET_FILE, (Object)file);
        c.set(SYMBOL_THIS, (Object)this);
        Package p = this.isolation ? (Package)this.pkg.clone() : this.pkg;
        PnutsServletContext ctx = new PnutsServletContext(c, p);
        if (this.debug) {
            c.setVerbose(true);
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pnuts parseFile(File file, String encoding, PnutsServletContext psc) throws IOException {
        URL scriptURL = file.toURL();
        Reader reader2 = null;
        reader2 = encoding != null ? new InputStreamReader((InputStream)new FileInputStream(file), encoding) : Runtime.getScriptReader((InputStream)new FileInputStream(file), (Context)this.context);
        try {
            Pnuts result = Pnuts.parse((Reader)reader2, (Object)scriptURL, (Context)psc.context);
            HashSet<URL> scriptURLs = new HashSet<URL>();
            scriptURLs.add(scriptURL);
            psc.scriptURLs = scriptURLs;
            Pnuts pnuts = result;
            return pnuts;
        }
        finally {
            if (reader2 != null) {
                reader2.close();
            }
        }
    }

    protected Pnuts readScript(File file, String encoding, PnutsServletContext psc) throws IOException {
        Pnuts expr;
        block4: {
            if (this.debug) {
                System.out.println("readScript " + file);
            }
            expr = this.parseFile(file, encoding, psc);
            if (this.compile) {
                try {
                    expr = this.compiler.compile(expr, psc.context);
                }
                catch (ClassFormatError e) {
                    if (!this.debug) break block4;
                    System.out.println("compile failed (interpreting)");
                }
            }
        }
        psc.script = expr;
        psc.time = System.currentTimeMillis();
        return expr;
    }

    public String getServletInfo() {
        return "Pnuts Servlet for servlet scripting. See http://pnuts.org/ for more information";
    }
}

