/*
 * Decompiled with CFR 0.152.
 */
package pnuts.servlet;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.pnuts.servlet.protocol.pea.Handler;
import pnuts.compiler.Compiler;
import pnuts.ext.CachedScript;
import pnuts.lang.Context;
import pnuts.lang.ParseException;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsException;
import pnuts.lang.Runtime;

public class DynamicPage
extends CachedScript {
    private static final int BUFFER_SIZE = 4096;
    private static final String PRINT = "\nprint(";
    private static final String EOL = "\")\n";
    private Set scriptURLs;
    private boolean checkUpdates;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(File infile, File outfile, String enc, Context context) throws IOException {
        Reader in = null;
        Writer out = null;
        try {
            try {
                if (enc == null) {
                    enc = context.getScriptEncoding();
                }
                if (enc != null) {
                    in = new InputStreamReader((InputStream)new FileInputStream(infile), enc);
                    out = new OutputStreamWriter((OutputStream)new FileOutputStream(outfile), enc);
                } else {
                    in = new FileReader(infile);
                    out = new FileWriter(outfile);
                }
                DynamicPage.convert(in, out, infile.getAbsoluteFile().getParentFile().toURL(), enc, context);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void convert(Reader input, Writer output, URL baseloc, String enc, Context context) throws IOException {
        DynamicPage.convert(input, output, baseloc, enc, context, null);
    }

    public static void convert(Reader input, Writer output, URL baseloc, String enc, Context context, Set scriptURLs) throws IOException {
        DynamicPage.convert(input, output, baseloc, enc, context, scriptURLs, new boolean[1]);
    }

    static void convert(Reader input, Writer output, URL baseloc, String enc, Context context, Set scriptURLs, boolean[] escape2) throws IOException {
        int n;
        char[] buf = new char[4096];
        int state = 0;
        int type = -1;
        boolean printing = false;
        CharArrayWriter s1 = new CharArrayWriter();
        CharArrayWriter s2 = new CharArrayWriter();
        int p1 = -1;
        int p2 = -1;
        boolean quote = false;
        while ((n = input.read(buf)) != -1) {
            p1 = 0;
            block8: for (int i = 0; i < n; ++i) {
                char c = buf[i];
                switch (state) {
                    case 0: {
                        if (c != '<') continue block8;
                        state = 1;
                        continue block8;
                    }
                    case 1: {
                        if (c == '%') {
                            state = 2;
                            if (i - p1 <= 1) continue block8;
                            if (!printing) {
                                output.write(PRINT);
                                output.write(34);
                                printing = true;
                            } else {
                                if (quote) {
                                    output.write(34);
                                }
                                output.write(44);
                                output.write(34);
                            }
                            quote = true;
                            if (s1.size() > 0) {
                                s1.write(buf, p1, i - 1 - p1);
                                DynamicPage.encode(output, s1.toCharArray());
                                s1.reset();
                                continue block8;
                            }
                            DynamicPage.encode(output, buf, p1, i - 1 - p1);
                            continue block8;
                        }
                        state = 0;
                        continue block8;
                    }
                    case 2: {
                        if (c == '-') {
                            type = 0;
                            p2 = (i + 1) % n;
                        } else if (c == '=') {
                            type = 2;
                            p2 = (i + 1) % n;
                        } else if (c == '@') {
                            type = 3;
                            p2 = (i + 1) % n;
                        } else {
                            type = 1;
                            p2 = i;
                        }
                        state = 3;
                        continue block8;
                    }
                    case 3: {
                        if (c != '%') continue block8;
                        state = 4;
                        continue block8;
                    }
                    case 4: {
                        if (c == '>') {
                            state = 0;
                            if (i - p2 > 1) {
                                s2.write(buf, p2, i - 1 - p2);
                                if (type == 2) {
                                    if (!printing) {
                                        output.write(PRINT);
                                        printing = true;
                                    } else {
                                        if (quote) {
                                            output.write(34);
                                        }
                                        output.write(44);
                                    }
                                    quote = false;
                                    if (escape2[0]) {
                                        output.write("escape(");
                                    }
                                    s2.writeTo(output);
                                    if (escape2[0]) {
                                        output.write(")");
                                    }
                                } else if (type == 1) {
                                    if (printing) {
                                        output.write(EOL);
                                        printing = false;
                                    }
                                    s2.writeTo(output);
                                } else if (type == 3) {
                                    if (printing) {
                                        output.write(EOL);
                                        printing = false;
                                    }
                                    char[] b = s2.toCharArray();
                                    DynamicPage.executeDirective(b, output, baseloc, enc, context, scriptURLs, escape2);
                                    output.write(10);
                                    s2.reset();
                                } else if (type == 0 && printing) {
                                    output.write(EOL);
                                    printing = false;
                                }
                                s2.reset();
                            }
                            p1 = i + 1;
                            type = -1;
                            continue block8;
                        }
                        state = 3;
                    }
                }
            }
            if (state == 0 && p1 >= 0) {
                s1.write(buf, p1, n - p1);
                continue;
            }
            if (state != 2 && state != 3 || p2 < 0) continue;
            s2.write(buf, p2, n - p2);
            p2 = 0;
        }
        if (state == 0 || state == 1) {
            if (s1.size() > 0) {
                if (!printing) {
                    output.write(PRINT);
                    output.write(34);
                    printing = true;
                } else {
                    if (quote) {
                        output.write(34);
                    }
                    output.write(44);
                    output.write(34);
                }
                quote = true;
                DynamicPage.encode(output, s1.toCharArray());
            }
            if (printing) {
                if (quote) {
                    output.write(34);
                }
                output.write(41);
            }
        } else if (s2.size() > 0) {
            if (printing) {
                output.write(EOL);
            }
            s2.writeTo(output);
            if (quote) {
                output.write(34);
            }
            output.write(41);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void executeDirective(char[] b, Writer output, URL baseloc, String enc, Context context, Set scriptURLs, boolean[] escape2) throws IOException {
        String s = new String(b);
        StringTokenizer st = new StringTokenizer(s, " ");
        String s1 = st.nextToken();
        String s2 = null;
        if (st.hasMoreTokens()) {
            s2 = st.nextToken();
        }
        if ("include".equals(s1)) {
            int idx = s2.indexOf(61);
            if (idx < 0) {
                throw new RuntimeException("corrupted directive");
            }
            String attr = s2.substring(0, idx).trim();
            int len = s2.length();
            String value = s2.charAt(idx + 1) == '\"' && s2.charAt(len - 1) == '\"' ? s2.substring(6, len - 1) : s2.substring(5);
            if ("file".equals(attr)) {
                if (baseloc != null) {
                    URL url = new URL(baseloc, value);
                    if (scriptURLs != null) {
                        scriptURLs.add(url);
                    }
                    Reader reader2 = enc != null ? new InputStreamReader(url.openStream(), enc) : Runtime.getScriptReader((InputStream)url.openStream(), (Context)context);
                    DynamicPage.convert(reader2, output, baseloc, enc, context, scriptURLs, escape2);
                    return;
                }
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                URL url = cl.getResource(value);
                if (scriptURLs != null && url != null) {
                    scriptURLs.add(url);
                }
                InputStream in = null;
                try {
                    if (url != null) {
                        in = url.openStream();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (in == null) throw new FileNotFoundException(value);
                Reader reader3 = enc != null ? new InputStreamReader(in, enc) : Runtime.getScriptReader((InputStream)in, (Context)context);
                DynamicPage.convert(reader3, output, null, enc, context, scriptURLs, escape2);
                return;
            }
            if (!"expr".equals(attr)) throw new RuntimeException("unsupported include type");
            String v = String.valueOf(Pnuts.eval((String)value, (Context)context));
            output.write(PRINT);
            output.write(34);
            DynamicPage.encode(output, v.toCharArray());
            output.write(EOL);
            return;
        }
        if ("escape".equals(s1)) {
            escape2[0] = true;
            return;
        } else {
            if (!"no-escape".equals(s1)) throw new RuntimeException("not supported directive");
            escape2[0] = false;
        }
    }

    static void encode(Writer output, char[] buf) throws IOException {
        DynamicPage.encode(output, buf, 0, buf.length);
    }

    static void encode(Writer output, char[] src, int offset, int size2) throws IOException {
        char[] buf = new char[512];
        int bufsize = buf.length;
        int pos = 0;
        block4: for (int i = offset; i < offset + size2; ++i) {
            if (pos + 2 > bufsize) {
                output.write(buf, 0, pos);
                pos = 0;
            }
            char c = src[i];
            switch (c) {
                case '\\': {
                    buf[pos++] = 92;
                    buf[pos++] = 92;
                    continue block4;
                }
                case '\"': {
                    buf[pos++] = 92;
                    buf[pos++] = 34;
                    continue block4;
                }
                default: {
                    buf[pos++] = c;
                }
            }
        }
        if (pos > 0) {
            output.write(buf, 0, pos);
        }
    }

    public DynamicPage(URL scriptURL, String encoding, Context context) throws IOException, ParseException {
        this(scriptURL, encoding, context, true);
    }

    public DynamicPage(URL scriptURL, String encoding, Context context, boolean checkUpdates) throws IOException, ParseException {
        super(scriptURL, encoding, context);
        this.checkUpdates = checkUpdates;
    }

    protected boolean needToUpdate() {
        if (this.scriptURLs == null) {
            return true;
        }
        if (this.checkUpdates) {
            try {
                Iterator it = this.scriptURLs.iterator();
                while (it.hasNext()) {
                    URL url = (URL)it.next();
                    long mod = url.openConnection().getLastModified();
                    if (mod <= this.parsedTime) continue;
                    return true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private Reader getReader(InputStream in, Context context) throws UnsupportedEncodingException {
        if (this.encoding != null) {
            return new InputStreamReader(in, this.encoding);
        }
        return Runtime.getScriptReader((InputStream)in, (Context)context);
    }

    static URL getDynamicPageURL(URL url, String encoding, Context context, Set scriptURLs) {
        try {
            String specURL = encoding == null ? "pea:" + url.toExternalForm() : "pea:" + url.toExternalForm() + "!charset=" + encoding;
            return new URL(null, specURL, new Handler(context, scriptURLs));
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
            return null;
        }
    }

    protected Compiler getCompiler() {
        return new Compiler(null, false);
    }

    protected Pnuts compile(Pnuts parsed, Context context) {
        Compiler compiler = this.getCompiler();
        if (compiler != null) {
            return compiler.compile(parsed, context);
        }
        return parsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(Context context) throws IOException, ParseException {
        try {
            HashSet<URL> scriptURLs = new HashSet<URL>();
            scriptURLs.add(this.scriptURL);
            URL convertedURL = DynamicPage.getDynamicPageURL(this.scriptURL, this.encoding, context, scriptURLs);
            InputStream in = null;
            try {
                in = convertedURL.openStream();
                StringWriter sw = new StringWriter();
                Pnuts parsed = Pnuts.parse((Reader)this.getReader(in, context), (Object)convertedURL, (Context)context);
                this.script = this.compile(parsed, context);
                this.scriptURLs = scriptURLs;
                this.parsedTime = System.currentTimeMillis();
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            throw new PnutsException((Throwable)e, context);
        }
    }
}

