/*
 * Decompiled with CFR 0.152.
 */
package pnuts.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import pnuts.lang.Context;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;

public class MD
extends PnutsFunction {
    String algorithm;
    String keysym;

    public MD(String name, String algorithm) {
        super(name);
        this.algorithm = algorithm;
        this.keysym = ("pnuts.security.md." + algorithm).intern();
    }

    public boolean defined(int nargs) {
        return nargs == 1 || nargs == 3;
    }

    protected Object exec(Object[] args, Context context) {
        MessageDigest md;
        int nargs = args.length;
        try {
            md = (MessageDigest)context.get(this.keysym);
            if (md == null) {
                md = MessageDigest.getInstance(this.algorithm);
                context.set(this.keysym, (Object)md);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new PnutsException((Throwable)e, context);
        }
        if (nargs == 1) {
            try {
                return MD.digest(md, args[0]);
            }
            catch (IOException e) {
                throw new PnutsException((Throwable)e, context);
            }
        }
        if (nargs == 3) {
            byte[] b = (byte[])args[0];
            int offset = (Integer)args[1];
            int size2 = (Integer)args[2];
            return MD.digest(md, b, offset, size2);
        }
        this.undefined(args, context);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] digest(MessageDigest md, Object input) throws IOException {
        md.reset();
        if (input instanceof InputStream) {
            int n;
            InputStream in = (InputStream)input;
            byte[] buf = new byte[512];
            while ((n = in.read(buf, 0, 512)) != -1) {
                md.update(buf, 0, n);
            }
        } else if (input instanceof File) {
            FileInputStream in = new FileInputStream((File)input);
            byte[] buf = new byte[512];
            try {
                int n;
                while ((n = ((InputStream)in).read(buf, 0, 512)) != -1) {
                    md.update(buf, 0, n);
                }
            }
            finally {
                ((InputStream)in).close();
            }
        } else if (input instanceof URL) {
            InputStream in = ((URL)input).openStream();
            byte[] buf = new byte[512];
            try {
                int n;
                while ((n = in.read(buf, 0, 512)) != -1) {
                    md.update(buf, 0, n);
                }
            }
            finally {
                in.close();
            }
        } else if (input instanceof String) {
            String str = (String)input;
            char[] chars = str.toCharArray();
            int len = chars.length;
            byte[] b = new byte[len * 2];
            for (int i = 0; i < len; ++i) {
                b[i * 2] = (byte)(chars[i] >> 8 & 0xFF);
                b[i * 2 + 1] = (byte)(chars[i] & 0xFF);
            }
            md.update(b, 0, b.length);
        } else if (input instanceof byte[]) {
            byte[] b = (byte[])input;
            md.update(b, 0, b.length);
        } else {
            throw new IllegalArgumentException();
        }
        return md.digest();
    }

    public static byte[] digest(MessageDigest md, byte[] input, int offset, int size2) {
        md.reset();
        md.update(input, offset, size2);
        return md.digest();
    }
}

