/*
 * Decompiled with CFR 0.152.
 */
package pnuts.io;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import pnuts.lang.Context;
import pnuts.lang.PnutsException;

public class CharacterEncoding {
    private static final String INPUT_CHARACTER_ENCODING = "pnuts$io$characterEncoding$in".intern();
    private static final String OUTPUT_CHARACTER_ENCODING = "pnuts$io$characterEncoding$out".intern();

    public static Reader getReader(InputStream in, Context context) {
        return CharacterEncoding.getReader(in, null, context);
    }

    public static Reader getReader(InputStream in, String enc, Context context) {
        if (enc == null) {
            enc = (String)context.get(INPUT_CHARACTER_ENCODING);
        }
        if (enc != null) {
            try {
                return new InputStreamReader(in, enc);
            }
            catch (UnsupportedEncodingException e) {
                throw new PnutsException((Throwable)e, context);
            }
        }
        return new InputStreamReader(in);
    }

    public static Writer getWriter(OutputStream out, Context context) {
        return CharacterEncoding.getWriter(out, null, context);
    }

    public static Writer getWriter(OutputStream out, String enc, Context context) {
        if (enc == null) {
            enc = (String)context.get(OUTPUT_CHARACTER_ENCODING);
        }
        if (enc != null) {
            try {
                return new OutputStreamWriter(out, enc);
            }
            catch (UnsupportedEncodingException e) {
                throw new PnutsException((Throwable)e, context);
            }
        }
        return new OutputStreamWriter(out);
    }

    public static void setCharacterEncoding(String in, String out, Context context) {
        context.set(INPUT_CHARACTER_ENCODING, (Object)in);
        context.set(OUTPUT_CHARACTER_ENCODING, (Object)out);
    }

    public static String[] getCharacterEncoding(Context context) {
        return new String[]{(String)context.get(INPUT_CHARACTER_ENCODING), (String)context.get(OUTPUT_CHARACTER_ENCODING)};
    }
}

