/*
 * Decompiled with CFR 0.152.
 */
package pnuts.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Label;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Stack;
import pnuts.awt.Layout;
import pnuts.awt.LayoutException;
import pnuts.awt.PnutsLayout;

public class PnutsLayoutMapping
extends Layout {
    static Class[] paramType = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PnutsLayoutMapping.class$("java.lang.String")) : class$java$lang$String};
    Stack prototypeOfLabel = new Stack();
    private static Class jlabelClass = null;
    private static boolean jLabelFlg = false;
    private static final String[] swingPkgNames = new String[]{"com.sun.java.swing", "javax.swing"};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Label;

    private static Class findJLabelClass(String pkgName) {
        if (!jLabelFlg) {
            jLabelFlg = true;
            try {
                jlabelClass = Class.forName(pkgName + ".JLabel");
                return jlabelClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return jlabelClass;
    }

    Component getPrototypeOfLabel() {
        if (this.prototypeOfLabel.size() > 0) {
            return (Component)this.prototypeOfLabel.peek();
        }
        return null;
    }

    Component makeLabel(String str, Container hint) {
        try {
            Object prototypeOfPanel = null;
            Component prototype = this.getPrototypeOfLabel();
            if (prototype != null) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bout);
                out.writeObject(prototype);
                ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
                ObjectInputStream in = new ObjectInputStream(bin);
                Component c = (Component)in.readObject();
                Method m = c.getClass().getMethod("setText", paramType);
                m.invoke((Object)c, str);
                return c;
            }
            if (hint != null) {
                return this.createLabel(str, hint);
            }
            return new Label(str);
        }
        catch (Exception e) {
            throw new LayoutException("can't create Label");
        }
    }

    Component createLabel(String str, Component hint) {
        String name = hint.getClass().getName();
        Object[] params = new Object[]{str};
        Class cl = null;
        try {
            int type = -1;
            if (name.startsWith(swingPkgNames[0])) {
                type = 0;
            } else if (name.startsWith(swingPkgNames[1])) {
                type = 1;
            }
            if (type == 0 || type == 1) {
                cl = PnutsLayoutMapping.findJLabelClass(swingPkgNames[type]);
                if (cl == null) {
                    cl = class$java$awt$Label == null ? (class$java$awt$Label = PnutsLayoutMapping.class$("java.awt.Label")) : class$java$awt$Label;
                }
            } else {
                cl = class$java$awt$Label == null ? (class$java$awt$Label = PnutsLayoutMapping.class$("java.awt.Label")) : class$java$awt$Label;
            }
            Constructor con = cl.getConstructor(paramType);
            return (Component)con.newInstance(params);
        }
        catch (Exception e) {
            throw new LayoutException("can't create Label object");
        }
    }

    void markLabel(Component label) {
        if (label instanceof Label) {
            this.prototypeOfLabel.setElementAt(label, this.prototypeOfLabel.size() - 1);
        } else {
            try {
                String name = label.getClass().getName();
                Class cl = null;
                int type = -1;
                if (name.startsWith(swingPkgNames[0])) {
                    type = 0;
                } else if (name.startsWith(swingPkgNames[1])) {
                    type = 1;
                }
                if (type == 0 || type == 1) {
                    cl = PnutsLayoutMapping.findJLabelClass(swingPkgNames[type]);
                }
                if (cl != null && cl.isInstance(label)) {
                    this.prototypeOfLabel.setElementAt(label, this.prototypeOfLabel.size() - 1);
                }
            }
            catch (Exception e) {
                throw new LayoutException("can't create Label");
            }
        }
    }

    void initLabel(Container container) {
        if (this.prototypeOfLabel.size() == 0) {
            this.prototypeOfLabel.push(this.createLabel("", container));
        } else {
            this.prototypeOfLabel.push(this.prototypeOfLabel.peek());
        }
    }

    public Container createContainer(Container container, Object[] format2) {
        this.initLabel(container);
        if (!(format2[1] instanceof String)) {
            throw new LayoutException("Element after the PnutsLayout class must be a String.");
        }
        container.setLayout(new PnutsLayout((String)format2[1]));
        for (int i = 2; i < format2.length; ++i) {
            if (format2[i] == null) {
                container.add((Component)Layout.makePanel(container), "");
                continue;
            }
            if (format2[i] instanceof String) {
                container.add(this.makeLabel((String)format2[i], container), "");
                continue;
            }
            if (Layout.isArray(format2[i])) {
                Object addParam;
                Component compToAdd;
                Object[] a = (Object[])format2[i];
                if (a[0] == null) {
                    compToAdd = Layout.makePanel(container);
                    addParam = a[1];
                } else if (Layout.isArray(a[0])) {
                    compToAdd = Layout.layout(Layout.makePanel(container), (Object[])a[0]);
                    addParam = a[1];
                } else if (a[0] instanceof Class) {
                    compToAdd = Layout.layout(Layout.makePanel(container), a);
                    addParam = "";
                } else if (a[0] instanceof String) {
                    compToAdd = this.makeLabel((String)a[0], container);
                    addParam = a[1];
                } else if (a[0] instanceof Component) {
                    compToAdd = (Component)a[0];
                    addParam = a[1];
                    this.markLabel(compToAdd);
                } else {
                    throw new LayoutException("PnutsLayout requires array elements to contain a class, String, Component, array, or null.");
                }
                container.add(compToAdd, addParam);
                if (a[0] instanceof Class || a.length <= 2) continue;
                if (!(compToAdd instanceof Container)) {
                    throw new LayoutException("Component must be a Container when a third element is used: " + a[0]);
                }
                if (!(a[2] instanceof Object[])) {
                    throw new LayoutException("Third element must be an array: " + a[2]);
                }
                Layout.layout(compToAdd, (Object[])a[2]);
                continue;
            }
            if (format2[i] instanceof Component) {
                this.markLabel((Component)format2[i]);
                container.add((Component)format2[i], "");
                continue;
            }
            throw new LayoutException("PnutsLayout requires elements to be a String, Component, array, or null.");
        }
        this.prototypeOfLabel.pop();
        return container;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

