/*
 * Decompiled with CFR 0.152.
 */
package pnuts.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import pnuts.awt.LayoutException;

public class PnutsLayout
implements LayoutManager2,
Serializable {
    public static final int CENTER = 2;
    public static final int TOP = 4;
    public static final int BOTTOM = 8;
    public static final int LEFT = 16;
    public static final int RIGHT = 32;
    public static final int X = 64;
    public static final int Y = 128;
    public static final int NONE = 0;
    private final TableConstraints tableConstraints = new TableConstraints();
    private final Map cellConstraints = new HashMap();
    private int[] widths;
    private int[] heights;
    private int[] xExpand;
    private int[] yExpand;
    private int xExpandCount;
    private int yExpandCount;
    private int[] columnLeft;
    private int[] rowTop;
    private int[][][] cellSpacing;
    private int[] gridPosition_x = new int[8];
    private int[] gridPosition_y = new int[8];
    private Dimension preferredSize;
    private boolean valid = false;
    private int rows;
    private BorderPanel borderPanel;
    private static final Integer ZERO = new Integer(0);
    private static Integer[] integer = new Integer[33];

    public PnutsLayout() {
        this(1);
    }

    public PnutsLayout(int columns) {
        this.tableConstraints.setColumns(columns);
    }

    public PnutsLayout(String str) {
        this(PnutsLayout.str2table(str));
    }

    public PnutsLayout(Map map2) {
        this.tableConstraints.configure(map2);
    }

    public void setConstraints(Component comp, String str) {
        this.setConstraints(comp, new CellConstraints(PnutsLayout.str2table(str)));
    }

    public void setConstraints(Component comp, Map map2) {
        this.setConstraints(comp, new CellConstraints(map2));
    }

    public void setConstraints(Component comp, CellConstraints constraints) {
        this.cellConstraints.put(comp, constraints);
        this.invalidate();
    }

    private void bindContainer(Container target) {
        int i;
        int j;
        int i2;
        int rowspan;
        int colspan;
        CellConstraints constraints;
        Component comp;
        int i3;
        int columnCount = this.tableConstraints.getColumns();
        BitSet[] map2 = new BitSet[columnCount];
        for (int i4 = 0; i4 < columnCount; ++i4) {
            map2[i4] = new BitSet();
        }
        int compCount = target.getComponentCount();
        this.gridPosition_x = new int[compCount * 2];
        this.gridPosition_y = new int[compCount * 2];
        this.rows = 0;
        int gridX = 0;
        int gridY = 0;
        for (i3 = 0; i3 < compCount; ++i3) {
            comp = target.getComponent(i3);
            if (comp instanceof BorderPanel) continue;
            constraints = (CellConstraints)this.cellConstraints.get(comp);
            colspan = constraints.getColspan();
            rowspan = constraints.getRowspan();
            while (!this.fit(gridX, gridY, colspan, rowspan, map2)) {
                if (++gridX < columnCount) continue;
                gridX = 0;
                ++gridY;
            }
            this.gridPosition_y[i3] = gridY;
            this.gridPosition_x[i3] = gridX;
            for (int jj = 0; jj < colspan; ++jj) {
                for (int kk = 0; kk < rowspan; ++kk) {
                    map2[gridX + jj].set(gridY + kk);
                }
            }
            if (this.rows < gridY + rowspan) {
                this.rows = gridY + rowspan;
            }
            if (++gridX < columnCount) continue;
            gridX = 0;
            ++gridY;
        }
        this.cellSpacing = new int[columnCount][this.rows][2];
        this.columnLeft = new int[columnCount + 1];
        this.rowTop = new int[this.rows + 1];
        this.widths = new int[columnCount];
        this.heights = new int[this.rows];
        this.yExpand = new int[this.rows];
        this.xExpand = new int[columnCount];
        gridX = 0;
        gridY = 0;
        for (i3 = 0; i3 < compCount; ++i3) {
            int ii;
            comp = target.getComponent(i3);
            if (comp instanceof BorderPanel) continue;
            constraints = (CellConstraints)this.cellConstraints.get(comp);
            gridY = this.gridPosition_y[i3];
            gridX = this.gridPosition_x[i3];
            colspan = constraints.getColspan();
            rowspan = constraints.getRowspan();
            int expand = constraints.getExpand();
            if ((expand & 0x40) != 0) {
                for (ii = 0; ii < colspan; ++ii) {
                    int n = gridX + ii;
                    this.xExpand[n] = this.xExpand[n] | 1;
                }
            }
            if ((expand & 0x80) != 0) {
                for (ii = 0; ii < rowspan; ++ii) {
                    int n = gridY + ii;
                    this.yExpand[n] = this.yExpand[n] | 1;
                }
            }
            if ((gridX += colspan) < columnCount) continue;
            gridX = 0;
            ++gridY;
        }
        boolean xFixed = (this.tableConstraints.getFixed() & 0x40) != 0;
        boolean yFixed = (this.tableConstraints.getFixed() & 0x80) != 0;
        int maxWidth = 0;
        int maxHeight = 0;
        boolean cellNeedsBorder = false;
        for (i2 = 0; i2 < compCount; ++i2) {
            int ii;
            Component comp2 = target.getComponent(i2);
            if (comp2 instanceof BorderPanel) continue;
            CellConstraints constraints2 = (CellConstraints)this.cellConstraints.get(comp2);
            int colspan2 = constraints2.getColspan();
            int rowspan2 = constraints2.getRowspan();
            if (constraints2.getBorder()) {
                cellNeedsBorder = true;
            }
            Dimension d = comp2.getPreferredSize();
            int[] ipadding = constraints2.getIPadding();
            int compWidth = d.width + ipadding[0];
            int compHeight = d.height + ipadding[1];
            int gridX2 = this.gridPosition_x[i2];
            int gridY2 = this.gridPosition_y[i2];
            int[] padding = (int[])constraints2.getPadding().clone();
            int[] spacing = (int[])constraints2.getSpacing().clone();
            if (gridY2 > 0) {
                spacing[0] = spacing[0] - this.cellSpacing[gridX2][gridY2 - 1][0];
                if (spacing[0] < 0) {
                    spacing[0] = 0;
                }
            }
            if (gridX2 > 0) {
                spacing[3] = spacing[3] - this.cellSpacing[gridX2 - 1][gridY2][1];
                if (spacing[3] < 0) {
                    spacing[3] = 0;
                }
            }
            for (int colOffset = 0; colOffset < colspan2; ++colOffset) {
                for (int rowOffset = 0; rowOffset < rowspan2; ++rowOffset) {
                    this.cellSpacing[gridX2 + colOffset][gridY2 + rowOffset][0] = spacing[2];
                    this.cellSpacing[gridX2 + colOffset][gridY2 + rowOffset][1] = spacing[1];
                }
            }
            padding[0] = padding[0] + spacing[0];
            padding[1] = padding[1] + spacing[1];
            padding[2] = padding[2] + spacing[2];
            padding[3] = padding[3] + spacing[3];
            compWidth += padding[1] + padding[3];
            int expand_count = 0;
            int no_expand_widths = 0;
            for (ii = 0; ii < colspan2; ++ii) {
                if ((this.xExpand[gridX2 + ii] & 1) != 0) {
                    ++expand_count;
                    continue;
                }
                no_expand_widths += this.widths[gridX2 + ii];
            }
            if (colspan2 == 1) {
                if (compWidth > this.widths[gridX2]) {
                    this.widths[gridX2] = compWidth;
                }
                if (maxWidth < this.widths[gridX2]) {
                    maxWidth = this.widths[gridX2];
                }
            } else {
                for (ii = 0; ii < colspan2; ++ii) {
                    int expandedWidth;
                    if ((this.xExpand[gridX2 + ii] & 1) != 0 && (expandedWidth = (compWidth - no_expand_widths) / expand_count) > this.widths[gridX2 + ii]) {
                        this.widths[gridX2 + ii] = expandedWidth;
                    }
                    if (!xFixed || maxWidth >= this.widths[gridX2 + ii]) continue;
                    maxWidth = this.widths[gridX2 + ii];
                }
            }
            if (this.heights[gridY2] >= (compHeight + padding[0] + padding[2]) / rowspan2) continue;
            this.heights[gridY2] = (compHeight + padding[0] + padding[2]) / rowspan2;
            if (!yFixed || maxHeight >= this.heights[gridY2]) continue;
            maxHeight = this.heights[gridY2];
        }
        if (xFixed) {
            for (i2 = 0; i2 < columnCount; ++i2) {
                this.widths[i2] = maxWidth;
            }
        }
        if (yFixed) {
            for (i2 = 0; i2 < this.rows; ++i2) {
                this.heights[i2] = maxHeight;
            }
        }
        int width = 0;
        int height = 0;
        for (j = 0; j < columnCount; ++j) {
            width += this.widths[j];
        }
        for (j = 0; j < this.rows; ++j) {
            height += this.heights[j];
        }
        Insets insets = target.getInsets();
        this.preferredSize = new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
        this.xExpandCount = 0;
        for (i = 0; i < this.xExpand.length; ++i) {
            if ((this.xExpand[i] & 1) == 0) continue;
            ++this.xExpandCount;
        }
        this.yExpandCount = 0;
        for (i = 0; i < this.yExpand.length; ++i) {
            if ((this.yExpand[i] & 1) == 0) continue;
            ++this.yExpandCount;
        }
        if (cellNeedsBorder || this.tableConstraints.getBorder()) {
            this.borderPanel = new BorderPanel();
            target.add(this.borderPanel);
        }
        this.valid = true;
    }

    public void layoutContainer(Container target) {
        int i;
        int h;
        int w;
        int columnCount = this.tableConstraints.getColumns();
        int compCount = target.getComponentCount();
        if (!this.valid) {
            this.bindContainer(target);
        }
        int targetWidth = target.getSize().width;
        int targetHeight = target.getSize().height;
        int aw = 0;
        int ah = 0;
        if (this.xExpandCount > 0) {
            aw = (targetWidth - this.preferredSize.width) / this.xExpandCount;
        }
        if (this.yExpandCount > 0) {
            ah = (targetHeight - this.preferredSize.height) / this.yExpandCount;
        }
        Insets insets = target.getInsets();
        this.columnLeft[0] = w = insets.left;
        for (int i2 = 1; i2 <= columnCount; ++i2) {
            this.columnLeft[i2] = this.columnLeft[i2 - 1] + this.widths[i2 - 1];
            if ((this.xExpand[i2 - 1] & 1) == 0) continue;
            int n = i2;
            this.columnLeft[n] = this.columnLeft[n] + aw;
        }
        this.rowTop[0] = h = insets.top;
        for (i = 1; i <= this.rows; ++i) {
            this.rowTop[i] = this.rowTop[i - 1] + this.heights[i - 1];
            if ((this.yExpand[i - 1] & 1) == 0) continue;
            int n = i;
            this.rowTop[n] = this.rowTop[n] + ah;
        }
        for (i = 0; i < compCount; ++i) {
            Component comp = target.getComponent(i);
            if (comp instanceof BorderPanel) continue;
            CellConstraints constraints = (CellConstraints)this.cellConstraints.get(comp);
            int colspan = constraints.getColspan();
            int rowspan = constraints.getRowspan();
            int align = constraints.getAlign();
            int[] fill = constraints.getFill();
            Dimension d = comp.getPreferredSize();
            int[] ipadding = constraints.getIPadding();
            int compWidth = d.width + ipadding[0];
            int compHeight = d.height + ipadding[1];
            int gridX = this.gridPosition_x[i];
            int gridY = this.gridPosition_y[i];
            int[] padding = (int[])constraints.getPadding().clone();
            int[] spacing = (int[])constraints.getSpacing().clone();
            if (gridY > 0) {
                spacing[0] = spacing[0] - this.cellSpacing[gridX][gridY - 1][0];
                if (spacing[0] < 0) {
                    spacing[0] = 0;
                }
            }
            if (gridX > 0) {
                spacing[3] = spacing[3] - this.cellSpacing[gridX - 1][gridY][1];
                if (spacing[3] < 0) {
                    spacing[3] = 0;
                }
            }
            for (int colOffset = 0; colOffset < colspan; ++colOffset) {
                for (int rowOffset = 0; rowOffset < rowspan; ++rowOffset) {
                    this.cellSpacing[gridX + colOffset][gridY + rowOffset][0] = spacing[2];
                    this.cellSpacing[gridX + colOffset][gridY + rowOffset][1] = spacing[1];
                }
            }
            padding[0] = padding[0] + spacing[0];
            padding[1] = padding[1] + spacing[1];
            padding[2] = padding[2] + spacing[2];
            padding[3] = padding[3] + spacing[3];
            if (fill[0] > 0) {
                compWidth = (int)((float)(this.columnLeft[gridX + colspan] - this.columnLeft[gridX] - (padding[3] + padding[1])) * ((float)fill[0] / 100.0f));
            }
            if (fill[1] > 0) {
                compHeight = (int)((float)(this.rowTop[gridY + rowspan] - this.rowTop[gridY] - (padding[0] + padding[2])) * ((float)fill[1] / 100.0f));
            }
            int x = (align & 0x10) != 0 ? this.columnLeft[gridX] + padding[3] : ((align & 0x20) != 0 ? this.columnLeft[gridX + colspan] - compWidth - padding[1] : (this.columnLeft[gridX] + this.columnLeft[gridX + colspan] - compWidth + padding[3] - padding[1]) / 2);
            int y = (align & 4) != 0 ? this.rowTop[gridY] + padding[0] : ((align & 8) != 0 ? this.rowTop[gridY + rowspan] - compHeight - padding[2] : (this.rowTop[gridY] + this.rowTop[gridY + rowspan] - compHeight + padding[0] - padding[2]) / 2);
            comp.setBounds(x, y, compWidth, compHeight);
        }
        if (this.borderPanel != null) {
            this.borderPanel.setSize(target.getSize());
        }
    }

    private boolean fit(int x, int y, int colspan, int rowspan, BitSet[] map2) {
        for (int i = 0; i < colspan; ++i) {
            for (int j = 0; j < rowspan; ++j) {
                if (x + i >= this.tableConstraints.getColumns()) {
                    return false;
                }
                if (!map2[x + i].get(y + j)) continue;
                return false;
            }
        }
        return true;
    }

    public int getRows() {
        if (!this.valid) {
            throw new RuntimeException("PnutsLayout has not been realized.");
        }
        return this.rows;
    }

    public TableConstraints getTableConstraints() {
        return this.tableConstraints;
    }

    public TableConstraints getCellConstraints(Component comp) {
        return (TableConstraints)this.cellConstraints.get(comp);
    }

    public Point getGridPoint(int gridX, int gridY) {
        if (!this.valid) {
            return null;
        }
        return new Point(this.columnLeft[gridX], this.rowTop[gridY]);
    }

    public Rectangle getGridRectangle(Container parent, int index) {
        if (!this.valid) {
            return null;
        }
        int gridX = this.gridPosition_x[index];
        int gridY = this.gridPosition_y[index];
        int cellWidth = this.columnLeft[gridX];
        int cellHeight = this.rowTop[gridY];
        CellConstraints constraints = (CellConstraints)this.cellConstraints.get(parent.getComponent(index));
        int colspan = constraints.getColspan();
        int rowspan = constraints.getRowspan();
        return new Rectangle(cellWidth, cellHeight, this.columnLeft[gridX + colspan] - cellWidth, this.rowTop[gridY + rowspan] - cellHeight);
    }

    public void addLayoutComponent(Component comp, Object obj) {
        if (obj instanceof Map) {
            this.setConstraints(comp, (Map)obj);
        } else if (obj instanceof String) {
            this.setConstraints(comp, (String)obj);
        }
    }

    public Dimension preferredLayoutSize(Container target) {
        if (!this.valid) {
            this.bindContainer(target);
        }
        return this.preferredSize;
    }

    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    public Dimension maximumLayoutSize(Container target) {
        return target.getMaximumSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        PnutsLayout pnutsLayout = this;
        synchronized (pnutsLayout) {
            if (!this.valid) {
                return;
            }
            this.valid = false;
        }
        if (this.borderPanel != null) {
            Container parent = this.borderPanel.getParent();
            if (parent != null) {
                parent.remove(this.borderPanel);
            }
            this.borderPanel = null;
        }
    }

    public void invalidateLayout(Container target) {
        this.invalidate();
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getTableConstraints() + "]";
    }

    static Map str2table(String constraintString) {
        HashMap<String, String> table = new HashMap<String, String>();
        StringTokenizer constraints = new StringTokenizer(constraintString, ",");
        while (constraints.hasMoreTokens()) {
            String token = constraints.nextToken();
            if (constraintString.indexOf(61) == -1) {
                throw new LayoutException("Invalid constraint name/value pair: " + token);
            }
            StringTokenizer nameValue = new StringTokenizer(token, "=");
            String name = nameValue.nextToken();
            String value = null;
            if (nameValue.hasMoreTokens()) {
                value = nameValue.nextToken().trim();
            }
            table.put(name.trim(), value);
        }
        return table;
    }

    private static Integer getInteger(int i) {
        if (i < 32) {
            return integer[i];
        }
        return new Integer(i);
    }

    private static Integer getInteger(Object obj) {
        if (obj == null) {
            return null;
        }
        return PnutsLayout.getInteger(Integer.parseInt((String)obj));
    }

    private static Integer[] getIntegerArray(Object obj, int length) {
        if (obj == null) {
            return null;
        }
        String str = (String)obj;
        if (str.indexOf(58) == -1) {
            Integer value = PnutsLayout.getInteger(str);
            return new Integer[]{value, value, value, value};
        }
        Integer[] array = new Integer[length];
        StringTokenizer st = new StringTokenizer(str, ":");
        for (int i = 0; i < length; ++i) {
            if (st.hasMoreTokens()) {
                String value = st.nextToken();
                array[i] = PnutsLayout.getInteger(Integer.parseInt(value));
                continue;
            }
            array[i] = ZERO;
        }
        return array;
    }

    static {
        for (int i = 0; i < integer.length; ++i) {
            PnutsLayout.integer[i] = new Integer(i);
        }
    }

    private class BorderPanel
    extends JPanel {
        public BorderPanel() {
            this.setOpaque(false);
        }

        public void paint(Graphics g) {
            Container target = this.getParent();
            int n = target.getComponentCount();
            for (int i = 0; i < n; ++i) {
                CellConstraints constraints;
                Component comp = target.getComponent(i);
                if (comp instanceof BorderPanel || !(constraints = (CellConstraints)PnutsLayout.this.cellConstraints.get(comp)).getBorder()) continue;
                int colspan = constraints.getColspan();
                int rowspan = constraints.getRowspan();
                int gridX = PnutsLayout.this.gridPosition_x[i];
                int gridY = PnutsLayout.this.gridPosition_y[i];
                int x = PnutsLayout.this.columnLeft[gridX];
                int y = PnutsLayout.this.rowTop[gridY];
                int width = PnutsLayout.this.columnLeft[gridX + colspan] - x;
                int height = PnutsLayout.this.rowTop[gridY + rowspan] - y;
                g.drawRect(x, y, width, height);
            }
        }
    }

    public class CellConstraints
    extends Constraints {
        private int colspan = 1;
        private int rowspan = 1;

        public CellConstraints() {
        }

        public CellConstraints(Map map2) {
            this.configure(map2);
        }

        public void configure(Map map2) {
            super.configure(map2);
            if (map2.get("colspan") != null) {
                this.setColspan(Integer.parseInt((String)map2.get("colspan")));
            }
            if (map2.get("rowspan") != null) {
                this.setRowspan(Integer.parseInt((String)map2.get("rowspan")));
            }
        }

        public int getRowspan() {
            return this.rowspan;
        }

        public void setRowspan(int rowspan) {
            if (rowspan <= 0) {
                throw new IndexOutOfBoundsException("rowspan cannot be less than 1.");
            }
            this.rowspan = rowspan;
            PnutsLayout.this.invalidate();
        }

        public int getColspan() {
            return this.colspan;
        }

        public void setColspan(int colspan) {
            if (colspan <= 0) {
                throw new IndexOutOfBoundsException("colspan cannot be less than 1.");
            }
            this.colspan = colspan;
            PnutsLayout.this.invalidate();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(150);
            buffer.append("colspan=");
            buffer.append(this.getColspan());
            buffer.append(", rowspan=");
            buffer.append(this.getRowspan());
            buffer.append(", ");
            buffer.append(super.toString());
            return buffer.toString();
        }
    }

    public class TableConstraints
    extends Constraints {
        private int columns = 1;
        private int fixed = 0;

        public TableConstraints() {
            this.setAlign(PnutsLayout.getInteger(2));
            this.setExpand(PnutsLayout.getInteger(0));
            this.setIPadding(new Integer[]{ZERO, ZERO});
            this.setFill(new Integer[]{ZERO, ZERO});
            this.setSpacing(new Integer[]{ZERO, ZERO, ZERO, ZERO});
            this.setPadding(new Integer[]{ZERO, ZERO, ZERO, ZERO});
            this.setBorder(Boolean.FALSE);
        }

        public TableConstraints(Map map2) {
            this();
            this.configure(map2);
        }

        public void configure(Map map2) {
            super.configure(map2);
            if (map2.get("columns") != null) {
                this.setColumns(Integer.parseInt((String)map2.get("columns")));
            }
            if (map2.get("uniform") != null) {
                this.setFixed((String)map2.get("colspan"));
            }
            if (map2.get("columns") == null && map2.get("cols") != null) {
                this.setColumns(Integer.parseInt((String)map2.get("cols")));
            }
        }

        public int getColumns() {
            return this.columns;
        }

        public void setColumns(int columns) {
            this.columns = columns;
            PnutsLayout.this.invalidate();
        }

        public int getFixed() {
            return this.fixed;
        }

        public void setFixed(int fixed) {
            this.fixed = fixed;
            PnutsLayout.this.invalidate();
        }

        public void setFixed(String expandString) {
            if ("x".equalsIgnoreCase(expandString)) {
                this.setFixed(64);
            } else if ("y".equalsIgnoreCase(expandString)) {
                this.setFixed(128);
            } else if ("xy".equalsIgnoreCase(expandString)) {
                this.setFixed(192);
            } else {
                this.setFixed(0);
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(150);
            buffer.append("columns=");
            buffer.append(this.getColumns());
            int fixed = this.getFixed();
            String fixedString = "";
            if ((fixed & 0x40) != 0) {
                fixedString = fixedString + "x";
            }
            if ((fixed & 0x80) != 0) {
                fixedString = fixedString + "y";
            }
            if (fixedString.length() > 0) {
                buffer.append(", uniform=");
                buffer.append(fixedString);
            }
            buffer.append(", ");
            buffer.append(super.toString());
            return buffer.toString();
        }
    }

    public abstract class Constraints {
        private Integer[] padding;
        private Integer[] spacing;
        private Integer[] ipadding;
        private Integer[] fill;
        private Integer align;
        private Integer expand;
        private Boolean border;

        public void configure(Map map2) {
            this.setSpacing(PnutsLayout.getIntegerArray(map2.get("spacing"), 4));
            this.setPadding(PnutsLayout.getIntegerArray(map2.get("padding"), 4));
            this.setIPadding(PnutsLayout.getIntegerArray(map2.get("ipadding"), 2));
            this.setAlign((String)map2.get("align"));
            this.setExpand((String)map2.get("expand"));
            this.setFill((String)map2.get("fill"));
            String border = (String)map2.get("border");
            if (border != null) {
                this.setBorder(new Boolean("true".equals(border)));
            }
            if (map2.get("padding") == null) {
                Integer padx = PnutsLayout.getInteger(map2.get("padx"));
                Integer pady = PnutsLayout.getInteger(map2.get("pady"));
                if (padx != null || pady != null) {
                    if (pady == null) {
                        pady = ZERO;
                    }
                    if (padx == null) {
                        padx = ZERO;
                    }
                    this.setPadding(new Integer[]{pady, padx, pady, padx});
                }
            }
            if (map2.get("ipadding") == null) {
                Integer ipadx = PnutsLayout.getInteger(map2.get("ipadx"));
                Integer ipady = PnutsLayout.getInteger(map2.get("ipady"));
                if (ipadx != null || ipady != null) {
                    if (ipady == null) {
                        ipady = ZERO;
                    }
                    if (ipadx == null) {
                        ipadx = ZERO;
                    }
                    this.setIPadding(new Integer[]{ipadx, ipady});
                }
            }
            if (map2.get("align") == null) {
                String halign;
                String valign = (String)map2.get("valign");
                if ("fill".equals(valign)) {
                    this.setFill(new Integer[]{PnutsLayout.getInteger(this.getFill()[0]), PnutsLayout.getInteger(100)});
                    valign = null;
                }
                if ("fill".equals(halign = (String)map2.get("halign"))) {
                    this.setFill(new Integer[]{PnutsLayout.getInteger(100), PnutsLayout.getInteger(this.getFill()[1])});
                    halign = null;
                }
                String alignString = null;
                if (valign != null && halign != null) {
                    alignString = valign + ':' + halign;
                } else if (valign != null) {
                    alignString = valign;
                } else if (halign != null) {
                    alignString = halign;
                }
                if (alignString != null) {
                    this.setAlign(alignString);
                }
            }
        }

        public int getAlign() {
            if (this.align == null) {
                return PnutsLayout.this.tableConstraints.getAlign();
            }
            return this.align;
        }

        public void setAlign(Integer align) {
            if (align == null && this == PnutsLayout.this.tableConstraints) {
                return;
            }
            this.align = align;
            PnutsLayout.this.invalidate();
        }

        public void setAlign(String alignString) {
            String halign;
            String valign;
            if (alignString == null || alignString.length() == 0) {
                this.setAlign((Integer)null);
                return;
            }
            StringTokenizer st = new StringTokenizer(alignString, ":");
            if (st.countTokens() == 2) {
                valign = st.nextToken();
                halign = st.nextToken();
            } else {
                valign = alignString;
                halign = alignString;
            }
            int align = "left".equalsIgnoreCase(halign) ? 16 : ("right".equalsIgnoreCase(halign) ? 32 : 2);
            align = "top".equalsIgnoreCase(valign) ? (align |= 4) : ("bottom".equalsIgnoreCase(valign) ? (align |= 8) : (align |= 2));
            this.setAlign(PnutsLayout.getInteger(align));
        }

        public int getExpand() {
            if (this.expand == null) {
                return PnutsLayout.this.tableConstraints.getExpand();
            }
            return this.expand;
        }

        public void setExpand(Integer expand) {
            if (expand == null && this == PnutsLayout.this.tableConstraints) {
                return;
            }
            this.expand = expand;
            PnutsLayout.this.invalidate();
        }

        public void setExpand(String expandString) {
            if ("x".equalsIgnoreCase(expandString)) {
                this.setExpand(PnutsLayout.getInteger(64));
            } else if ("y".equalsIgnoreCase(expandString)) {
                this.setExpand(PnutsLayout.getInteger(128));
            } else if ("xy".equalsIgnoreCase(expandString)) {
                this.setExpand(PnutsLayout.getInteger(192));
            } else if ("none".equalsIgnoreCase(expandString)) {
                this.setExpand(PnutsLayout.getInteger(0));
            } else {
                this.setExpand((Integer)null);
            }
        }

        public void setFill(String fillString) {
            if ("x".equalsIgnoreCase(fillString)) {
                this.setFill(new Integer[]{PnutsLayout.getInteger(100), ZERO});
            } else if ("y".equalsIgnoreCase(fillString)) {
                this.setFill(new Integer[]{ZERO, PnutsLayout.getInteger(100)});
            } else if ("xy".equalsIgnoreCase(fillString)) {
                this.setFill(new Integer[]{PnutsLayout.getInteger(100), PnutsLayout.getInteger(100)});
            } else if ("none".equalsIgnoreCase(fillString)) {
                this.setFill(new Integer[]{ZERO, ZERO});
            } else {
                this.setFill(PnutsLayout.getIntegerArray(fillString, 2));
            }
        }

        public int[] getIPadding() {
            if (this.ipadding == null) {
                return PnutsLayout.this.tableConstraints.getIPadding();
            }
            return new int[]{this.ipadding[0], this.ipadding[1]};
        }

        public void setIPadding(Integer[] ipadding) {
            if (ipadding == null && this == PnutsLayout.this.tableConstraints) {
                return;
            }
            this.ipadding = ipadding;
            PnutsLayout.this.invalidate();
        }

        public int[] getPadding() {
            if (this.padding == null) {
                return PnutsLayout.this.tableConstraints.getPadding();
            }
            return new int[]{this.padding[0], this.padding[1], this.padding[2], this.padding[3]};
        }

        public void setPadding(Integer[] padding) {
            if (padding == null && this == PnutsLayout.this.tableConstraints) {
                return;
            }
            this.padding = padding;
            PnutsLayout.this.invalidate();
        }

        public int[] getSpacing() {
            if (this.spacing == null) {
                return PnutsLayout.this.tableConstraints.getSpacing();
            }
            return new int[]{this.spacing[0], this.spacing[1], this.spacing[2], this.spacing[3]};
        }

        public void setSpacing(Integer[] spacing) {
            if (spacing == null && this == PnutsLayout.this.tableConstraints) {
                return;
            }
            this.spacing = spacing;
            PnutsLayout.this.invalidate();
        }

        public boolean getBorder() {
            if (this.border == null) {
                return PnutsLayout.this.tableConstraints.getBorder();
            }
            return this.border;
        }

        public void setBorder(Boolean border) {
            if (border == null && this == PnutsLayout.this.tableConstraints) {
                return;
            }
            this.border = border;
            PnutsLayout.this.invalidate();
        }

        public int[] getFill() {
            if (this.fill == null) {
                return PnutsLayout.this.tableConstraints.getFill();
            }
            return new int[]{this.fill[0], this.fill[1]};
        }

        public void setFill(Integer[] fill) {
            if (fill == null && this == PnutsLayout.this.tableConstraints) {
                return;
            }
            this.fill = fill;
            PnutsLayout.this.invalidate();
        }

        public String toString() {
            int[] fill;
            int[] ipadding;
            int[] padding;
            int[] spacing;
            StringBuffer buffer = new StringBuffer(150);
            int align = this.getAlign();
            String valign = "";
            valign = (align & 4) != 0 ? "top" : ((align & 8) != 0 ? "bottom" : "center");
            String halign = "";
            halign = (align & 0x10) != 0 ? "left" : ((align & 0x20) != 0 ? "right" : "center");
            if (valign.equals(halign)) {
                if (!valign.equals("center")) {
                    buffer.append("align=");
                    buffer.append(valign);
                }
            } else {
                buffer.append("align=");
                buffer.append(valign);
                buffer.append(':');
                buffer.append(halign);
            }
            int expand = this.getExpand();
            String expandString = "";
            if ((expand & 0x40) != 0) {
                expandString = expandString + "x";
            }
            if ((expand & 0x80) != 0) {
                expandString = expandString + "y";
            }
            if (expandString.length() > 0) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append("expand=");
                buffer.append(expandString);
            }
            if ((spacing = this.getSpacing())[0] != 0 || spacing[1] != 0 || spacing[2] != 0 || spacing[3] != 0) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append("spacing=");
                if (spacing[0] == spacing[1] && spacing[1] == spacing[2] && spacing[2] == spacing[3]) {
                    buffer.append(spacing[0]);
                } else {
                    buffer.append(spacing[0]);
                    buffer.append(':');
                    buffer.append(spacing[1]);
                    buffer.append(':');
                    buffer.append(spacing[2]);
                    buffer.append(':');
                    buffer.append(spacing[3]);
                }
            }
            if ((padding = this.getPadding())[0] != 0 || padding[1] != 0 || padding[2] != 0 || padding[3] != 0) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append("padding=");
                if (padding[0] == padding[1] && padding[1] == padding[2] && padding[2] == padding[3]) {
                    buffer.append(padding[0]);
                } else {
                    buffer.append(padding[0]);
                    buffer.append(':');
                    buffer.append(padding[1]);
                    buffer.append(':');
                    buffer.append(padding[2]);
                    buffer.append(':');
                    buffer.append(padding[3]);
                }
            }
            if ((ipadding = this.getIPadding())[0] != 0 || ipadding[1] != 0) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append("ipadding=");
                if (ipadding[0] == ipadding[1]) {
                    buffer.append(ipadding[0]);
                } else {
                    buffer.append(ipadding[0]);
                    buffer.append(':');
                    buffer.append(ipadding[1]);
                }
            }
            if ((fill = this.getFill())[0] != 0 || fill[1] != 0) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append("fill=");
                if (fill[0] == fill[1]) {
                    buffer.append(fill[0]);
                } else {
                    buffer.append(fill[0]);
                    buffer.append(':');
                    buffer.append(fill[1]);
                }
            }
            if (this.getBorder()) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append("border=true");
            }
            return buffer.toString();
        }
    }
}

