/*
 * Decompiled with CFR 0.152.
 */
package pnuts.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Panel;
import java.awt.Window;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.swing.JScrollPane;
import pnuts.awt.LayoutException;

public abstract class Layout {
    private static Hashtable mappingTable = new Hashtable();
    private static final String swingPkgName = "javax.swing";
    private static Class jpanelClass;
    private static boolean jPanelFlg;
    static /* synthetic */ Class class$java$awt$BorderLayout;
    static /* synthetic */ Class class$pnuts$awt$BorderLayoutMapping;
    static /* synthetic */ Class class$java$awt$CardLayout;
    static /* synthetic */ Class class$pnuts$awt$CardLayoutMapping;
    static /* synthetic */ Class class$java$awt$GridLayout;
    static /* synthetic */ Class class$pnuts$awt$GridLayoutMapping;
    static /* synthetic */ Class class$java$awt$GridBagLayout;
    static /* synthetic */ Class class$pnuts$awt$GridBagLayoutMapping;
    static /* synthetic */ Class class$java$awt$FlowLayout;
    static /* synthetic */ Class class$pnuts$awt$FlowLayoutMapping;
    static /* synthetic */ Class class$pnuts$awt$PnutsLayout;
    static /* synthetic */ Class class$pnuts$awt$PnutsLayoutMapping;
    static /* synthetic */ Class class$pnuts$awt$Layout;
    static /* synthetic */ Class class$java$awt$Panel;
    static /* synthetic */ Class class$java$lang$String;

    private static Class findJPanelClass() {
        if (!jPanelFlg) {
            jPanelFlg = true;
            try {
                jpanelClass = Class.forName("javax.swing.JPanel");
                return jpanelClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return jpanelClass;
    }

    public static void registerLayoutManager(Class clazz, Class layout) {
        if ((class$pnuts$awt$Layout == null ? (class$pnuts$awt$Layout = Layout.class$("pnuts.awt.Layout")) : class$pnuts$awt$Layout).isAssignableFrom(layout)) {
            mappingTable.put(clazz, layout);
        }
    }

    protected static boolean isArray(Object obj) {
        return obj.getClass().isArray();
    }

    protected Layout() {
    }

    public abstract Container createContainer(Container var1, Object[] var2);

    public static Container layout(Object[] format2) {
        return Layout.layout(new Panel(), format2);
    }

    public static Container layout(Container container, Object[] fmt) {
        Component view;
        if (container instanceof JScrollPane && (view = ((JScrollPane)container).getViewport().getView()) != null && view instanceof Container) {
            container = (Container)view;
        }
        if (fmt[0] instanceof Class) {
            Layout layout = null;
            try {
                Object map2 = mappingTable.get(fmt[0]);
                if (map2 instanceof Layout) {
                    return ((Layout)map2).createContainer(container, fmt);
                }
                if (map2 instanceof Class) {
                    layout = (Layout)((Class)map2).newInstance();
                    mappingTable.put(fmt[0], layout);
                    return layout.createContainer(container, fmt);
                }
                throw new LayoutException("Mapping not defined: " + fmt[0]);
            }
            catch (Exception ex) {
                LayoutException layoutEx = new LayoutException(ex.getClass().getName() + ": " + ex.getMessage());
                ex.printStackTrace();
                layoutEx.initCause(ex);
                throw layoutEx;
            }
        }
        for (int i = 0; i < fmt.length; ++i) {
            Object c = fmt[i];
            if (c instanceof Component) {
                container.add((Component)c);
                continue;
            }
            if (c instanceof Object[]) {
                Object[] array = (Object[])c;
                if (!(array[0] instanceof Component)) {
                    throw new LayoutException("First element must be a Component: " + c);
                }
                if (array.length > 1) {
                    container.add((Component)array[0], array[1]);
                    if (array.length <= 2) continue;
                    if (!(array[0] instanceof Container)) {
                        throw new LayoutException("Component must be a Container when a third element is used: " + array[0]);
                    }
                    if (!(array[2] instanceof Object[])) {
                        throw new LayoutException("Third element must be an array: " + array[2]);
                    }
                    Layout.layout((Container)array[0], (Object[])array[2]);
                    continue;
                }
                container.add((Component)array[0]);
                continue;
            }
            throw new LayoutException("Element must be a Component or array: " + c);
        }
        return container;
    }

    protected static Container makePanel(Container prototype) {
        try {
            if (prototype == null) {
                return new Panel();
            }
            Class cl = prototype.getClass();
            boolean guiType = false;
            String name = cl.getName();
            if (name.startsWith(swingPkgName)) {
                guiType = true;
            }
            if (prototype instanceof Window) {
                if (guiType) {
                    cl = Layout.findJPanelClass();
                    if (cl == null) {
                        cl = class$java$awt$Panel == null ? (class$java$awt$Panel = Layout.class$("java.awt.Panel")) : class$java$awt$Panel;
                    }
                } else {
                    cl = class$java$awt$Panel == null ? (class$java$awt$Panel = Layout.class$("java.awt.Panel")) : class$java$awt$Panel;
                }
            }
            Container ret = (Container)cl.newInstance();
            ret.setForeground(prototype.getForeground());
            ret.setBackground(prototype.getBackground());
            ret.setCursor(prototype.getCursor());
            ret.setFont(prototype.getFont());
            if (guiType) {
                Method m = null;
                Class[] t_noarg = new Class[]{};
                Object[] noarg = new Object[]{};
                Class[] t_boolean = new Class[]{Boolean.TYPE};
                Class[] t_string = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Layout.class$("java.lang.String")) : class$java$lang$String};
                Class<?> clazz = prototype.getClass();
                Object val = null;
                m = clazz.getMethod("isDoubleBuffered", t_noarg);
                val = m.invoke((Object)prototype, noarg);
                m = cl.getMethod("setDoubleBuffered", t_boolean);
                m.invoke((Object)ret, val);
                m = clazz.getMethod("getToolTipText", t_noarg);
                val = m.invoke((Object)prototype, noarg);
                m = cl.getMethod("setToolTipText", t_string);
                m.invoke((Object)ret, val);
                m = clazz.getMethod("isOpaque", t_noarg);
                val = m.invoke((Object)prototype, noarg);
                m = cl.getMethod("setOpaque", t_boolean);
                m.invoke((Object)ret, val);
                m = clazz.getMethod("getAutoscrolls", t_noarg);
                val = m.invoke((Object)prototype, noarg);
                m = cl.getMethod("setAutoscrolls", t_boolean);
                m.invoke((Object)ret, val);
            }
            return ret;
        }
        catch (Exception e) {
            return new Panel();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Layout.registerLayoutManager(class$java$awt$BorderLayout == null ? (class$java$awt$BorderLayout = Layout.class$("java.awt.BorderLayout")) : class$java$awt$BorderLayout, class$pnuts$awt$BorderLayoutMapping == null ? (class$pnuts$awt$BorderLayoutMapping = Layout.class$("pnuts.awt.BorderLayoutMapping")) : class$pnuts$awt$BorderLayoutMapping);
        Layout.registerLayoutManager(class$java$awt$CardLayout == null ? (class$java$awt$CardLayout = Layout.class$("java.awt.CardLayout")) : class$java$awt$CardLayout, class$pnuts$awt$CardLayoutMapping == null ? (class$pnuts$awt$CardLayoutMapping = Layout.class$("pnuts.awt.CardLayoutMapping")) : class$pnuts$awt$CardLayoutMapping);
        Layout.registerLayoutManager(class$java$awt$GridLayout == null ? (class$java$awt$GridLayout = Layout.class$("java.awt.GridLayout")) : class$java$awt$GridLayout, class$pnuts$awt$GridLayoutMapping == null ? (class$pnuts$awt$GridLayoutMapping = Layout.class$("pnuts.awt.GridLayoutMapping")) : class$pnuts$awt$GridLayoutMapping);
        Layout.registerLayoutManager(class$java$awt$GridBagLayout == null ? (class$java$awt$GridBagLayout = Layout.class$("java.awt.GridBagLayout")) : class$java$awt$GridBagLayout, class$pnuts$awt$GridBagLayoutMapping == null ? (class$pnuts$awt$GridBagLayoutMapping = Layout.class$("pnuts.awt.GridBagLayoutMapping")) : class$pnuts$awt$GridBagLayoutMapping);
        Layout.registerLayoutManager(class$java$awt$FlowLayout == null ? (class$java$awt$FlowLayout = Layout.class$("java.awt.FlowLayout")) : class$java$awt$FlowLayout, class$pnuts$awt$FlowLayoutMapping == null ? (class$pnuts$awt$FlowLayoutMapping = Layout.class$("pnuts.awt.FlowLayoutMapping")) : class$pnuts$awt$FlowLayoutMapping);
        Layout.registerLayoutManager(class$pnuts$awt$PnutsLayout == null ? (class$pnuts$awt$PnutsLayout = Layout.class$("pnuts.awt.PnutsLayout")) : class$pnuts$awt$PnutsLayout, class$pnuts$awt$PnutsLayoutMapping == null ? (class$pnuts$awt$PnutsLayoutMapping = Layout.class$("pnuts.awt.PnutsLayoutMapping")) : class$pnuts$awt$PnutsLayoutMapping);
        jpanelClass = null;
        jPanelFlg = false;
    }
}

