/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.text;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import org.pnuts.io.URLHelper;
import org.pnuts.lib.PathHelper;
import org.pnuts.text.CallbackLineHandler;
import org.pnuts.text.CollectionLineHandler;
import org.pnuts.text.LineHandler;
import org.pnuts.text.LineProcessor;
import org.pnuts.text.LineReader;
import pnuts.io.CharacterEncoding;
import pnuts.lang.Context;
import pnuts.lang.Generator;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;

public class readLines
extends PnutsFunction {
    public readLines() {
        super("readLines");
    }

    public boolean defined(int narg) {
        return narg >= 1 && narg <= 3;
    }

    static LineProcessor getLineProcessor(Object arg, LineHandler handler, Context context) throws IOException {
        if (arg instanceof InputStream) {
            return new LineReader(CharacterEncoding.getReader((InputStream)arg, context), handler, false);
        }
        if (arg instanceof Reader) {
            return new LineReader((Reader)arg, handler, false);
        }
        if (arg instanceof File) {
            return new LineReader(CharacterEncoding.getReader(new FileInputStream((File)arg), context), handler, true);
        }
        if (arg instanceof String) {
            return new LineReader(CharacterEncoding.getReader(new FileInputStream(PathHelper.getFile((String)arg, context)), context), handler, true);
        }
        if (arg instanceof URL) {
            return new LineReader(URLHelper.getReader((URL)arg, context), handler, true);
        }
        throw new IllegalArgumentException();
    }

    static LineHandler getLineHandler(Object arg, Context context) {
        if (arg instanceof PnutsFunction) {
            return new CallbackLineHandler((PnutsFunction)arg, context);
        }
        if (arg instanceof Collection) {
            return new CollectionLineHandler((Collection)arg);
        }
        if (arg == null) {
            return new LineHandler(){

                public void process(char[] c, int offset, int length) {
                }
            };
        }
        throw new IllegalArgumentException();
    }

    protected Object exec(Object[] args, Context context) {
        boolean includeNewLine = false;
        final Object arg0 = args[0];
        LineProcessor lineReader = null;
        switch (args.length) {
            case 3: {
                includeNewLine = (Boolean)args[2];
            }
            case 2: {
                try {
                    LineHandler handler = readLines.getLineHandler(args[1], context);
                    if (arg0 instanceof String || arg0 instanceof File || arg0 instanceof URL) {
                        // empty if block
                    }
                    lineReader = readLines.getLineProcessor(arg0, handler, context);
                    return new Integer(lineReader.processAll(includeNewLine));
                }
                catch (IOException e) {
                    throw new PnutsException((Throwable)e, context);
                }
            }
            case 1: {
                final boolean newline = includeNewLine;
                return new Generator(){

                    public Object apply(PnutsFunction closure, Context context) {
                        LineProcessor lineReader = null;
                        try {
                            lineReader = readLines.getLineProcessor(arg0, readLines.getLineHandler(closure, context), context);
                            lineReader.processAll(newline);
                        }
                        catch (IOException e) {
                            throw new PnutsException((Throwable)e, context);
                        }
                        return null;
                    }
                };
            }
        }
        this.undefined(args, context);
        return null;
    }

    public String toString() {
        return "function readLines((inputStream|reader|file|fileName|url) {, (func(line) | collection) {, includeNewLine }} )";
    }
}

