/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletRequest;
import pnuts.lang.Context;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;
import pnuts.servlet.MimeInputStream;
import pnuts.servlet.MultipartInputStream;
import pnuts.servlet.PnutsServlet;

public class readMultipartRequest
extends PnutsFunction {
    public readMultipartRequest() {
        super("readMultipartRequest");
    }

    public boolean defined(int narg) {
        return narg == 1 || narg == 2;
    }

    protected Object exec(Object[] args, Context context) {
        PnutsFunction handler;
        ServletRequest request;
        int nargs = args.length;
        if (nargs == 1) {
            request = (ServletRequest)context.get(PnutsServlet.SERVLET_REQUEST);
            handler = (PnutsFunction)args[0];
        } else if (nargs == 2) {
            request = (ServletRequest)args[0];
            handler = (PnutsFunction)args[1];
        } else {
            this.undefined(args, context);
            return null;
        }
        String type = request.getContentType();
        String name = null;
        int idx = type.lastIndexOf("boundary=");
        if (idx < 0) {
            return null;
        }
        byte[] boundary = type.substring(idx + 9).getBytes();
        try {
            MultipartInputStream multi = new MultipartInputStream((InputStream)request.getInputStream(), boundary);
            while (multi.next()) {
                int n;
                MimeInputStream mime = new MimeInputStream(multi);
                String cdisp = mime.getHeader("content-disposition");
                String ctype = mime.getHeader("content-type");
                String filename = null;
                StringTokenizer st = new StringTokenizer(cdisp, ";");
                while (st.hasMoreTokens()) {
                    int len;
                    String value;
                    String token = st.nextToken();
                    idx = token.indexOf(61);
                    if (idx <= 0) continue;
                    String key = token.substring(0, idx).trim();
                    if ("filename".equals(key)) {
                        filename = value = token.substring(idx + 1).trim();
                        len = value.length();
                        if (len <= 1 || value.charAt(0) != '\"' || value.charAt(len - 1) != '\"') continue;
                        filename = value.substring(1, len - 1);
                        continue;
                    }
                    if (!"name".equals(key)) continue;
                    name = value = token.substring(idx + 1).trim();
                    len = value.length();
                    if (len <= 1 || value.charAt(0) != '\"' || value.charAt(len - 1) != '\"') continue;
                    name = value.substring(1, len - 1);
                }
                if (filename != null) {
                    handler.call(new Object[]{mime, name, filename, ctype}, context);
                    continue;
                }
                Hashtable<String, Object[]> param = (Hashtable<String, Object[]>)context.get(PnutsServlet.SERVLET_MULTIPART_PARAM);
                if (param == null) {
                    param = new Hashtable<String, Object[]>();
                    context.set(PnutsServlet.SERVLET_MULTIPART_PARAM, param);
                }
                ByteArrayOutputStream ba = new ByteArrayOutputStream();
                byte[] buf = new byte[512];
                while ((n = mime.read(buf)) != -1) {
                    ba.write(buf, 0, n);
                }
                Vector val = (Vector)param.get(name);
                byte[] barray = ba.toByteArray();
                if (val == null) {
                    param.put(name, new Object[]{barray});
                    continue;
                }
                val.addElement(barray);
            }
            return null;
        }
        catch (IOException e) {
            throw new PnutsException((Throwable)e, context);
        }
    }

    public String toString() {
        return "function readMultipartRequest( { request, } handler(mime, name, filename, ctype))";
    }
}

