/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.servlet;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import org.pnuts.servlet.protocol.pea.Handler;
import pnuts.compiler.Compiler;
import pnuts.lang.Context;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;
import pnuts.lang.Runtime;
import pnuts.servlet.DynamicPage;

public class readDynamicPage
extends PnutsFunction {
    private static final String SERVLET_COMPILER = "pnuts.servlet.compiler".intern();

    public readDynamicPage() {
        super("readDynamicPage");
    }

    public boolean defined(int nargs) {
        return nargs == 1 || nargs == 2 || nargs == 3;
    }

    static URL getDynamicPageURL(URL url, String encoding, Context context) {
        try {
            String specURL = encoding == null ? "pea:" + url.toExternalForm() : "pea:" + url.toExternalForm() + "!charset=" + encoding;
            return new URL(null, specURL, new Handler(context, null));
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
            return null;
        }
    }

    static Reader getReader(InputStream in, String enc, Context context) throws UnsupportedEncodingException {
        if (enc != null) {
            return new InputStreamReader(in, enc);
        }
        return Runtime.getScriptReader((InputStream)in, (Context)context);
    }

    protected Object exec(Object[] args, Context context) {
        String encoding;
        int nargs = args.length;
        if (nargs == 0 || nargs > 3) {
            this.undefined(args, context);
        }
        Object arg = args[0];
        if (nargs >= 2) {
            encoding = (String)args[1];
            if (encoding == null) {
                encoding = context.getScriptEncoding();
            }
        } else {
            encoding = context.getScriptEncoding();
        }
        boolean reloadUpdatedScripts = true;
        if (nargs >= 3) {
            reloadUpdatedScripts = (Boolean)args[2];
        }
        Pnuts parsed = null;
        URL url = null;
        Reader reader2 = null;
        final Compiler compiler = (Compiler)context.get(SERVLET_COMPILER);
        URL baseloc = null;
        try {
            if (arg instanceof InputStream) {
                reader2 = readDynamicPage.getReader((InputStream)arg, encoding, context);
            } else if (arg instanceof Reader) {
                reader2 = (Reader)arg;
            } else if (arg instanceof URL) {
                baseloc = url = (URL)arg;
            } else if (arg instanceof File) {
                File file = (File)arg;
                url = file.toURL();
                baseloc = file.getAbsoluteFile().getParentFile().toURL();
            } else if (arg instanceof String) {
                baseloc = url = Pnuts.getResource((String)((String)arg), (Context)context);
            } else {
                throw new IllegalArgumentException(String.valueOf(arg));
            }
            if (url != null) {
                return new DynamicPage(url, encoding, context, reloadUpdatedScripts){

                    protected Compiler getCompiler() {
                        return compiler;
                    }
                };
            }
            StringWriter sw = new StringWriter();
            DynamicPage.convert(reader2, sw, baseloc, encoding, context, null);
            parsed = Pnuts.parse((Reader)new StringReader(sw.toString()), null, (Context)context);
            if (compiler != null) {
                parsed = compiler.compile(parsed, context);
            }
            return parsed;
        }
        catch (Throwable t) {
            throw new PnutsException(t, context);
        }
    }

    public String toString() {
        return "function readDynamicPage((String|InputStream|Reader|File|URL) input {, encoding {, reload_updated_scripts}})";
    }
}

