/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.servlet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;

class SessionMap
implements Map {
    private HttpSession session;

    public SessionMap(HttpSession session) {
        this.session = session;
    }

    public int size() {
        if (this.session == null) {
            return 0;
        }
        int count2 = 0;
        Enumeration e = this.session.getAttributeNames();
        while (e.hasMoreElements()) {
            ++count2;
        }
        return count2;
    }

    public boolean isEmpty() {
        if (this.session == null) {
            return true;
        }
        Enumeration e = this.session.getAttributeNames();
        return !e.hasMoreElements();
    }

    public boolean containsKey(Object key) {
        if (this.session == null) {
            return false;
        }
        return this.session.getAttribute((String)key) != null;
    }

    public boolean containsValue(Object value) {
        if (this.session == null) {
            return false;
        }
        Enumeration e = this.session.getAttributeNames();
        while (e.hasMoreElements()) {
            if (!value.equals(this.get(e.nextElement()))) continue;
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        if (this.session == null) {
            return null;
        }
        return this.session.getAttribute((String)key);
    }

    public Object put(Object key, Object value) {
        if (this.session == null) {
            return null;
        }
        this.session.setAttribute((String)key, value);
        return null;
    }

    public Object remove(Object key) {
        if (this.session == null) {
            return null;
        }
        Object result = this.get(key);
        this.session.removeAttribute((String)key);
        return result;
    }

    public void putAll(Map t) {
        if (this.session == null) {
            return;
        }
        Iterator it = t.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        if (this.session == null) {
            return;
        }
        Enumeration e = this.session.getAttributeNames();
        while (e.hasMoreElements()) {
            this.remove((String)e.nextElement());
        }
    }

    public Set keySet() {
        HashSet set2 = new HashSet();
        if (this.session != null) {
            Enumeration e = this.session.getAttributeNames();
            while (e.hasMoreElements()) {
                set2.add(e.nextElement());
            }
        }
        return set2;
    }

    public Collection values() {
        ArrayList<Object> list2 = new ArrayList<Object>();
        if (this.session != null) {
            Enumeration e = this.session.getAttributeNames();
            while (e.hasMoreElements()) {
                list2.add(this.get(e.nextElement()));
            }
        }
        return list2;
    }

    public Set entrySet() {
        HashSet<Entry> set2 = new HashSet<Entry>();
        if (this.session != null) {
            Enumeration e = this.session.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                set2.add(new Entry(name, this.get(name)));
            }
        }
        return set2;
    }

    static class Entry
    implements Map.Entry {
        String attr;
        Object value;

        Entry(String attr, Object value) {
            this.attr = attr;
            this.value = value;
        }

        public Object getKey() {
            return this.attr;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object r = this.value;
            this.value = value;
            return r;
        }

        public int hashCode() {
            return this.attr.hashCode();
        }

        public boolean equals(Object that) {
            if (that instanceof Entry) {
                Entry e = (Entry)that;
                return this.attr.equals(e.attr) && this.value.equals(e.value);
            }
            return false;
        }
    }
}

