/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.nio;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Collection;
import org.pnuts.io.URLHelper;
import org.pnuts.lib.PathHelper;
import org.pnuts.nio.ByteBufferLineInputStream;
import org.pnuts.nio.CallbackLineHandler;
import org.pnuts.nio.CharBufferLineReader;
import org.pnuts.nio.CollectionLineHandler;
import org.pnuts.nio.LineHandler;
import org.pnuts.nio.LineInputStream;
import org.pnuts.text.LineProcessor;
import org.pnuts.text.LineReader;
import pnuts.io.CharacterEncoding;
import pnuts.lang.Context;
import pnuts.lang.Generator;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;

public class scanLines
extends PnutsFunction {
    public scanLines() {
        super("scanLines");
    }

    public boolean defined(int narg) {
        return narg == 1 || narg == 2 || narg == 3;
    }

    static boolean requiresDoubleByte(Context context) {
        String enc = CharacterEncoding.getCharacterEncoding(context)[0];
        return enc == null || !"ascii".equals(enc.toLowerCase());
    }

    static LineProcessor getLineProcessor(Object arg, LineHandler handler, Context context) throws IOException {
        CharBufferLineReader lineReader;
        if (arg instanceof InputStream) {
            if (scanLines.requiresDoubleByte(context)) {
                return new LineReader(CharacterEncoding.getReader((InputStream)arg, context), handler, false);
            }
            return new LineInputStream((InputStream)arg, handler, false);
        }
        if (arg instanceof Reader) {
            return new LineReader((Reader)arg, handler, false);
        }
        if (arg instanceof File) {
            if (scanLines.requiresDoubleByte(context)) {
                return new LineReader(CharacterEncoding.getReader(new FileInputStream((File)arg), context), handler, true);
            }
            return new LineInputStream(new FileInputStream((File)arg), handler, true);
        }
        if (arg instanceof String) {
            if (scanLines.requiresDoubleByte(context)) {
                return new LineReader(CharacterEncoding.getReader(new FileInputStream(PathHelper.getFile((String)arg, context)), context), handler, true);
            }
            return new LineInputStream(new FileInputStream(PathHelper.getFile((String)arg, context)), handler, true);
        }
        if (arg instanceof URL) {
            return new LineReader(URLHelper.getReader((URL)arg, context), handler, true);
        }
        if (arg instanceof ByteBuffer) {
            return new ByteBufferLineInputStream((ByteBuffer)arg, handler, false);
        }
        if (arg instanceof CharBuffer) {
            lineReader = new CharBufferLineReader((CharBuffer)arg);
        } else if (arg instanceof CharSequence) {
            lineReader = new CharBufferLineReader(CharBuffer.wrap((CharSequence)arg));
        } else {
            throw new IllegalArgumentException();
        }
        return lineReader;
    }

    static LineHandler getLineHandler(Object arg, Context context) {
        if (arg instanceof PnutsFunction) {
            return new CallbackLineHandler((PnutsFunction)arg, context);
        }
        if (arg instanceof Collection) {
            return new CollectionLineHandler((Collection)arg);
        }
        if (arg == null) {
            return new LineHandler(){

                public void process(char[] c, int offset, int length) {
                }

                public void process(byte[] b, int offset, int length) {
                }
            };
        }
        throw new IllegalArgumentException();
    }

    protected Object exec(Object[] args, Context context) {
        boolean includeNewLine = false;
        final Object arg0 = args[0];
        LineProcessor lineReader = null;
        switch (args.length) {
            case 3: {
                includeNewLine = (Boolean)args[2];
            }
            case 2: {
                try {
                    LineHandler handler = scanLines.getLineHandler(args[1], context);
                    lineReader = scanLines.getLineProcessor(arg0, handler, context);
                    return new Integer(lineReader.processAll(includeNewLine));
                }
                catch (IOException e) {
                    throw new PnutsException((Throwable)e, context);
                }
            }
            case 1: {
                final boolean newline = includeNewLine;
                return new Generator(){

                    public Object apply(final PnutsFunction closure, final Context context) {
                        LineProcessor lineReader = null;
                        try {
                            lineReader = scanLines.getLineProcessor(arg0, scanLines.getLineHandler(new PnutsFunction(){

                                protected Object exec(Object[] args, Context c) {
                                    closure.call(args, context);
                                    return null;
                                }
                            }, context), context);
                            lineReader.processAll(newline);
                        }
                        catch (IOException e) {
                            throw new PnutsException((Throwable)e, context);
                        }
                        return null;
                    }
                };
            }
        }
        this.undefined(args, context);
        return null;
    }

    public String toString() {
        return "function scanLines((inputStream|reader|file|fileName|url) {, (func(line) | collection) {, includeNewLine }})";
    }
}

