/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.nio;

import java.io.IOException;
import java.io.InputStream;
import org.pnuts.nio.AbstractLineInputStream;
import org.pnuts.nio.LineHandler;

public class LineInputStream
extends AbstractLineInputStream {
    protected LineHandler handler;
    protected InputStream input;
    protected boolean needToClose;

    public LineInputStream(InputStream input, LineHandler handler, boolean needToClose) {
        this(input, AbstractLineInputStream.defaultBufferSize, handler, needToClose);
    }

    public LineInputStream(InputStream input, int sz, LineHandler handler, boolean needToClose) {
        super(sz);
        this.input = input;
        this.handler = handler;
        this.needToClose = needToClose;
    }

    protected int fill(byte[] b, int offset, int size2) throws IOException {
        return this.input.read(b, offset, size2);
    }

    protected void process(byte[] b, int offset, int length) {
        this.handler.process(b, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processAll(boolean includeNewLine) throws IOException {
        int count2 = 0;
        try {
            while (!this.stopped && this.processLine(includeNewLine)) {
                ++count2;
            }
            int n = count2;
            return n;
        }
        finally {
            if (this.needToClose) {
                this.input.close();
            }
        }
    }
}

