/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.pnuts.nio.AbstractLineInputStream;
import org.pnuts.nio.LineHandler;

public class ByteBufferLineInputStream
extends AbstractLineInputStream {
    protected ByteBuffer bbuf;
    protected LineHandler handler;
    protected boolean needToClose;
    static final int defaultBufferSize = 8192;

    public ByteBufferLineInputStream(ByteBuffer bbuf, LineHandler handler, boolean needToClose) {
        this(bbuf, 8192, handler, needToClose);
    }

    public ByteBufferLineInputStream(ByteBuffer bbuf, int sz, LineHandler handler, boolean needToClose) {
        super(sz);
        this.bbuf = bbuf;
        this.handler = handler;
        this.needToClose = needToClose;
    }

    protected ByteBufferLineInputStream() {
    }

    protected int fill(byte[] b, int offset, int size2) throws IOException {
        int rem = this.bbuf.remaining();
        if (rem <= 0) {
            return -1;
        }
        if (size2 > rem) {
            size2 = rem;
        }
        this.bbuf.get(b, offset, size2);
        return size2;
    }

    protected void process(byte[] b, int offset, int length) {
        this.handler.process(b, offset, length);
    }
}

