/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.nio;

import java.io.IOException;
import org.pnuts.text.LineProcessor;

public abstract class AbstractLineInputStream
implements LineProcessor {
    protected static int defaultBufferSize = 8192;
    protected byte[] bb;
    protected int size;
    protected int startChar;
    protected boolean stopped = false;

    protected AbstractLineInputStream(int sz) {
        if (sz <= 0) {
            throw new IllegalArgumentException();
        }
        this.bb = new byte[sz];
    }

    protected AbstractLineInputStream() {
        this(defaultBufferSize);
    }

    protected abstract int fill(byte[] var1, int var2, int var3) throws IOException;

    protected void process(byte[] c, int offset, int length) {
    }

    boolean fillBuffer() throws IOException {
        int n = 0;
        int offset = this.size - this.startChar;
        if (offset < 0) {
            return false;
        }
        do {
            if (this.startChar > 0 && this.startChar < this.bb.length) {
                System.arraycopy(this.bb, this.startChar, this.bb, 0, offset);
                continue;
            }
            if (offset != this.bb.length) continue;
            byte[] newarray = new byte[this.bb.length * 2];
            System.arraycopy(this.bb, this.startChar, newarray, 0, offset);
            this.bb = newarray;
        } while ((n = this.fill(this.bb, offset, this.bb.length - offset)) == 0);
        if (n > 0) {
            this.size = n + offset;
        }
        return n > 0;
    }

    public synchronized boolean processLine(boolean includeNewLine) throws IOException {
        int e;
        int n = 0;
        int startChar = this.startChar;
        if (this.size < 1) {
            this.fillBuffer();
        }
        while (true) {
            boolean eol = false;
            boolean cr = false;
            byte b = 0;
            int size2 = this.size;
            int i = e = startChar + n;
            while (i < size2) {
                b = this.bb[i++];
                ++n;
                if (b == 10) {
                    eol = true;
                    if (!includeNewLine) break;
                    ++e;
                    break;
                }
                if (b == 13) {
                    eol = true;
                    if (cr) {
                        --n;
                        break;
                    }
                    if (includeNewLine) {
                        ++e;
                    }
                    cr = true;
                    if (i != size2) continue;
                    if (this.fillBuffer()) {
                        e -= startChar;
                        startChar = 0;
                        this.startChar = 0;
                        size2 = this.size;
                        i = n;
                        continue;
                    }
                    if (i > startChar) {
                        this.process(this.bb, startChar, e - startChar);
                    }
                    return false;
                }
                if (cr) {
                    --n;
                    break;
                }
                ++e;
                cr = false;
            }
            if (eol) {
                if (e >= startChar) {
                    this.process(this.bb, startChar, e - startChar);
                }
                this.startChar += n;
                return true;
            }
            if (!this.fillBuffer()) break;
            e -= startChar;
            startChar = 0;
            this.startChar = 0;
            size2 = this.size;
            i = n;
        }
        if (e > startChar) {
            this.process(this.bb, startChar, e - startChar);
        }
        return false;
    }

    public void stop() {
        this.stopped = true;
    }

    public int processAll() throws IOException {
        return this.processAll(false);
    }

    public int processAll(boolean includeNewLine) throws IOException {
        int count2 = 0;
        while (!this.stopped && this.processLine(includeNewLine)) {
            ++count2;
        }
        return count2;
    }
}

