/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.multithread;

public class Queue {
    private Cell head;
    private Cell tail;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Object value) {
        Cell c = new Cell(value);
        Queue queue = this;
        synchronized (queue) {
            if (this.head == null) {
                this.head = c;
                this.tail = c;
                this.notify();
            } else {
                this.tail.next = c;
                this.tail = c;
            }
        }
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    public synchronized Object dequeue() throws InterruptedException {
        return this.dequeue(-1L);
    }

    public synchronized Object dequeue(long timeout) throws InterruptedException {
        Object ret = null;
        if (timeout > 0L) {
            if (this.head == null) {
                this.wait(timeout);
            }
        } else if (timeout < 0L) {
            while (this.head == null) {
                this.wait();
            }
        }
        if (this.head != null) {
            ret = this.head.value;
            this.head = this.head.next;
        }
        return ret;
    }

    static class Cell {
        Object value;
        Cell next;

        Cell(Object value) {
            this.value = value;
        }
    }
}

