/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.math;

import java.math.BigDecimal;
import pnuts.lang.Context;
import pnuts.lang.PnutsFunction;
import pnuts.lang.Runtime;

public class pow
extends PnutsFunction {
    static final Integer zero = new Integer(0);
    static final Integer one = new Integer(1);
    static final Integer two = new Integer(2);

    public pow() {
        super("pow");
    }

    public boolean defined(int nargs) {
        return nargs == 2;
    }

    protected Object exec(Object[] args, Context context) {
        if (args.length != 2) {
            this.undefined(args, context);
            return null;
        }
        Object arg1 = args[0];
        Object arg2 = args[1];
        if (arg2 instanceof Double || arg2 instanceof Float || arg2 instanceof BigDecimal || arg2 instanceof Number && ((Number)arg2).intValue() < 0) {
            return new Double(Math.pow(((Number)arg1).doubleValue(), ((Number)arg2).doubleValue()));
        }
        return pow.ipow(arg1, arg2);
    }

    static Object ipow(Object n, Object m) {
        if (Runtime.eq((Object)m, (Object)zero)) {
            return one;
        }
        Object m2 = Runtime.divide((Object)m, (Object)two);
        Object mod = Runtime.mod((Object)m, (Object)two);
        Object t = pow.ipow(n, m2);
        Object r = Runtime.multiply((Object)t, (Object)t);
        if (Runtime.gt((Object)mod, (Object)zero)) {
            return Runtime.multiply((Object)r, (Object)n);
        }
        return r;
    }

    public String toString() {
        return "function pow(x, y)";
    }
}

