/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.lib;

import java.io.File;
import pnuts.lang.Context;

public class PathHelper {
    static final String CWD = "cwd".intern();

    static boolean isRelative(File file) {
        return !file.isAbsolute() && file.getPath().charAt(0) != File.separatorChar;
    }

    public static File getFile(String name, Context context) {
        File file = new File(name);
        if (PathHelper.isRelative(file)) {
            String cwd = (String)context.get(CWD);
            if (cwd == null) {
                cwd = System.getProperty("user.dir");
                context.set(CWD, (Object)cwd);
            }
            return new File(cwd, name);
        }
        return file;
    }

    public static void setCurrentDirectory(File dir, Context context) {
        context.set(CWD, (Object)dir.getPath());
    }

    public static boolean ensureBaseDirectory(File file) {
        File dir = new File(file.getParent());
        if (!dir.exists()) {
            return dir.mkdirs();
        }
        return true;
    }
}

