/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.lib;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.pnuts.lib.locale;
import pnuts.lang.Context;

class NumberFormatHelper {
    private static final String FORMAT_LOCALE = "pnuts$lib$locale".intern();

    NumberFormatHelper() {
    }

    public static String formatDecimal(Number num, String fmt) {
        DecimalFormat formatter = new DecimalFormat(fmt);
        if (num instanceof Double) {
            return formatter.format((Double)num);
        }
        if (num instanceof Float) {
            return formatter.format(((Float)num).doubleValue());
        }
        if (num instanceof Long) {
            return formatter.format((Long)num);
        }
        if (num instanceof Integer) {
            return formatter.format(((Integer)num).longValue());
        }
        if (num instanceof Short) {
            return formatter.format(((Short)num).longValue());
        }
        if (num instanceof Byte) {
            return formatter.format(((Byte)num).longValue());
        }
        if (num instanceof Number) {
            return formatter.format(num.doubleValue());
        }
        throw new IllegalArgumentException();
    }

    public static String formatNumber(Number num, int min2, int max2, int fmin, int fmax, Context context) {
        NumberFormat fmt = NumberFormat.getNumberInstance(NumberFormatHelper.getFormatLocale(context));
        return NumberFormatHelper.doFormat(fmt, num, min2, max2, fmin, fmax);
    }

    public static String formatCurrency(Number num, int min2, int max2, int fmin, int fmax, Context context) {
        NumberFormat fmt = NumberFormat.getCurrencyInstance(NumberFormatHelper.getFormatLocale(context));
        return NumberFormatHelper.doFormat(fmt, num, min2, max2, fmin, fmax);
    }

    public static String formatPercent(Number num, int min2, int max2, int fmin, int fmax, Context context) {
        NumberFormat fmt = NumberFormat.getPercentInstance(NumberFormatHelper.getFormatLocale(context));
        return NumberFormatHelper.doFormat(fmt, num, min2, max2, fmin, fmax);
    }

    static String doFormat(NumberFormat fmt, Number num, int min2, int max2, int fmin, int fmax) {
        NumberFormatHelper.setScale(fmt, min2, max2, fmin, fmax);
        return fmt.format(num);
    }

    static void setScale(NumberFormat fmt, int imin, int imax, int fmin, int fmax) {
        if (imin >= 0) {
            fmt.setMinimumIntegerDigits(imin);
        }
        if (imax >= 0) {
            fmt.setMaximumIntegerDigits(imax);
        }
        if (fmin >= 0) {
            fmt.setMinimumFractionDigits(fmin);
        }
        if (fmax >= 0) {
            fmt.setMaximumFractionDigits(fmax);
        }
    }

    static Locale getFormatLocale(Context context) {
        Locale lc = (Locale)context.get(FORMAT_LOCALE);
        if (lc == null) {
            lc = locale.getLocale(context);
        }
        return lc;
    }
}

