/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.lib;

import org.pnuts.util.LRUCacheMap;
import pnuts.lang.Context;
import pnuts.lang.PnutsFunction;

public class LRUcache
extends PnutsFunction {
    public LRUcache() {
        super("LRUcache");
    }

    public boolean defined(int nargs) {
        return nargs == 1 || nargs == 2 || nargs == 3;
    }

    public Object exec(Object[] args, Context context) {
        int nargs = args.length;
        if (nargs == 1) {
            int max2 = (Integer)args[0];
            return new FixedSizedCache(max2, null, null, context);
        }
        if (nargs == 2) {
            int max3 = (Integer)args[0];
            return new FixedSizedCache(max3, (PnutsFunction)args[1], null, context);
        }
        if (nargs == 3) {
            int max4 = (Integer)args[0];
            return new FixedSizedCache(max4, (PnutsFunction)args[1], (PnutsFunction)args[2], context);
        }
        this.undefined(args, context);
        return null;
    }

    public String toString() {
        return "function LRUcache(size { , function(key) {, function (old)}})";
    }

    static class FixedSizedCache
    extends LRUCacheMap {
        PnutsFunction cf;
        PnutsFunction df;
        Context context;

        FixedSizedCache(int max2, PnutsFunction cf, PnutsFunction df, Context c) {
            super(max2);
            this.cf = cf;
            this.df = df;
            this.context = c;
        }

        protected Object construct(Object key) {
            return this.cf.call(new Object[]{key}, this.context);
        }

        public void expired(Object old) {
            if (this.df != null) {
                this.df.call(new Object[]{old}, this.context);
            }
        }
    }
}

