/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.lib;

import java.text.DateFormat;
import java.util.Date;
import org.pnuts.lib.DateFormatCache;
import org.pnuts.lib.date;
import org.pnuts.lib.locale;
import pnuts.lang.Context;

class DateTimeFormat {
    static final String DATEFORMAT_CACHE = "pnuts$lib$dateformat_cache".intern();
    static final String DATETIME_FORMAT = "pnuts$lib$datetime_format".intern();
    static final String DATE_FORMAT = "pnuts$lib$date_format".intern();
    static final String TIME_FORMAT = "pnuts$lib$time_format".intern();
    static final String DEFAULT = "DEFAULT";
    static final String defaultDatePattern = "MM/dd/yyyy";

    DateTimeFormat() {
    }

    static void reset(Context context) {
        context.set(DATEFORMAT_CACHE, null);
        context.set(DATETIME_FORMAT, null);
        context.set(DATE_FORMAT, null);
        context.set(TIME_FORMAT, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DateFormat getDateFormat(String pattern, Context context) {
        DateFormatCache cache;
        Context context2 = context;
        synchronized (context2) {
            cache = (DateFormatCache)context.get(DATEFORMAT_CACHE);
            if (cache == null) {
                cache = new DateFormatCache(context);
                context.set(DATEFORMAT_CACHE, (Object)cache);
            }
        }
        return cache.get(pattern);
    }

    static Date parse(String expr, Context context) {
        return DateTimeFormat.parse(expr, defaultDatePattern, context);
    }

    static Date parse(String expr, String pattern, Context context) {
        try {
            return DateTimeFormat.getDateFormat(pattern, context).parse(expr);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DateFormat getDateTimeFormat(String type, Context context) {
        Context context2 = context;
        synchronized (context2) {
            DateFormat df = (DateFormat)context.get(type);
            if (df == null) {
                df = DateFormat.getDateTimeInstance();
                df.setTimeZone(date.getTimeZone(context));
                context.set(type, (Object)df);
            }
            return df;
        }
    }

    static String formatDateTime(Date date2, Context context) {
        return DateTimeFormat.getDateTimeFormat(DATETIME_FORMAT, context).format(date2);
    }

    static String formatDateTime(Date date2, String pattern, Context context) {
        return DateTimeFormat.getDateFormat(pattern, context).format(date2);
    }

    static String formatDateTime(Date d, String style1, String style2, Context context) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(DateTimeFormat.dateStyle(style1), DateTimeFormat.dateStyle(style2), locale.getLocale(context));
        dateFormat.setTimeZone(date.getTimeZone(context));
        return dateFormat.format(d);
    }

    static String formatDate(Date date2, Context context) {
        return DateTimeFormat.getDateTimeFormat(DATE_FORMAT, context).format(date2);
    }

    static String formatDate(Date d, String style, Context context) {
        DateFormat dateFormat = DateFormat.getDateInstance(DateTimeFormat.dateStyle(style), locale.getLocale(context));
        dateFormat.setTimeZone(date.getTimeZone(context));
        return dateFormat.format(d);
    }

    static String formatTime(Date date2, Context context) {
        return DateTimeFormat.getDateTimeFormat(TIME_FORMAT, context).format(date2);
    }

    static String formatTime(Date d, String style, Context context) {
        DateFormat dateFormat = DateFormat.getTimeInstance(DateTimeFormat.dateStyle(style), locale.getLocale(context));
        dateFormat.setTimeZone(date.getTimeZone(context));
        return dateFormat.format(d);
    }

    private static int dateStyle(String s) {
        if ("full".equals(s = s.toLowerCase())) {
            return 0;
        }
        if ("long".equals(s)) {
            return 1;
        }
        if ("medium".equals(s)) {
            return 2;
        }
        if ("short".equals(s)) {
            return 3;
        }
        return 2;
    }
}

