/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.lib;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import pnuts.lang.Context;
import pnuts.lang.Generator;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;
import pnuts.lang.Runtime;

class Counter {
    Counter() {
    }

    public Number count(Object a, Context context) {
        if (a instanceof Enumeration) {
            Enumeration e = (Enumeration)a;
            int c = 0;
            while (e.hasMoreElements()) {
                ++c;
                e.nextElement();
            }
            return new Integer(c);
        }
        if (a instanceof Iterator) {
            Iterator it = (Iterator)a;
            int c = 0;
            while (it.hasNext()) {
                ++c;
                it.next();
            }
            return new Integer(c);
        }
        if (a instanceof Generator) {
            Generator g = (Generator)a;
            class F
            extends PnutsFunction {
                int count = 0;

                F() {
                }

                protected Object exec(Object[] args, Context context) {
                    ++this.count;
                    return null;
                }
            }
            F f = new F();
            g.apply((PnutsFunction)f, context);
            return new Integer(f.count);
        }
        if (a instanceof InputStream) {
            byte[] buf = new byte[4096];
            int n = 0;
            int c = 0;
            InputStream in = (InputStream)a;
            try {
                while ((n = in.read(buf)) != -1) {
                    c += n;
                }
            }
            catch (IOException e) {
                throw new PnutsException((Throwable)e, context);
            }
            return new Integer(c);
        }
        if (a instanceof Reader) {
            char[] buf = new char[4096];
            int n = 0;
            int c = 0;
            Reader in = (Reader)a;
            try {
                while ((n = in.read(buf)) != -1) {
                    c += n;
                }
            }
            catch (IOException e) {
                throw new PnutsException((Throwable)e, context);
            }
            return new Integer(c);
        }
        return this.size(a, context);
    }

    public Number size(Object a, Context context) {
        if (a == null) {
            return new Integer(0);
        }
        if (a instanceof String) {
            return new Integer(((String)a).length());
        }
        if (a instanceof StringBuffer) {
            return new Integer(((StringBuffer)a).length());
        }
        if (a instanceof Object[]) {
            return new Integer(((Object[])a).length);
        }
        if (a instanceof File) {
            return new Long(((File)a).length());
        }
        if (a instanceof Collection) {
            return new Integer(((Collection)a).size());
        }
        if (a instanceof Map) {
            return new Integer(((Map)a).size());
        }
        if (Runtime.isArray((Object)a)) {
            return new Integer(Runtime.getArrayLength((Object)a));
        }
        throw new IllegalArgumentException(String.valueOf(a));
    }
}

