/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.jdbc;

import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import pnuts.lang.Indexed;

public class ColumnMap
extends AbstractMap
implements Indexed {
    protected ResultSet rs;
    private String[] columnNames;
    private HashSet columnNameSet;
    private boolean clobToStringConversion = true;
    private boolean updated;

    protected ColumnMap() {
    }

    public ColumnMap(ResultSet rs) throws SQLException {
        this.rs = rs;
        this.initialize(rs.getMetaData());
    }

    void initialize(ResultSetMetaData meta) throws SQLException {
        int columnCount = meta.getColumnCount();
        this.columnNameSet = new HashSet();
        this.columnNames = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            String name = meta.getColumnName(i + 1);
            this.columnNames[i] = name = name.toLowerCase();
            this.columnNameSet.add(name);
        }
    }

    public void setClobToStringConvertion(boolean flag) {
        this.clobToStringConversion = flag;
    }

    public boolean getClobToStringConvertion() {
        return this.clobToStringConversion;
    }

    public boolean next() throws SQLException {
        if (this.updated) {
            this.rs.updateRow();
            this.updated = false;
        }
        return this.rs.next();
    }

    public void set(int idx, Object value) {
        try {
            this.rs.updateObject(idx + 1, value);
        }
        catch (SQLException e) {
            this.handleSQLException(e);
        }
        this.updated = true;
    }

    public Object get(int idx) {
        try {
            return this.unwrap(this.rs.getObject(idx + 1));
        }
        catch (SQLException e) {
            this.handleSQLException(e);
            return null;
        }
    }

    public int size() {
        return this.columnNames.length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object key) {
        return this.columnNameSet.contains(key);
    }

    public boolean containsValue(Object value) {
        return false;
    }

    public Object get(Object key) {
        try {
            return this.unwrap(this.rs.getObject(((String)key).toLowerCase()));
        }
        catch (SQLException e) {
            this.handleSQLException(e);
            return null;
        }
    }

    public Object put(Object key, Object value) {
        try {
            this.rs.updateObject(((String)key).toLowerCase(), value);
        }
        catch (SQLException e) {
            this.handleSQLException(e);
        }
        this.updated = true;
        return null;
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        return this.columnNameSet;
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        return new EntrySet();
    }

    protected void handleSQLException(SQLException e) {
        throw new RuntimeException(String.valueOf(e));
    }

    private Object unwrap(Object x) throws SQLException {
        if (this.clobToStringConversion && x instanceof Clob) {
            Clob clob = (Clob)x;
            long len = clob.length();
            if (len < 0L || len > Integer.MAX_VALUE) {
                throw new RuntimeException("Can't convert to String");
            }
            if (len == 0L) {
                return "";
            }
            return clob.getSubString(1L, (int)len);
        }
        return x;
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (!it.next().equals(e)) continue;
                return true;
            }
            return false;
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return ColumnMap.this.columnNames.length;
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    implements Iterator {
        int pos = 0;

        private EntryIterator() {
        }

        public boolean hasNext() {
            return ColumnMap.this.columnNames.length > this.pos;
        }

        public Object next() {
            final int p = this.pos++;
            return new Map.Entry(){

                public Object getKey() {
                    return ColumnMap.this.columnNames[p];
                }

                public Object getValue() {
                    try {
                        return ColumnMap.this.unwrap(((EntryIterator)EntryIterator.this).ColumnMap.this.rs.getObject(p + 1));
                    }
                    catch (SQLException e) {
                        ColumnMap.this.handleSQLException(e);
                        return null;
                    }
                }

                public Object setValue(Object value) {
                    try {
                        ((EntryIterator)EntryIterator.this).ColumnMap.this.rs.updateObject(p + 1, value);
                        ColumnMap.this.updated = true;
                        return null;
                    }
                    catch (SQLException e) {
                        ColumnMap.this.handleSQLException(e);
                        return null;
                    }
                }

                public String toString() {
                    return this.getKey() + "=" + this.getValue();
                }
            };
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

