/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.io;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.FilterReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import pnuts.lang.Context;
import pnuts.lang.PnutsFunction;

public class translate
extends PnutsFunction {
    public translate() {
        super("translate");
    }

    public boolean defined(int narg) {
        return narg == 3;
    }

    static char[] toCharArray(Object obj) {
        if (obj instanceof String) {
            return ((String)obj).toCharArray();
        }
        if (obj instanceof char[]) {
            return (char[])obj;
        }
        throw new IllegalArgumentException(String.valueOf(obj));
    }

    static byte[] toByteArray(Object obj) {
        if (obj instanceof String) {
            return ((String)obj).getBytes();
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        throw new IllegalArgumentException(String.valueOf(obj));
    }

    protected Object exec(Object[] args, Context context) {
        if (args.length != 3) {
            this.undefined(args, context);
            return null;
        }
        Object arg0 = args[0];
        Object arg1 = args[1];
        Object arg2 = args[2];
        if (arg0 instanceof InputStream) {
            byte[] b1 = translate.toByteArray(arg1);
            byte[] b2 = translate.toByteArray(arg2);
            return new TranslateInputStream((InputStream)arg0, b1, b2);
        }
        if (arg0 instanceof OutputStream) {
            byte[] b1 = translate.toByteArray(arg1);
            byte[] b2 = translate.toByteArray(arg2);
            return new TranslateOutputStream((OutputStream)arg0, b1, b2);
        }
        if (arg0 instanceof Reader) {
            char[] c1 = translate.toCharArray(arg1);
            char[] c2 = translate.toCharArray(arg2);
            return new TranslateReader((Reader)arg0, c1, c2);
        }
        if (arg0 instanceof Writer) {
            char[] c1 = translate.toCharArray(arg1);
            char[] c2 = translate.toCharArray(arg2);
            return new TranslateWriter((Writer)arg0, c1, c2);
        }
        if (arg0 instanceof byte[]) {
            int i;
            byte[] from = translate.toByteArray(arg1);
            byte[] to = translate.toByteArray(arg2);
            byte[] b = (byte[])arg0;
            byte[] table = new byte[256];
            for (i = 0; i < 255; ++i) {
                table[i] = (byte)i;
            }
            int len = from.length;
            for (i = 0; i < len; ++i) {
                table[from[i] & 0xFF] = to[i];
            }
            len = b.length;
            for (i = 0; i < len; ++i) {
                b[i] = table[b[i]];
            }
            return b;
        }
        if (arg0 instanceof char[]) {
            int i;
            char[] to;
            int l2;
            char[] c = (char[])arg0;
            char[] from = translate.toCharArray(arg1);
            int l1 = from.length;
            int l = l1 < (l2 = (to = translate.toCharArray(arg2)).length) ? l1 : l2;
            Object[] t = new Translation[l];
            for (int i2 = 0; i2 < l; ++i2) {
                t[i2] = new Translation(from[i2], to[i2]);
            }
            Arrays.sort(t);
            char min2 = ((Translation)t[0]).from;
            char max2 = ((Translation)t[t.length - 1]).from;
            char[] table = new char[max2 - min2 + 1];
            for (i = 0; i < table.length; ++i) {
                table[i] = (char)(min2 + i);
            }
            for (i = 0; i < t.length; ++i) {
                table[((Translation)t[i]).from - min2] = ((Translation)t[i]).to;
            }
            for (i = 0; i < c.length; ++i) {
                char ch = c[i];
                c[i] = ch >= min2 && ch <= max2 ? table[ch - min2] : ch;
            }
            return c;
        }
        if (arg0 instanceof String) {
            int i;
            char[] to;
            int l2;
            StringBuffer sbuf = new StringBuffer();
            String str = (String)arg0;
            char[] from = translate.toCharArray(arg1);
            int l1 = from.length;
            int l = l1 < (l2 = (to = translate.toCharArray(arg2)).length) ? l1 : l2;
            Object[] t = new Translation[l];
            for (int i3 = 0; i3 < l; ++i3) {
                t[i3] = new Translation(from[i3], to[i3]);
            }
            Arrays.sort(t);
            char min3 = ((Translation)t[0]).from;
            char max3 = ((Translation)t[t.length - 1]).from;
            char[] table = new char[max3 - min3 + 1];
            for (i = 0; i < table.length; ++i) {
                table[i] = (char)(min3 + i);
            }
            for (i = 0; i < t.length; ++i) {
                table[((Translation)t[i]).from - min3] = ((Translation)t[i]).to;
            }
            for (i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (ch >= min3 && ch <= max3) {
                    sbuf.append(table[ch - min3]);
                    continue;
                }
                sbuf.append(ch);
            }
            return sbuf.toString();
        }
        throw new IllegalArgumentException(String.valueOf(arg0));
    }

    public String toString() {
        return "function translate((InputStream|OutputStream|Reader|Writer|String|char[]|byte[]), from[], to[])";
    }

    static class Translation
    implements Comparable {
        char from;
        char to;

        Translation(char from, char to) {
            this.from = from;
            this.to = to;
        }

        public int compareTo(Object obj) {
            Translation t = (Translation)obj;
            if (this.from < t.from) {
                return -1;
            }
            if (this.from > t.from) {
                return 1;
            }
            return 0;
        }
    }

    static class TranslateWriter
    extends FilterWriter {
        char[] table;
        int min;
        int max;

        TranslateWriter(Writer out, char[] from, char[] to) {
            super(out);
            if (from.length > 0) {
                int i;
                int min2 = from[0];
                char max2 = from[0];
                char[] tmp = (char[])from.clone();
                Arrays.sort(tmp);
                min2 = tmp[0];
                max2 = tmp[tmp.length - 1];
                this.table = new char[max2 - min2 + 1];
                for (i = min2; i <= max2; ++i) {
                    this.table[i] = (char)i;
                }
                for (i = 0; i < from.length; ++i) {
                    this.table[from[i] - min2] = to[i];
                }
            }
        }

        public void write(int ch) throws IOException {
            if (this.table != null) {
                super.write(this.table[ch - this.min]);
            } else {
                super.write(ch);
            }
        }

        public void write(char[] b, int offset, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                this.write(b[offset + i]);
            }
        }
    }

    static class TranslateReader
    extends FilterReader {
        char[] table;
        int min;
        int max;

        TranslateReader(Reader in, char[] from, char[] to) {
            super(in);
            if (from.length > 0) {
                int i;
                char[] tmp = (char[])from.clone();
                Arrays.sort(tmp);
                int min2 = tmp[0];
                char max2 = tmp[tmp.length - 1];
                this.table = new char[max2 - min2 + 1];
                for (i = min2; i <= max2; ++i) {
                    this.table[i] = (char)i;
                }
                for (i = 0; i < from.length; ++i) {
                    this.table[from[i] - min2] = to[i];
                }
            }
        }

        public int read() throws IOException {
            int ch = super.read();
            if (this.table == null || ch < this.min || ch > this.max) {
                return ch;
            }
            return this.table[ch - this.min];
        }

        public int read(char[] buf, int offset, int len) throws IOException {
            int r = super.read(buf, offset, len);
            if (this.table != null && r != -1) {
                for (int i = 0; i < len; ++i) {
                    char ch = buf[i + offset];
                    if (ch == '\uffffffff' || ch < this.min || ch > this.max) continue;
                    buf[i + offset] = this.table[ch - this.min];
                }
            }
            return r;
        }
    }

    static class TranslateOutputStream
    extends FilterOutputStream {
        byte[] table = new byte[256];

        TranslateOutputStream(OutputStream out, byte[] from, byte[] to) {
            super(out);
            int i;
            for (i = 0; i < 255; ++i) {
                this.table[i] = (byte)i;
            }
            int len = from.length;
            for (i = 0; i < len; ++i) {
                this.table[from[i] & 0xFF] = to[i];
            }
        }

        public void write(int ch) throws IOException {
            super.write(this.table[ch & 0xFF]);
        }

        public void write(byte[] b, int offset, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                this.write(b[offset + i]);
            }
        }
    }

    static class TranslateInputStream
    extends FilterInputStream {
        byte[] table = new byte[256];

        TranslateInputStream(InputStream in, byte[] from, byte[] to) {
            super(in);
            int i;
            for (i = 0; i < 255; ++i) {
                this.table[i] = (byte)i;
            }
            int len = from.length;
            for (i = 0; i < len; ++i) {
                this.table[from[i] & 0xFF] = to[i];
            }
        }

        public int read() throws IOException {
            int ch = super.read();
            if (ch == -1) {
                return -1;
            }
            return this.table[ch & 0xFF];
        }

        public int read(byte[] buf, int offset, int len) throws IOException {
            int r = super.read(buf, offset, len);
            if (r != -1) {
                for (int i = 0; i < len; ++i) {
                    buf[i + offset] = this.table[buf[i + offset] & 0xFF];
                }
            }
            return r;
        }
    }
}

