/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import pnuts.io.CharacterEncoding;
import pnuts.lang.Context;

class TextReader {
    TextReader() {
    }

    protected static Object getText(File file, String encoding, Context context) throws IOException {
        long size2 = file.length();
        if (size2 > Integer.MAX_VALUE) {
            throw new RuntimeException("too large");
        }
        return TextReader.getText(new BufferedReader(CharacterEncoding.getReader(new FileInputStream(file), encoding, context)), (int)size2 / 2, true);
    }

    protected static Object getText(Reader reader2, boolean needToClose) throws IOException {
        return TextReader.getText(reader2, -1, needToClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object getText(Reader reader2, int hint, boolean needToClose) throws IOException {
        int isize = 512;
        if (hint > 0) {
            isize = hint;
        }
        char[] buf = new char[8192];
        StringWriter sw = new StringWriter(isize);
        try {
            int n;
            while ((n = reader2.read(buf, 0, buf.length)) != -1) {
                sw.write(buf, 0, n);
            }
            String string2 = sw.toString();
            return string2;
        }
        finally {
            if (needToClose) {
                reader2.close();
            }
        }
    }
}

