/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Base64Encoder {
    private static final int BUFFER_SIZE = 4096;
    private static final char[] table = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/', '='};

    private final int get1(byte[] buf, int offset) {
        return (buf[offset] & 0xFC) >> 2;
    }

    private final int get2(byte[] buf, int offset) {
        return (buf[offset] & 3) << 4 | (buf[offset + 1] & 0xF0) >>> 4;
    }

    private final int get3(byte[] buf, int offset) {
        return (buf[offset + 1] & 0xF) << 2 | (buf[offset + 2] & 0xC0) >>> 6;
    }

    private static final int get4(byte[] buf, int offset) {
        return buf[offset + 2] & 0x3F;
    }

    public void encode(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        int nread = -1;
        int offset = 0;
        int count2 = 0;
        while ((nread = in.read(buffer, offset, 4096 - offset)) > 0) {
            if (nread + offset >= 3) {
                nread += offset;
                offset = 0;
                while (offset + 3 <= nread) {
                    int c1 = this.get1(buffer, offset);
                    int c2 = this.get2(buffer, offset);
                    int c3 = this.get3(buffer, offset);
                    int c4 = Base64Encoder.get4(buffer, offset);
                    switch (count2) {
                        case 73: {
                            out.write(table[c1]);
                            out.write(table[c2]);
                            out.write(table[c3]);
                            out.write(10);
                            out.write(table[c4]);
                            count2 = 1;
                            break;
                        }
                        case 74: {
                            out.write(table[c1]);
                            out.write(table[c2]);
                            out.write(10);
                            out.write(table[c3]);
                            out.write(table[c4]);
                            count2 = 2;
                            break;
                        }
                        case 75: {
                            out.write(table[c1]);
                            out.write(10);
                            out.write(table[c2]);
                            out.write(table[c3]);
                            out.write(table[c4]);
                            count2 = 3;
                            break;
                        }
                        case 76: {
                            out.write(10);
                            out.write(table[c1]);
                            out.write(table[c2]);
                            out.write(table[c3]);
                            out.write(table[c4]);
                            count2 = 4;
                            break;
                        }
                        default: {
                            out.write(table[c1]);
                            out.write(table[c2]);
                            out.write(table[c3]);
                            out.write(table[c4]);
                            count2 += 4;
                        }
                    }
                    offset += 3;
                }
                for (int i = 0; i < 3; ++i) {
                    buffer[i] = i < nread - offset ? buffer[offset + i] : (byte)0;
                }
                offset = nread - offset;
                continue;
            }
            offset += nread;
        }
        switch (offset) {
            case 1: {
                out.write(table[this.get1(buffer, 0)]);
                out.write(table[this.get2(buffer, 0)]);
                out.write(61);
                out.write(61);
                break;
            }
            case 2: {
                out.write(table[this.get1(buffer, 0)]);
                out.write(table[this.get2(buffer, 0)]);
                out.write(table[this.get3(buffer, 0)]);
                out.write(61);
            }
        }
    }

    public byte[] encode(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.encode(in, out);
        return out.toByteArray();
    }

    public String encode(String input) throws IOException {
        int len = input.length();
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)input.charAt(i);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.encode(in, out);
        return out.toString();
    }
}

