/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Base64Decoder {
    private static final int BUFFER_SIZE = 4096;
    private static byte[] table;

    private final int get1(byte[] buf, int offset) {
        return (buf[offset] & 0x3F) << 2 | (buf[offset + 1] & 0x30) >>> 4;
    }

    private final int get2(byte[] buf, int offset) {
        return (buf[offset + 1] & 0xF) << 4 | (buf[offset + 2] & 0x3C) >>> 2;
    }

    private final int get3(byte[] buf, int offset) {
        return (buf[offset + 2] & 3) << 6 | buf[offset + 3] & 0x3F;
    }

    public void decode(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        byte[] chunk = new byte[4];
        int nread = -1;
        int ready = 0;
        block0: while ((nread = in.read(buffer)) > 0) {
            int skiped = 0;
            while (skiped < nread) {
                while (ready < 4) {
                    byte ch;
                    if (skiped >= nread) continue block0;
                    if ((ch = table[buffer[skiped++]]) < 0) continue;
                    chunk[ready++] = ch;
                }
                if (chunk[2] == 65) {
                    out.write(this.get1(chunk, 0));
                    return;
                }
                if (chunk[3] == 65) {
                    out.write(this.get1(chunk, 0));
                    out.write(this.get2(chunk, 0));
                    return;
                }
                out.write(this.get1(chunk, 0));
                out.write(this.get2(chunk, 0));
                out.write(this.get3(chunk, 0));
                ready = 0;
            }
        }
        if (ready != 0) {
            throw new IOException("Invalid length.");
        }
        out.flush();
    }

    public String decode(String input) throws IOException {
        int len = input.length();
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)input.charAt(i);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.decode(in, bout);
        return bout.toString();
    }

    public byte[] decode(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.decode(in, bout);
        return bout.toByteArray();
    }

    static {
        int i;
        table = new byte[255];
        for (i = 0; i < 255; ++i) {
            Base64Decoder.table[i] = -1;
        }
        for (i = 90; i >= 65; --i) {
            Base64Decoder.table[i] = (byte)(i - 65);
        }
        for (i = 122; i >= 97; --i) {
            Base64Decoder.table[i] = (byte)(i - 97 + 26);
        }
        for (i = 57; i >= 48; --i) {
            Base64Decoder.table[i] = (byte)(i - 48 + 52);
        }
        Base64Decoder.table[61] = 65;
        Base64Decoder.table[43] = 62;
        Base64Decoder.table[47] = 63;
    }
}

