/*
 * Decompiled with CFR 0.152.
 */
package pnuts.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import org.pnuts.awt.DialogOutputStream;
import pnuts.lang.Context;
import pnuts.lang.Runtime;
import pnuts.lang.SimpleNode;
import pnuts.tools.ContextView;
import pnuts.tools.VisualDebuggerModel;

public class VisualDebuggerView {
    public static final String imageSuffix = ".image";
    public static final String labelSuffix = ".label";
    public static final String actionSuffix = ".action";
    public static final String tipSuffix = ".tooltip";
    public static final String shortcutSuffix = ".shortcut";
    public static final String openAction = "open";
    public static final String stepAction = "step";
    public static final String stepUpAction = "stepUp";
    public static final String nextAction = "next";
    public static final String contAction = "cont";
    public static final String closeAction = "close";
    public static final String inspectAction = "inspect";
    public static final String clearAction = "clear";
    static final int DEFAULT_WIDTH = 500;
    static final int DEFAULT_HEIGHT = 600;
    static final Color DEFALT_CURRENT_POSITION_COLOR = Color.cyan;
    static final Color DEFALT_BREAK_POINT_COLOR = Color.orange;
    private static String[] actionNames = new String[]{"open", "step", "stepUp", "next", "cont", "close", "clear", "inspect"};
    Action[] defaultActions = new Action[]{new MenuAction(1), new MenuAction(2), new MenuAction(3), new MenuAction(4), new MenuAction(5), new MenuAction(6), new MenuAction(7), new MenuAction(8)};
    private ResourceBundle resources;
    private Color currentPositionColor;
    private Color breakPointColor;
    private Hashtable menuItems;
    private Hashtable commands;
    private boolean guiStarted = false;
    private Hashtable highlights = new Hashtable();
    private Hashtable tags = new Hashtable();
    private Object traceTag;
    private Element lineMap;
    private JFrame jfr;
    private JTextArea jta;
    private JToolBar toolbar;
    private JMenuBar jmb;
    private ContextView contextView;
    private JDialog inspector;
    private PrintWriter errorStream;
    private int windowWidth;
    private int windowHeight;
    protected VisualDebuggerModel model;
    static /* synthetic */ Class class$pnuts$tools$VisualDebuggerView;

    static ResourceBundle getDefaultResourceBundle() {
        try {
            return ResourceBundle.getBundle("pnuts.tools.dbg", Locale.getDefault());
        }
        catch (MissingResourceException mre) {
            throw new RuntimeException("resource not found");
        }
    }

    public VisualDebuggerView() {
        this(VisualDebuggerView.getDefaultResourceBundle());
    }

    public VisualDebuggerView(ResourceBundle resourceBundle) {
        this.commands = new Hashtable();
        for (int i = 0; i < actionNames.length; ++i) {
            this.commands.put(actionNames[i], new MenuAction(i + 1));
        }
        this.resources = resourceBundle;
    }

    public VisualDebuggerModel getModel() {
        return this.model;
    }

    protected JFrame getJFrame() {
        return new JFrame();
    }

    public void startGUI() {
        int h;
        if (this.guiStarted) {
            return;
        }
        this.initializeLineColors();
        this.jfr = this.getJFrame();
        this.jfr.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                VisualDebuggerView.this.model.do_close();
                VisualDebuggerView.this.exitGUI();
            }
        });
        this.jta = this.createTextArea();
        this.menuItems = new Hashtable();
        this.jmb = this.createMenubar();
        if (this.jmb != null) {
            this.jfr.setJMenuBar(this.jmb);
        }
        Container contentPane = this.jfr.getContentPane();
        contentPane.setLayout(new BorderLayout());
        Component tb = this.createToolbar();
        if (tb != null) {
            contentPane.add("North", tb);
        }
        contentPane.add(new JScrollPane(this.jta));
        int w = this.getIntResource("width");
        if (w < 0) {
            w = 500;
        }
        if ((h = this.getIntResource("height")) < 0) {
            h = 600;
        }
        ((Component)this.jfr).setSize(w, h);
        ((Component)this.jfr).setVisible(true);
        this.contextView = new ContextView(this);
        this.inspector = new JDialog(this.jfr);
        ((Component)this.inspector).setLocation(this.jfr.getX() + this.jfr.getWidth() + 1, this.jfr.getY());
        this.inspector.getContentPane().add(this.contextView.getContainer());
        ((Component)this.inspector).setSize((int)this.inspector.getPreferredSize().getWidth() + 20, (int)this.inspector.getPreferredSize().getHeight() + 20);
        this.errorStream = new PrintWriter(new DialogOutputStream(this.jfr), true);
        this.guiStarted = true;
    }

    void initializeLineColors() {
        int i = this.getIntResource("currentPositionColor");
        this.currentPositionColor = i < 0 ? DEFALT_CURRENT_POSITION_COLOR : new Color(i);
        i = this.getIntResource("breakPointColor");
        this.breakPointColor = i < 0 ? DEFALT_BREAK_POINT_COLOR : new Color(i);
    }

    public void exitGUI() {
        this.jfr.dispose();
        this.jfr = null;
        this.jta = null;
        this.guiStarted = false;
    }

    protected String getTitleString(Object source) {
        return source == null ? "?" : source.toString();
    }

    void update(Object source, int beginLine) {
        this.update(source, beginLine, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void update(Object source, int beginLine, SimpleNode node, Context c) {
        this.startGUI();
        c.setErrorWriter(this.errorStream);
        if (source == null) {
            if (node != null) {
                this.jta.setText(Runtime.unparse(node, null));
            } else {
                this.jta.setText("");
            }
        }
        this.contextView.setContext(c);
        try {
            block34: {
                highlighter = null;
                if (source != null) {
                    highlighter = (Highlighter)this.highlights.get(source);
                    if (highlighter == null) {
                        highlighter = new DefaultHighlighter();
                        this.highlights.put(source, highlighter);
                    }
                } else {
                    highlighter = new DefaultHighlighter();
                    this.jfr.setTitle(this.getTitleString(source));
                }
                sourceChanged = false;
                if (source != null && !source.equals(this.model.getCurrentSource())) {
                    sourceChanged = true;
                    this.jfr.setTitle(this.getTitleString(source));
                    sw = new StringWriter();
                    if (source instanceof URL) {
                        url = (URL)source;
                        in = url.openStream();
                        reader = new BufferedReader(new InputStreamReader(in));
                        try {
                            buf = new char[512];
                            n = 0;
                            while ((n = reader.read(buf)) != -1) {
                                sw.write(buf, 0, n);
                            }
                            this.jta.setText(sw.toString());
                        }
                        finally {
                            reader.close();
                        }
                    } else {
                        if (source instanceof Runtime) {
                            this.jta.setText("");
                            return;
                        }
                        if (source instanceof String) {
                            this.jta.setText((String)source);
                        } else {
                            throw new RuntimeException("invalid source:" + source);
                        }
                    }
                }
                if (source != null) {
                    try {
                        if (sourceChanged) {
                            this.jta.setHighlighter(highlighter);
                        }
                        this.lineMap = this.jta.getDocument().getDefaultRootElement();
                        lines = this.model.getBreakPoints(source);
                        if (lines != null) {
                            e = lines.elements();
                            while (e.hasMoreElements()) {
                                line = (Integer)e.nextElement();
                                pos = this.lineMap.getElement(line - 1);
                                if (pos == null) continue;
                                start = pos.getStartOffset();
                                end = pos.getEndOffset() - 1;
                                key = source + ":" + (line - 1);
                                if (this.tags.get(key) != null) continue;
                                tag = highlighter.addHighlight(start, end, new DefaultHighlighter.DefaultHighlightPainter(this.breakPointColor));
                                this.tags.put(key, tag);
                            }
                        }
                        if (beginLine > 0) {
                            pos = this.lineMap.getElement(beginLine - 1);
                            if (pos == null) ** GOTO lbl102
                            start = pos.getStartOffset();
                            end = pos.getEndOffset() - 1;
                            this.jta.select(start, start);
                            if (this.traceTag != null && !sourceChanged) {
                                highlighter.changeHighlight(this.traceTag, start, end);
                            }
                            this.traceTag = highlighter.addHighlight(start, end, new DefaultHighlighter.DefaultHighlightPainter(this.currentPositionColor));
                        }
                        if (beginLine >= 0) ** GOTO lbl102
                        this.jta.setText("");
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace();
                        return;
                    }
                } else if (beginLine > 0) {
                    this.lineMap = this.jta.getDocument().getDefaultRootElement();
                    if (this.lineMap != null && (pos = this.lineMap.getElement(beginLine - 1)) != null) {
                        start = pos.getStartOffset();
                        end = pos.getEndOffset() - 1;
                        try {
                            this.jta.select(start, start);
                            this.jta.setHighlighter(highlighter);
                            if (this.traceTag != null) {
                                highlighter.changeHighlight(this.traceTag, start, end);
                                break block34;
                            }
                            this.traceTag = highlighter.addHighlight(start, end, new DefaultHighlighter.DefaultHighlightPainter(this.currentPositionColor));
                        }
                        catch (BadLocationException badLocation) {}
                    }
                } else if (beginLine < 0) {
                    this.jta.setText("");
                }
            }
            this.jta.repaint();
            this.jfr.setVisible(true);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    int getElementIndex(int pos) {
        Element lineMap = this.jta.getDocument().getDefaultRootElement();
        return lineMap.getElementIndex(pos);
    }

    Element getElement(int pos) {
        Element lineMap = this.jta.getDocument().getDefaultRootElement();
        return lineMap.getElement(pos);
    }

    void showInspector() {
        ((Component)this.inspector).setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open() {
        VisualDebuggerView visualDebuggerView = this;
        synchronized (visualDebuggerView) {
            this.notifyAll();
        }
        JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
        int ret = chooser.showOpenDialog(this.jfr);
        if (ret == 0) {
            final File file = chooser.getSelectedFile();
            Thread t = new Thread(new Runnable(){

                public void run() {
                    VisualDebuggerView.this.open(file.getPath());
                }
            });
            t.start();
        }
    }

    public void open(String filename) {
        File file = new File(filename);
        try {
            if (file.exists()) {
                this.update(Runtime.fileToURL(file), 0);
            } else {
                this.errorStream.println(filename + " is not found");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Component createToolbar() {
        String toolbarDef = this.getResourceString("toolbar");
        if (toolbarDef == null) {
            return null;
        }
        this.toolbar = new JToolBar();
        String[] toolKeys = this.tokenize(toolbarDef);
        for (int i = 0; i < toolKeys.length; ++i) {
            if (toolKeys[i].equals("-")) {
                this.toolbar.add(Box.createHorizontalStrut(5));
                continue;
            }
            this.toolbar.add(this.createToolbarButton(toolKeys[i]));
        }
        this.toolbar.add(Box.createHorizontalGlue());
        return this.toolbar;
    }

    protected JButton createToolbarButton(String key) {
        Action a;
        URL url = this.getResource(key + imageSuffix);
        JButton b = url != null ? new JButton((Icon)new ImageIcon(url)){

            public float getAlignmentY() {
                return 0.5f;
            }
        } : new JButton(this.getResourceString(key + labelSuffix)){

            public float getAlignmentY() {
                return 0.5f;
            }
        };
        b.setRequestFocusEnabled(false);
        b.setMargin(new Insets(1, 1, 1, 1));
        String astr = this.getResourceString(key + actionSuffix);
        if (astr == null) {
            astr = key;
        }
        if ((a = this.getAction(astr)) != null) {
            b.setActionCommand(astr);
            b.addActionListener(a);
        } else {
            b.setEnabled(false);
        }
        String tip = this.getResourceString(key + tipSuffix);
        if (tip != null) {
            b.setToolTipText(tip);
        }
        return b;
    }

    String[] tokenize(String input) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i = 0; i < cmd.length; ++i) {
            cmd[i] = (String)v.elementAt(i);
        }
        return cmd;
    }

    protected JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        String mbdef = this.getResourceString("menubar");
        if (mbdef == null) {
            return null;
        }
        String[] menuKeys = this.tokenize(mbdef);
        for (int i = 0; i < menuKeys.length; ++i) {
            JMenu m = this.createMenu(menuKeys[i]);
            if (m == null) continue;
            mb.add(m);
        }
        return mb;
    }

    protected JMenu createMenu(String key) {
        String[] itemKeys = this.tokenize(this.getResourceString(key));
        JMenu menu = new JMenu(this.getResourceString(key + labelSuffix));
        for (int i = 0; i < itemKeys.length; ++i) {
            if (itemKeys[i].equals("-")) {
                menu.addSeparator();
                continue;
            }
            JMenuItem mi = this.createMenuItem(itemKeys[i]);
            menu.add(mi);
        }
        return menu;
    }

    protected JMenuItem createMenuItem(String cmd) {
        String astr;
        JMenuItem mi = new JMenuItem(this.getResourceString(cmd + labelSuffix));
        KeyStroke ks = KeyStroke.getKeyStroke(this.getResourceString(cmd + shortcutSuffix));
        if (ks != null) {
            mi.setAccelerator(ks);
        }
        if ((astr = this.getResourceString(cmd + actionSuffix)) == null) {
            astr = cmd;
        }
        mi.setActionCommand(astr);
        Action a = this.getAction(astr);
        if (a != null) {
            mi.addActionListener(a);
            mi.setEnabled(a.isEnabled());
        } else {
            mi.setEnabled(false);
        }
        this.menuItems.put(cmd, mi);
        return mi;
    }

    int getIntResource(String nm) {
        String s = this.getResourceString(nm);
        if (s != null) {
            try {
                return Integer.decode(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    protected String getResourceString(String nm) {
        String str;
        try {
            str = this.resources.getString(nm);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    protected URL getResource(String key) {
        String name = this.getResourceString(key);
        if (name != null) {
            URL url = (class$pnuts$tools$VisualDebuggerView == null ? (class$pnuts$tools$VisualDebuggerView = VisualDebuggerView.class$("pnuts.tools.VisualDebuggerView")) : class$pnuts$tools$VisualDebuggerView).getResource(name);
            return url;
        }
        return null;
    }

    Action getAction(String cmd) {
        return (Action)this.commands.get(cmd);
    }

    protected JTextArea createTextArea() {
        JTextArea jta = new JTextArea();
        jta.setFont(new Font("monospaced", 0, 12));
        jta.addMouseListener(new MouseHandler());
        jta.setEditable(false);
        return jta;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            int x = e.getX();
            int y = e.getY();
            Point pt = new Point(x, y);
            int pos = VisualDebuggerView.this.jta.viewToModel(pt);
            if (pos > 0) {
                int line = VisualDebuggerView.this.getElementIndex(pos);
                Element elem = VisualDebuggerView.this.getElement(line);
                try {
                    Object currentSource = VisualDebuggerView.this.model.getCurrentSource();
                    String key = currentSource + ":" + line;
                    Object tag = VisualDebuggerView.this.tags.get(key);
                    Highlighter highlighter = VisualDebuggerView.this.jta.getHighlighter();
                    if (tag == null) {
                        tag = highlighter.addHighlight(elem.getStartOffset(), elem.getEndOffset() - 1, new DefaultHighlighter.DefaultHighlightPainter(VisualDebuggerView.this.breakPointColor));
                        VisualDebuggerView.this.tags.put(key, tag);
                        VisualDebuggerView.this.model.setBreakPoint(currentSource, line);
                    } else {
                        highlighter.removeHighlight(tag);
                        VisualDebuggerView.this.tags.remove(key);
                        VisualDebuggerView.this.model.removeBreakPoint(currentSource, line);
                    }
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    class MenuAction
    extends AbstractAction {
        private int id;

        MenuAction(int id) {
            this.id = id;
        }

        public void actionPerformed(ActionEvent e) {
            switch (this.id) {
                case 1: {
                    VisualDebuggerView.this.open();
                    break;
                }
                case 2: {
                    VisualDebuggerView.this.model.do_step(1);
                    break;
                }
                case 3: {
                    VisualDebuggerView.this.model.do_stepup();
                    break;
                }
                case 4: {
                    VisualDebuggerView.this.model.do_next(1);
                    break;
                }
                case 5: {
                    VisualDebuggerView.this.model.do_cont();
                    break;
                }
                case 6: {
                    VisualDebuggerView.this.model.do_close();
                    VisualDebuggerView.this.exitGUI();
                    break;
                }
                case 7: {
                    int start = -1;
                    int end = -1;
                    Highlighter.HighlightPainter p = null;
                    Highlighter.Highlight currentLineHighlight = (Highlighter.Highlight)VisualDebuggerView.this.traceTag;
                    if (currentLineHighlight != null) {
                        start = currentLineHighlight.getStartOffset();
                        end = currentLineHighlight.getEndOffset();
                        p = currentLineHighlight.getPainter();
                    }
                    VisualDebuggerView.this.model.clearBreakPoints();
                    VisualDebuggerView.this.highlights = new Hashtable();
                    VisualDebuggerView.this.tags = new Hashtable();
                    VisualDebuggerView.this.traceTag = null;
                    VisualDebuggerView.this.jta.setHighlighter(VisualDebuggerView.this.jta.getHighlighter());
                    VisualDebuggerView.this.highlights.put(VisualDebuggerView.this.model.getCurrentSource(), VisualDebuggerView.this.jta.getHighlighter());
                    if (currentLineHighlight == null) break;
                    try {
                        VisualDebuggerView.this.traceTag = VisualDebuggerView.this.jta.getHighlighter().addHighlight(start, end, p);
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                    break;
                }
                case 8: {
                    ((Component)VisualDebuggerView.this.inspector).setVisible(!VisualDebuggerView.this.inspector.isVisible());
                    VisualDebuggerView.this.inspector.pack();
                }
            }
        }
    }
}

