/*
 * Decompiled with CFR 0.152.
 */
package pnuts.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import pnuts.lang.Context;
import pnuts.lang.Function;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsParserTreeConstants;
import pnuts.lang.Runtime;
import pnuts.lang.SimpleNode;
import pnuts.tools.CommandEvent;
import pnuts.tools.ContextFactory;
import pnuts.tools.DebugContext;
import pnuts.tools.Debugger;

public class TerminalDebugger
implements Debugger,
ContextFactory,
PnutsParserTreeConstants {
    private static final boolean DEBUG = false;
    private Hashtable bpt_functions;
    private Hashtable bpt_files;
    private BufferedReader reader;
    private boolean initialized = false;
    private boolean step = false;
    private boolean step_up = false;
    private boolean next = false;
    private int nsteps;
    private int nnexts;
    private int c_depth;
    private int initialEvalDepth;
    private int initialCallDepth;
    private int e_depth;
    private Object file;
    private int line;
    private boolean trace_lines;
    private boolean trace_all_functions;
    private Hashtable trace_functions;
    private boolean interactive = false;
    private boolean session = false;
    private static String indent = " >>> ";

    public TerminalDebugger() {
        this(new InputStreamReader(System.in));
        this.interactive = true;
    }

    public TerminalDebugger(Reader reader) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public Context createContext() {
        DebugContext dc = new DebugContext();
        dc.addCommandListener(this);
        return dc;
    }

    void init(DebugContext dc) {
        dc.setDebugger(this);
        this.initialEvalDepth = Pnuts.evalDepth(dc);
        this.nsteps = 1;
        this.nnexts = 1;
        this.c_depth = 0;
        this.e_depth = 0;
        this.file = null;
        this.line = 0;
        this.trace_lines = false;
        this.trace_all_functions = false;
        this.trace_functions = new Hashtable();
        this.bpt_functions = new Hashtable();
        this.bpt_files = new Hashtable();
    }

    void setInput(BufferedReader reader) {
        this.reader = reader;
    }

    void exit(CommandEvent event) {
        if (this.session) {
            return;
        }
        DebugContext dc = (DebugContext)event.getSource();
        if (dc.getEvalDepth() <= this.initialEvalDepth && dc.getCallDepth() <= this.initialCallDepth) {
            PrintWriter term = dc.getTerminalWriter();
            term.println("# Returns " + Pnuts.format(event.getArg()));
            term.flush();
            this.initialized = false;
        }
    }

    public void setBreakPoint(Object file, int lineno) {
        Integer i;
        if (file == null) {
            return;
        }
        Vector<Integer> lines = (Vector<Integer>)this.bpt_files.get(file);
        if (lines == null) {
            lines = new Vector<Integer>();
            this.bpt_files.put(file, lines);
        }
        if (!lines.contains(i = new Integer(lineno))) {
            lines.addElement(i);
        }
    }

    Vector getBreakPoints(Object file) {
        block3: {
            block2: {
                if (!(file instanceof URL)) break block2;
                URL url = (URL)file;
                String f = url.getFile();
                Enumeration e = this.bpt_files.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (!f.endsWith(key)) continue;
                    return (Vector)this.bpt_files.get(key);
                }
                break block3;
            }
            if (!(file instanceof File)) break block3;
            String f = ((File)file).getPath();
            Enumeration e = this.bpt_files.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!f.endsWith(key)) continue;
                return (Vector)this.bpt_files.get(key);
            }
        }
        return null;
    }

    public void setBreakPointInFunction(String func_name) {
        if (this.bpt_functions.get(func_name) == null) {
            this.bpt_functions.put(func_name, func_name);
        }
    }

    public void setBreakPointInFunction(String func_name, int nargs) {
        String key = func_name + ":" + nargs;
        if (this.bpt_functions.get(key) == null) {
            this.bpt_functions.put(key, key);
        }
    }

    public void removeBreakPoint(Object source, int lineno) {
        if (source == null) {
            return;
        }
        Vector lines = (Vector)this.bpt_files.get(source);
        if (lines == null) {
            return;
        }
        lines.removeElement(new Integer(lineno + 1));
    }

    public void clearBreakPoints() {
        this.bpt_functions.clear();
        this.bpt_files.clear();
    }

    SimpleNode getTopNode(SimpleNode node) {
        SimpleNode parent;
        while (node != null && node.id != 3 && (parent = node.jjtGetParent()) != null && parent.id != 77) {
            node = parent;
        }
        return node;
    }

    public void signal(CommandEvent event) {
        DebugContext dc = (DebugContext)event.getSource();
        int eventType = event.getType();
        if (eventType == 2) {
            this.exit(event);
            return;
        }
        if (eventType == 1) {
            this.initialized = false;
            return;
        }
        if (eventType == 3) {
            Object[] a = (Object[])event.getArg();
            Function f = (Function)a[0];
            String fname = f.getName();
            Object[] args = (Object[])a[1];
            if (this.trace_all_functions || fname != null && this.trace_functions.get(fname) != null) {
                int depth = dc.getCallDepth();
                for (int i = 0; i < depth; ++i) {
                    System.err.print(' ');
                }
                String param = Pnuts.format(args);
                param = param.substring(1, param.length() - 1);
                System.err.println(fname + "(" + param + ") =>");
            }
        } else if (eventType == 4) {
            Object[] a = (Object[])event.getArg();
            Function f = (Function)a[0];
            String fname = f.getName();
            Object[] args = (Object[])a[1];
            if (this.trace_all_functions || fname != null && this.trace_functions.get(fname) != null) {
                int depth = dc.getCallDepth();
                for (int i = 0; i < depth; ++i) {
                    System.err.print(' ');
                }
                String param = Pnuts.format(args);
                param = param.substring(1, param.length() - 1);
                System.err.println(fname + "(" + param + ") <=");
            }
        } else {
            SimpleNode node = (SimpleNode)event.getArg();
            if (node != null) {
                this.lineUpdated(dc, node);
            }
        }
    }

    void lineUpdated(DebugContext dc, SimpleNode node) {
        if (this.session) {
            return;
        }
        PrintWriter term = dc.getTerminalWriter();
        int beginLine = dc.getBeginLine();
        int endLine = dc.getEndLine();
        if (!this.initialized) {
            this.init(dc);
            this.initialCallDepth = dc.getCallDepth();
            Object f = dc.getScriptSource();
            if (f == null) {
                f = "?";
            }
            term.println("# Stopped at " + f + ":" + beginLine);
            SimpleNode n = this.getTopNode(node);
            if (n != null) {
                term.print(indent);
                term.println(Runtime.unparse(n, dc));
            }
            this.c_depth = dc.getCallDepth();
            this.e_depth = dc.getEvalDepth();
            this.file = dc.getScriptSource();
            this.line = dc.getBeginLine();
            this.initialized = true;
            this.session(dc);
            return;
        }
        if (this.step) {
            if (this.file != dc.getScriptSource() || this.line != beginLine || this.c_depth != dc.getCallDepth()) {
                this.line = beginLine;
                this.file = dc.getScriptSource();
                this.c_depth = dc.getCallDepth();
                if (--this.nsteps < 1) {
                    Object f = this.file;
                    if (f == null) {
                        f = "?";
                    }
                    term.println("# Stopped at " + f + ":" + beginLine);
                    SimpleNode n = this.getTopNode(node);
                    if (n != null) {
                        term.print(indent);
                        term.println(Runtime.unparse(n, dc));
                    }
                    this.session(dc);
                } else if (this.trace_lines) {
                    term.print(this.file + ":" + this.line + indent);
                    term.println(Runtime.unparse(node, dc));
                    term.flush();
                }
            }
        } else if (this.step_up) {
            if (this.e_depth > dc.getEvalDepth() || this.e_depth >= dc.getEvalDepth() && this.c_depth > dc.getCallDepth()) {
                this.line = beginLine;
                this.file = dc.getScriptSource();
                this.c_depth = dc.getCallDepth();
                Object f = this.file;
                if (f == null) {
                    f = "?";
                }
                term.println("# Stopped at " + f + ":" + beginLine);
                SimpleNode n = this.getTopNode(node);
                if (n != null) {
                    term.print(indent);
                    term.println(Runtime.unparse(n, dc));
                }
                this.session(dc);
            } else if (this.trace_lines) {
                term.print(this.file + ":" + this.line + indent);
                term.println(Runtime.unparse(node, dc));
                term.flush();
            }
        } else if (this.next && this.e_depth >= dc.getEvalDepth() && this.c_depth >= dc.getCallDepth()) {
            if (this.file != dc.getScriptSource() || this.line != beginLine || this.c_depth != dc.getCallDepth()) {
                this.line = beginLine;
                this.file = dc.getScriptSource();
                this.c_depth = dc.getCallDepth();
                if (--this.nnexts < 1) {
                    Object f = this.file;
                    if (f == null) {
                        f = "?";
                    }
                    term.println("# Stopped at " + f + ":" + beginLine);
                    SimpleNode n = this.getTopNode(node);
                    if (n != null) {
                        term.print(indent);
                        term.println(Runtime.unparse(n, dc));
                    }
                    this.session(dc);
                }
            } else if (this.trace_lines) {
                term.print(this.file + ":" + this.line + indent);
                term.println(Runtime.unparse(node, dc));
                term.flush();
            }
        } else {
            String name;
            Vector lines;
            Object file = dc.getScriptSource();
            if (this.trace_lines) {
                term.print(file + ":" + beginLine + indent);
                term.println(Runtime.unparse(node, dc));
                term.flush();
            }
            if (file != null && (lines = this.getBreakPoints(file)) != null && this.checkBreakPoint(lines, node.id, beginLine, endLine) && (this.line != beginLine || this.c_depth != dc.getCallDepth())) {
                this.line = beginLine;
                this.file = dc.getScriptSource();
                this.c_depth = dc.getCallDepth();
                Object f = this.file;
                if (f == null) {
                    f = "?";
                }
                term.println("# Stopped at " + f + ":" + beginLine);
                SimpleNode n = this.getTopNode(node);
                if (n != null) {
                    term.print(indent);
                    term.println(Runtime.unparse(n, dc));
                }
                this.session(dc);
                return;
            }
            if (node.id == 22 && (name = node.jjtGetChild((int)0).str) != null && this.bpt_functions.get(name) != null) {
                Object f = this.file;
                if (f == null) {
                    f = "?";
                }
                term.println("# Stopped at " + f + ":" + beginLine);
                SimpleNode n = this.getTopNode(node);
                if (n != null) {
                    term.print(indent);
                    term.println(Runtime.unparse(n, dc));
                }
                this.session(dc);
            }
        }
    }

    boolean checkBreakPoint(Vector lines, int nodeID, int begin, int end) {
        if (nodeID == 77) {
            return false;
        }
        Enumeration e = lines.elements();
        while (e.hasMoreElements()) {
            int bp = (Integer)e.nextElement();
            if (bp < begin || bp > end) continue;
            return true;
        }
        return false;
    }

    String getCommand() {
        String cmd = null;
        try {
            cmd = this.reader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void session(DebugContext context) {
        this.step = false;
        this.step_up = false;
        this.next = false;
        while (true) {
            String arg;
            this.file = context.getScriptSource();
            this.c_depth = context.getCallDepth();
            this.e_depth = context.getEvalDepth();
            PrintWriter term = context.getTerminalWriter();
            if (this.interactive) {
                term.print("debug> ");
                term.flush();
            }
            String cmd = this.getCommand();
            if (!this.interactive) {
                term.println("debug> " + cmd);
            }
            if (cmd == null) {
                return;
            }
            int offset = 0;
            offset = cmd.indexOf("stop at ");
            if (offset >= 0) {
                arg = cmd.substring(offset + "stop at ".length()).trim();
                int idx = arg.indexOf(58);
                if (idx < 0) {
                    Object f = context.getScriptSource();
                    String s = null;
                    if (f instanceof URL) {
                        s = ((URL)f).getFile();
                    } else if (f instanceof File) {
                        s = ((File)f).getPath();
                    } else if (f instanceof Runtime) {
                        s = f.getClass().getName();
                    }
                    this.setBreakPoint(s, Integer.parseInt(arg));
                    continue;
                }
                this.setBreakPoint(arg.substring(0, idx), Integer.parseInt(arg.substring(idx + 1)));
                continue;
            }
            offset = cmd.indexOf("stop in ");
            if (offset >= 0) {
                arg = cmd.substring(offset + "stop at ".length()).trim();
                int idx = arg.indexOf(58);
                if (idx < 0) {
                    this.setBreakPointInFunction(arg);
                    continue;
                }
                this.setBreakPointInFunction(arg.substring(0, idx), Integer.parseInt(arg.substring(idx + 1)));
                continue;
            }
            if ("help".equals(cmd) || "?".equals(cmd)) {
                try {
                    ResourceBundle rb = ResourceBundle.getBundle("pnuts.tools.debug");
                    String help = rb.getString("pnuts.debug.help");
                    term.println(help);
                }
                catch (MissingResourceException mis) {
                    mis.printStackTrace(term);
                }
                continue;
            }
            offset = cmd.indexOf("step");
            if (offset >= 0) {
                arg = cmd.substring(offset + "step".length()).trim();
                if (arg.indexOf("up") >= 0) {
                    this.file = context.getScriptSource();
                    this.c_depth = context.getCallDepth();
                    this.e_depth = context.getEvalDepth();
                    this.step_up = true;
                    return;
                }
                if (arg.length() > 0 && Character.isDigit(arg.charAt(0))) {
                    this.step = true;
                    this.nsteps = Integer.parseInt(arg);
                    return;
                }
                this.step = true;
                this.nsteps = 1;
                return;
            }
            offset = cmd.indexOf("next");
            if (offset >= 0) {
                arg = cmd.substring(offset + "step".length()).trim();
                this.nnexts = arg.length() > 0 && Character.isDigit(arg.charAt(0)) ? Integer.parseInt(arg) : 1;
                this.next = true;
                this.c_depth = context.getCallDepth();
                this.e_depth = context.getEvalDepth();
                this.file = context.getScriptSource();
                return;
            }
            offset = cmd.indexOf("trace function");
            if (offset >= 0) {
                arg = cmd.substring(offset + "trace_function".length()).trim();
                if (arg.length() > 0) {
                    if (this.trace_functions.get(arg) == null) {
                        this.trace_functions.put(arg, arg);
                        continue;
                    }
                    this.trace_functions.remove(arg);
                    continue;
                }
                boolean bl = this.trace_all_functions = !this.trace_all_functions;
                if (this.trace_all_functions) {
                    term.println("on");
                    continue;
                }
                term.println("off");
                continue;
            }
            if ("trace".equals(cmd)) {
                boolean bl = this.trace_lines = !this.trace_lines;
                if (this.trace_lines) {
                    term.println("on");
                    continue;
                }
                term.println("off");
                continue;
            }
            if ("cont".equals(cmd)) {
                return;
            }
            if ("clear".equals(cmd)) {
                this.clearBreakPoints();
                continue;
            }
            try {
                this.session = true;
                Context c = (Context)context.clone(false, false, true);
                term.println(Pnuts.format(Pnuts.eval(cmd, c)));
                continue;
            }
            catch (Throwable t) {
                term.println(t);
                continue;
            }
            finally {
                this.session = false;
                continue;
            }
            break;
        }
    }
}

