/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import pnuts.lang.Function;
import pnuts.lang.ParseException;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsFunction;
import pnuts.lang.PnutsParser;
import pnuts.lang.Runtime;
import pnuts.lang.SimpleNode;

class SimpleFunctionSerializer
implements Runtime.FunctionSerializer {
    SimpleFunctionSerializer() {
    }

    public void serialize(PnutsFunction pnutsFunction, ObjectOutputStream s) throws IOException {
        Function[] functions = pnutsFunction.functions;
        int n = functions.length;
        s.writeInt(n);
        for (int i = 0; i < n; ++i) {
            Function f = functions[i];
            if (f != null && f.node == null) {
                s.writeObject(f.unparse(null));
                f.writeAttributes(s);
                continue;
            }
            s.writeObject(f);
        }
    }

    public void deserialize(PnutsFunction pnutsFunction, ObjectInputStream s) throws IOException, ClassNotFoundException {
        int n = s.readInt();
        Function[] functions = new Function[n];
        pnutsFunction.functions = functions;
        for (int i = 0; i < n; ++i) {
            Object f = s.readObject();
            if (f instanceof Function) {
                functions[i] = (Function)f;
                continue;
            }
            if (f instanceof SimpleNode) {
                SimpleNode node = (SimpleNode)f;
                Function func = new Function();
                func.readAttributes(s);
                func.node = node.jjtGetChild(1);
                func.function = pnutsFunction;
                functions[i] = func;
                continue;
            }
            if (!(f instanceof String)) continue;
            try {
                Function func = new Function();
                func.readAttributes(s);
                PnutsParser parser = Pnuts.getParser(new StringReader((String)f));
                SimpleNode node = parser.FunctionStatement(null);
                func.node = node.jjtGetChild(1);
                func.function = pnutsFunction;
                functions[i] = func;
                continue;
            }
            catch (ParseException pe) {
                pe.printStackTrace();
            }
        }
    }
}

