/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import pnuts.lang.Context;
import pnuts.lang.Implementation;
import pnuts.lang.ParseException;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsInterpreter;
import pnuts.lang.Runtime;
import pnuts.lang.SimpleNode;

public class PnutsImpl
extends Runtime
implements Implementation {
    static PnutsImpl defaultPnutsImpl = PnutsImpl._getInstance();
    protected Properties properties = new Properties();

    static PnutsImpl _getInstance() {
        return PnutsImpl._getInstance(Runtime.getProperty("pnuts.lang.defaultPnutsImpl"));
    }

    static PnutsImpl _getInstance(String className) {
        return PnutsImpl._getInstance(className, Pnuts.defaultSettings);
    }

    static PnutsImpl _getInstance(String className, Properties properties) {
        PnutsImpl impl = null;
        if (className != null) {
            try {
                Class<?> cls = Class.forName(className);
                impl = (PnutsImpl)cls.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (impl == null) {
            impl = new PnutsImpl();
        }
        if (properties != null) {
            impl.setProperties(properties);
        }
        return impl;
    }

    public static PnutsImpl getDefault() {
        return defaultPnutsImpl;
    }

    static PnutsImpl getDefault(Properties properties) {
        try {
            return PnutsImpl._getInstance(properties.getProperty("pnuts.lang.defaultPnutsImpl"), properties);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new PnutsImpl();
        }
    }

    public void setProperties(Properties properties) {
        Iterator it = ((Hashtable)properties).entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String queryProperty(String key) {
        return this.properties.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String expr, Context context) {
        Context old = Runtime.getThreadContext();
        Runtime.setThreadContext(context);
        try {
            this.pushFile(expr, context);
            Object object = Pnuts.parse(expr).accept(PnutsInterpreter.getInstance(), context);
            return object;
        }
        catch (ParseException e) {
            context.beginLine = e.getErrorLine();
            Runtime.checkException(context, e);
            Object var5_6 = null;
            return var5_6;
        }
        finally {
            this.popFile(context);
            Runtime.setThreadContext(old);
        }
    }

    public Object loadFile(String filename, Context context) throws FileNotFoundException {
        URL scriptURL = null;
        try {
            File f = new File(filename);
            if (!f.exists()) {
                throw new FileNotFoundException(filename);
            }
            scriptURL = Runtime.fileToURL(f);
        }
        catch (IOException e1) {
            throw new FileNotFoundException(filename);
        }
        return this.load(scriptURL, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(String file, Context context) throws FileNotFoundException {
        URL url = Runtime.getScriptURL(file, context);
        if (url == null) {
            throw new FileNotFoundException(file);
        }
        this.provide(file, context);
        boolean completed = false;
        try {
            Object result = this.load(url, context);
            completed = true;
            Object object = result;
            return object;
        }
        finally {
            if (!completed) {
                this.revoke(file, context);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public Object load(URL scriptURL, Context context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object accept(SimpleNode node, Context context) {
        Context old = Runtime.getThreadContext();
        Runtime.setThreadContext(context);
        try {
            Object object = node.accept(PnutsInterpreter.getInstance(), context);
            return object;
        }
        finally {
            Runtime.setThreadContext(old);
        }
    }

    protected void pushFile(Object file, Context context) {
        context.pushFile(file);
    }

    protected void popFile(Context context) {
        context.popFile();
    }

    protected void provide(String file, Context context) {
        if (file.endsWith(".pnut")) {
            file = file.substring(0, file.length() - 5);
        }
        context.provide(file);
    }

    protected void revoke(String file, Context context) {
        if (file.endsWith(".pnut")) {
            file = file.substring(0, file.length() - 5);
        }
        context.revoke(file);
    }
}

