/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import pnuts.lang.AutoloadHook;
import pnuts.lang.Binding;
import pnuts.lang.Context;
import pnuts.lang.NamedValue;
import pnuts.lang.PackageFactory;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;
import pnuts.lang.Property;
import pnuts.lang.Runtime;
import pnuts.lang.SymbolTable;

public class Package
extends SymbolTable
implements Property,
Serializable,
Cloneable {
    private static final boolean DEBUG = false;
    static final long serialVersionUID = 7341649520738070427L;
    protected transient Hashtable packages;
    public static final Package globalPackage;
    protected transient Package parent;
    private transient Vector children;
    protected transient Package root;
    protected SymbolTable autoloadTable;
    protected SymbolTable exportedSymbols;
    protected Vector requiredModuleNames;
    protected Vector providedModuleNames;
    protected boolean exports;
    protected boolean usedAsModule = false;
    protected boolean initialized = false;
    transient Object moduleIntializationLock = new Object();
    private HashSet autoloadingSymbols = new HashSet();
    protected String name;
    private static PackageFactory factory;

    public static Package getGlobalPackage() {
        return globalPackage;
    }

    public Package newInstance(String name) {
        return new Package(name);
    }

    static Package getInstance(String name, Package parent, Context context) {
        Package p = null;
        if (parent != null) {
            Hashtable tab;
            if (name != null && (p = (Package)(tab = context.rootPackage.packages).get(name)) != null) {
                return p;
            }
            p = parent.newInstance(name);
            p.parent = parent;
            p.root = parent.root;
            if (p.name != null) {
                context.rootPackage.addPackage(p, context);
            }
            return p;
        }
        if (factory != null) {
            return factory.createPackage(name, null);
        }
        return new Package(name, null);
    }

    protected void addPackage(Package pkg, Context context) {
        this.packages.put(pkg.name, pkg);
        Package parent = pkg.parent;
        if (parent != null) {
            Vector<Package> children = parent.children;
            if (children == null) {
                parent.children = children = new Vector<Package>(10);
                children.addElement(pkg);
            } else if (!children.contains(pkg)) {
                children.addElement(pkg);
            }
        }
    }

    protected void removePackage(Package pkg, Context context) {
        Package p2 = pkg.parent;
        if (p2 == null) {
            return;
        }
        if (p2.children != null) {
            p2.children.removeElement(pkg);
        }
        this.packages.remove(pkg.name);
    }

    public static Package getPackage(String pkg) {
        return Package.getPackage(pkg, null);
    }

    public static Package getPackage(String pkg, Context context) {
        if (context == null) {
            context = Runtime.getThreadContext();
        }
        Package rootPackage = context == null ? globalPackage : context.rootPackage;
        Hashtable packages = rootPackage.packages;
        Package p = rootPackage;
        Package existing = (Package)packages.get(pkg);
        if (existing != null) {
            return existing;
        }
        int index = pkg.indexOf("::");
        String rest = pkg;
        StringBuffer sbuf = new StringBuffer();
        while (index > 0) {
            sbuf.append(rest.substring(0, index));
            String s = sbuf.toString();
            if (rootPackage.get(s, null) instanceof Class) {
                throw new PnutsException("package name and Class conflicted: " + pkg, context);
            }
            p = Package.getInstance(s, p, context);
            rest = rest.substring(index + 2);
            index = rest.indexOf("::");
            sbuf.append("::");
        }
        sbuf.append(rest);
        return Package.getInstance(sbuf.toString(), p, context);
    }

    String getInitScript() {
        String s = Package.getInitScript(this.name, "::");
        return Package.getInitScript(s, ".") + "/init";
    }

    static String getInitScript(String name, String delimiter) {
        int index = name.indexOf(delimiter);
        int len = delimiter.length();
        int start = 0;
        StringBuffer sbuf = new StringBuffer();
        while (index > 0) {
            sbuf.append(name.substring(start, index));
            sbuf.append('/');
            start = index + len;
            index = name.indexOf(delimiter, start);
        }
        sbuf.append(name.substring(start));
        return sbuf.toString();
    }

    public boolean defined(String name, Context context) {
        return this.lookup0(name) != null;
    }

    public Object get(String symbol, Context context) {
        NamedValue b = this.lookupRecursively(symbol, context);
        if (b == null) {
            return null;
        }
        return b.get();
    }

    public void set(String symbol, Object obj, Context context) {
        Binding b;
        try {
            this.set(symbol, obj);
        }
        catch (IllegalStateException e) {
            throw new PnutsException("constant.modification", new Object[]{symbol}, context);
        }
        if (this.usedAsModule && (b = this.exportedSymbols.lookup0(symbol)) != null) {
            b.value = obj;
        }
    }

    public void export(String name) {
        if (!this.usedAsModule) {
            throw new IllegalStateException("exporting " + name + " in " + this.getName());
        }
        Binding b = this.lookup0(name = name.intern());
        if (b != null) {
            this.exportedSymbols.set(name, b.value);
        } else if (this.autoloadTable != null && (b = this.autoloadTable.lookup0(name)) != null) {
            b.value = new DelayedExports((AutoloadHook)b.value, false);
        }
        this.exports = true;
    }

    void exportFunctions() {
        Binding b;
        Enumeration e = this.bindings();
        while (e.hasMoreElements()) {
            b = (Binding)e.nextElement();
            this.exportFunction(b.name, b.value);
        }
        if (this.autoloadTable != null) {
            e = this.autoloadTable.bindings();
            while (e.hasMoreElements()) {
                b = (Binding)e.nextElement();
                AutoloadHook hook = (AutoloadHook)b.value;
                b.value = new DelayedExports(hook, true);
            }
        }
    }

    void exportFunction(String sym, Object value) {
        PnutsFunction f;
        if (value instanceof PnutsFunction && (f = (PnutsFunction)value).getName() == sym) {
            this.exportedSymbols.set(sym, f);
        }
    }

    public void clear(String symbol, Context context) {
        this.removeBinding(symbol);
    }

    public static void remove(String name) {
        Package root = globalPackage;
        Package p = (Package)root.packages.get(name);
        if (p == null) {
            return;
        }
        root.removePackage(p, null);
    }

    public static void remove(String name, Context context) {
        Package root = context.rootPackage;
        Package p = (Package)root.packages.get(name);
        if (p == null) {
            return;
        }
        root.removePackage(p, context);
    }

    public static Package find(String pkg) {
        return (Package)Package.globalPackage.packages.get(pkg);
    }

    public static Package find(String pkg, Context context) {
        return (Package)context.rootPackage.packages.get(pkg);
    }

    public Package() {
        this((String)null);
    }

    public Package(String name) {
        this(name, globalPackage);
    }

    public Package(String name, Package parent) {
        if (name != null) {
            this.name = name.intern();
        }
        this.parent = parent;
        this.root = parent == null ? this : parent.root;
    }

    protected Package(String name, Package parent, Package root) {
        if (name != null) {
            this.name = name.intern();
        }
        this.parent = parent;
        this.root = root;
    }

    protected synchronized void init(Context context) {
        if (this.root == this && this.packages == null) {
            Hashtable<String, Package> tab = new Hashtable<String, Package>(10);
            if (this.name != null) {
                tab.put(this.name, this);
            }
            this.packages = tab;
        }
    }

    public String getName() {
        return this.name;
    }

    public Package getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamedValue lookup(String symbol, Context context) {
        Binding v = this.lookup0(symbol);
        if (v != null) {
            return v;
        }
        Package package_ = this;
        synchronized (package_) {
            AutoloadHook hook;
            SymbolTable tab = this.autoloadTable;
            if (tab != null && (hook = (AutoloadHook)tab.get(symbol)) != null) {
                if (this.autoloadingSymbols.contains(symbol)) {
                    return null;
                }
                this.autoloadingSymbols.add(symbol);
                try {
                    hook.load(symbol, context);
                }
                finally {
                    this.autoloadingSymbols.remove(symbol);
                }
                v = this.lookup0(symbol);
                if (v != null) {
                    return v;
                }
            }
        }
        return null;
    }

    protected NamedValue lookupRecursively(String symbol, Context context) {
        NamedValue v = this.lookup(symbol, context);
        if (v == null && this.parent != null) {
            return this.parent.lookupRecursively(symbol, context);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamedValue lookupExportedSymbol(String symbol, Context context) {
        if (!this.usedAsModule) {
            return null;
        }
        Binding v = this.exportedSymbols.lookup0(symbol);
        if (v != null) {
            return v;
        }
        Package package_ = this;
        synchronized (package_) {
            AutoloadHook hook;
            SymbolTable tab = this.autoloadTable;
            if (tab != null && (hook = (AutoloadHook)tab.get(symbol)) != null) {
                if (this.autoloadingSymbols.contains(symbol)) {
                    return null;
                }
                this.autoloadingSymbols.add(symbol);
                try {
                    hook.load(symbol, context);
                }
                finally {
                    this.autoloadingSymbols.remove(symbol);
                }
                if (this.usedAsModule && (v = this.exportedSymbols.lookup0(symbol)) != null) {
                    return v;
                }
            }
        }
        return null;
    }

    protected synchronized void initializeModule() {
        this.exportedSymbols = new SymbolTable();
        this.requiredModuleNames = new Vector();
        this.providedModuleNames = new Vector();
        this.usedAsModule = true;
    }

    public Enumeration elements() {
        if (this.children == null) {
            this.children = new Vector(10);
        }
        return this.children.elements();
    }

    public Object clone() {
        if (this.autoloadTable == null) {
            this.autoloadTable = new SymbolTable();
        }
        Package p = (Package)super.clone();
        if (this.root == this) {
            p.root = p;
            if (this.packages != null) {
                Hashtable tab = (Hashtable)this.packages.clone();
                Enumeration e = tab.keys();
                while (e.hasMoreElements()) {
                    String pkgName = (String)e.nextElement();
                    Package pkg = (Package)tab.get(pkgName);
                    if (pkg.root == pkg) {
                        tab.put(pkgName, p);
                        continue;
                    }
                    if (pkg.root != this.root) continue;
                    pkg.root = p;
                }
                p.packages = tab;
                if (this.name != null) {
                    tab.put(this.name, p);
                }
            }
            if (this.children != null) {
                p.children = (Vector)this.children.clone();
            }
        } else if (this.usedAsModule) {
            p.exportedSymbols = (SymbolTable)this.exportedSymbols.clone();
            p.requiredModuleNames = (Vector)this.requiredModuleNames.clone();
            p.providedModuleNames = (Vector)this.providedModuleNames.clone();
        }
        return p;
    }

    public void autoload(String name, String file, Context context) {
        if (file == null) {
            this.autoload(name, null);
        } else {
            this.autoload(name, new Runtime.AutoloadScript(file, context));
        }
    }

    public void autoload(String name, AutoloadHook hook) {
        if (this.autoloadTable == null) {
            this.autoloadTable = new SymbolTable();
        }
        name = name.intern();
        if (hook == null) {
            this.autoloadTable.removeBinding(name);
        } else {
            this.autoloadTable.set(name, hook);
        }
    }

    public String toString() {
        if (this.name != null) {
            return "package \"" + this.name + "\"";
        }
        return "package null";
    }

    static {
        try {
            Object obj;
            String prop = Runtime.getProperty("pnuts.package.factory");
            if (prop != null && (obj = Class.forName(prop).newInstance()) instanceof PackageFactory) {
                factory = (PackageFactory)obj;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        globalPackage = Package.getInstance("", null, null);
    }

    class DelayedExports
    implements AutoloadHook,
    Serializable {
        private AutoloadHook hook;
        private boolean func;

        DelayedExports(AutoloadHook hook, boolean onlyFunction) {
            this.hook = hook;
            this.func = onlyFunction;
        }

        public void load(String name, Context context) {
            Context c = (Context)context.clone();
            c.setCurrentPackage(Package.this);
            this.hook.load(name, c);
            if (this.func) {
                Binding v = Package.this.lookup0(name);
                if (v != null) {
                    Package.this.exportFunction(name, v.value);
                }
            } else {
                Package.this.export(name);
            }
        }
    }
}

