/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pnuts.lang.Context;
import pnuts.lang.NamedValue;
import pnuts.lang.Package;
import pnuts.lang.Runtime;
import pnuts.lang.SymbolTable;
import pnuts.lang.Value;

class ModuleList
implements Cloneable,
Serializable {
    transient ArrayList usedPackages = new ArrayList();
    transient Package basePackage;
    private transient SymbolTable cache = new SymbolTable();
    private int modCount = 0;

    ModuleList(Package basePackage) {
        this.basePackage = basePackage;
    }

    synchronized void add(Package pkg) {
        this.usedPackages.remove(pkg);
        this.usedPackages.add(pkg);
        ++this.modCount;
        this.cache = new SymbolTable();
    }

    synchronized boolean remove(Package pkg) {
        if (this.usedPackages.remove(pkg)) {
            ++this.modCount;
            this.cache = new SymbolTable();
            return true;
        }
        return false;
    }

    boolean contains(Package pkg) {
        return this.usedPackages.contains(pkg);
    }

    synchronized void clear() {
        this.usedPackages.clear();
        this.cache = new SymbolTable();
        ++this.modCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Value resolve(String symbol, Context context) {
        NamedValue v = this.cache.lookup0(symbol);
        if (v != null) {
            return v;
        }
        block3: while (true) {
            int size = this.usedPackages.size();
            int m = this.modCount;
            for (int i = 0; i < size; ++i) {
                Package pkg = (Package)this.usedPackages.get(size - i - 1);
                v = pkg.lookupExportedSymbol(symbol, context);
                if (v != null) {
                    SymbolTable symbolTable = this.cache;
                    synchronized (symbolTable) {
                        this.cache.set(symbol, v.get());
                    }
                    return v;
                }
                if (this.modCount != m) continue block3;
            }
            break;
        }
        return null;
    }

    public Object clone() {
        try {
            ModuleList mlist = (ModuleList)super.clone();
            mlist.usedPackages = (ArrayList)this.usedPackages.clone();
            mlist.cache = new SymbolTable();
            mlist.modCount = 0;
            return mlist;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    String[] getPackageNames() {
        int size = this.usedPackages.size();
        String[] names = new String[size];
        int i = 0;
        Iterator it = ((AbstractList)this.usedPackages).iterator();
        while (it.hasNext()) {
            Package p = (Package)it.next();
            names[i++] = p.getName();
        }
        return names;
    }

    public int hashCode() {
        return ((AbstractList)this.usedPackages).hashCode() ^ this.basePackage.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModuleList) {
            ModuleList m = (ModuleList)obj;
            return ((AbstractList)this.usedPackages).equals(m.usedPackages) && this.basePackage.equals(m.basePackage);
        }
        return false;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeUTF(this.basePackage.getName());
        int size = this.usedPackages.size();
        s.writeInt(size);
        for (int i = 0; i < size; ++i) {
            Package p = (Package)this.usedPackages.get(i);
            s.writeUTF(p.getName());
        }
    }

    private static void readPackage(Context ctx, String pkgName, List newPkgs) throws IOException {
        Package pkg = Package.getPackage(pkgName, ctx);
        newPkgs.add(pkg);
        ModuleList m = ctx.moduleList;
        if (m == null || !m.contains(pkg)) {
            pkg.initializeModule();
            if (!pkg.initialized) {
                ctx.loadModule(pkgName, pkg);
                ArrayList results = ctx.moduleList.usedPackages;
                Iterator it = results.iterator();
                while (it.hasNext()) {
                    Package p = (Package)it.next();
                    if (newPkgs.contains(p)) continue;
                    p.initializeModule();
                    if (!p.initialized) {
                        ctx.loadModule(p.getName(), p);
                        p.initialized = true;
                    }
                    newPkgs.add(p);
                }
                pkg.initialized = true;
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Context ctx = Runtime.getThreadContext();
        if (ctx == null) {
            ctx = new Context();
        }
        String baseName = s.readUTF();
        this.basePackage = Package.getPackage(baseName, ctx);
        ArrayList newPkgs = new ArrayList();
        this.cache = new SymbolTable();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            String pkgName = s.readUTF();
            ModuleList.readPackage(ctx, pkgName, newPkgs);
        }
        this.usedPackages = newPkgs;
    }
}

