/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.util.ArrayList;
import org.pnuts.lang.GeneratorHelper;
import org.pnuts.util.Stack;
import pnuts.lang.Context;
import pnuts.lang.Escape;
import pnuts.lang.Function;
import pnuts.lang.Jump;
import pnuts.lang.Package;
import pnuts.lang.PnutsFunction;
import pnuts.lang.PnutsInterpreter;
import pnuts.lang.SimpleNode;

public class Generator {
    Context context;
    private PnutsFunction gfunc;

    protected Generator() {
    }

    public Generator(PnutsFunction gfunc) {
        this.gfunc = gfunc;
    }

    public Object apply(PnutsFunction closure, Context context) {
        return this.gfunc.exec(new Object[]{closure}, context);
    }

    public Object[] toArray() {
        final ArrayList elements = new ArrayList();
        this.apply(new PnutsFunction(){

            protected Object exec(Object[] args, Context context) {
                elements.add(args[0]);
                return null;
            }
        }, this.context);
        return elements.toArray();
    }

    public String toString() {
        return "<generator>";
    }

    public static SimpleNode convertYield(SimpleNode node, String closureSymbol) {
        Stack stack = new Stack();
        return Generator.convertYield(node, stack, closureSymbol);
    }

    static SimpleNode convertYield(SimpleNode node, Stack stack, String closureSymbol) {
        if (node.id == 75) {
            SimpleNode applicationNode = new SimpleNode(22);
            SimpleNode idNode = new SimpleNode(5);
            idNode.str = closureSymbol;
            applicationNode.jjtAddChild(idNode, 0);
            SimpleNode argNode = new SimpleNode(6);
            argNode.jjtAddChild(Generator.convertYield(node.jjtGetChild(0), closureSymbol), 0);
            applicationNode.jjtAddChild(argNode, 1);
            return applicationNode;
        }
        stack.push(node);
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode ni = node.jjtGetChild(i);
            SimpleNode c = Generator.convertYield(ni, stack, closureSymbol);
            node.jjtAddChild(c, i);
            c.jjtSetParent(node);
        }
        return (SimpleNode)stack.pop();
    }

    public static class Break
    extends Escape {
        public Break(Object value) {
            super(value);
        }
    }

    static class GeneratorFunction
    extends Function {
        private SimpleNode gnode;
        private static long ID = 0L;
        private Context ctx;
        private String closureSymbol;

        protected GeneratorFunction(String name, String[] locals, int nargs, SimpleNode node, Package pkg, Context context) {
            super(name, locals, nargs, node, pkg, context);
            String identity = Long.toHexString(ID++);
            this.closureSymbol = ("!<closure" + identity + ">").intern();
            this.gnode = Generator.convertYield(GeneratorHelper.renameLocals(node, identity), this.closureSymbol);
            this.ctx = (Context)context.clone(false, false);
            String[] newLocals = new String[locals.length];
            for (int i = 0; i < locals.length; ++i) {
                newLocals[i] = (locals[i] + "!" + identity).intern();
            }
            this.locals = newLocals;
        }

        protected Object exec(final Object[] args, Context _context) {
            Generator gen = new Generator();
            gen.context = _context;
            final Context context = this.ctx;
            gen.gfunc = new PnutsFunction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Object exec(Object[] a, Context ctx) {
                    try {
                        int i;
                        PnutsFunction closure = (PnutsFunction)a[0];
                        String[] lc = new String[GeneratorFunction.this.locals.length + 1];
                        for (i = 0; i < GeneratorFunction.this.locals.length; ++i) {
                            lc[i] = GeneratorFunction.this.locals[i];
                        }
                        lc[GeneratorFunction.this.locals.length] = GeneratorFunction.this.closureSymbol;
                        context.openLocal(lc);
                        context.bind(GeneratorFunction.this.closureSymbol, closure);
                        for (i = 0; i < GeneratorFunction.this.locals.length; ++i) {
                            context.bind(GeneratorFunction.this.locals[i], args[i]);
                        }
                        Object object = GeneratorFunction.this.gnode.accept(PnutsInterpreter.instance, context);
                        return object;
                    }
                    catch (Jump j) {
                        Object object = j.getValue();
                        return object;
                    }
                    finally {
                        context.closeLocal();
                    }
                }
            };
            return gen;
        }
    }
}

