/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.pnuts.util.Cell;
import pnuts.lang.Configuration;
import pnuts.lang.Context;
import pnuts.lang.ImportEnv;
import pnuts.lang.ModuleList;
import pnuts.lang.NamedValue;
import pnuts.lang.Package;
import pnuts.lang.PnutsFunction;
import pnuts.lang.PnutsInterpreter;
import pnuts.lang.Runtime;
import pnuts.lang.SimpleNode;
import pnuts.lang.StackFrame;
import pnuts.lang.SymbolTable;
import pnuts.lang.Visitor;

public class Function
extends Runtime
implements Serializable {
    static final long serialVersionUID = -3930895958604659360L;
    protected String funcName;
    protected String name;
    boolean anonymous;
    protected int nargs;
    protected String[] locals;
    protected transient Object file;
    protected SimpleNode node;
    SymbolTable lexicalScope;
    protected ImportEnv importEnv;
    protected ModuleList moduleList;
    protected Function outer;
    protected String pkgName;
    protected PnutsFunction function;
    protected transient Package pkg;
    protected Configuration config;
    boolean finallySet;

    protected Function() {
    }

    Function(Function func) {
        this.funcName = func.funcName;
        this.name = func.name;
        this.anonymous = func.anonymous;
        this.locals = func.locals;
        this.nargs = func.nargs;
        this.pkg = func.pkg;
        this.pkgName = func.pkgName;
        this.lexicalScope = func.lexicalScope;
        this.importEnv = func.importEnv;
        this.moduleList = func.moduleList;
        this.file = func.file;
        this.outer = func.outer;
        this.node = func.node;
        this.config = func.config;
        this.function = func.function;
    }

    protected Function(String func, String[] locals, int nargs, SimpleNode node, Package pkg, Context context) {
        if (context.frame != null) {
            this.outer = context.frame;
            this.file = this.outer.file;
            this.importEnv = this.outer.importEnv;
        } else {
            Cell c = context.loadingResource;
            if (c != null) {
                this.file = c.object;
            }
            this.importEnv = context.importEnv;
        }
        this.config = context.config;
        this.moduleList = context.localModuleList();
        if (func != null) {
            this.name = func;
        } else {
            this.name = "";
            this.anonymous = true;
        }
        this.nargs = nargs;
        this.locals = locals;
        this.node = node;
        this.pkg = pkg;
        this.pkgName = pkg.getName();
        StackFrame lex = context.stackFrame;
        if (lex != null) {
            SymbolTable tab = new SymbolTable();
            lex.makeLexicalScope(tab);
            this.lexicalScope = tab;
        }
    }

    public synchronized String getName() {
        if (this.funcName == null) {
            Function of = this.outer;
            this.funcName = of != null ? of.getName() + "." + this.name : this.name;
        }
        return this.funcName;
    }

    public int getNumberOfParameter() {
        return this.nargs;
    }

    public Object getScriptSource() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object exec(Object[] args, Context context) {
        try {
            context.open(this, args);
            Object object = this.node.accept(PnutsInterpreter.instance, context);
            return object;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            Runtime.checkException(context, t);
            Object var4_7 = null;
            return var4_7;
        }
        finally {
            NamedValue b;
            if (this.finallySet && (b = context.stackFrame.lookup(Context.finallyFunctionSymbol)) != null) {
                ((PnutsFunction)b.get()).call(new Object[0], context);
            }
            context.close(this, args);
        }
    }

    public Package getPackage() {
        return this.pkg;
    }

    public void setPackage(Package pkg) {
        this.pkg = pkg;
    }

    public String[] getImportEnv() {
        return this.importEnv.list();
    }

    String paramString() {
        StringBuffer sbuf = new StringBuffer("");
        sbuf.append("(");
        if (this.nargs != 0) {
            sbuf.append(this.locals[0]);
        }
        if (this.nargs == -1) {
            sbuf.append("[]");
        } else {
            for (int i = 1; i < this.nargs; ++i) {
                sbuf.append(",");
                sbuf.append(this.locals[i]);
            }
        }
        sbuf.append(")");
        return sbuf.toString();
    }

    protected PnutsFunction register(PnutsFunction pf) {
        return this.register(pf, false);
    }

    protected PnutsFunction register(PnutsFunction pf, boolean isChild) {
        if (pf == null) {
            pf = this.anonymous ? new PnutsFunction() : new PnutsFunction(this.name);
            pf.pkg = this.pkg;
        } else if (isChild || pf.count == 0 || pf.pkg != this.pkg) {
            PnutsFunction func = new PnutsFunction(this.name, pf);
            func.pkg = this.pkg;
            func.put(this.nargs, this);
            return func;
        }
        pf.put(this.nargs, this);
        return pf;
    }

    protected SimpleNode getNode() {
        if (this.node != null) {
            return this.node.jjtGetParent();
        }
        return null;
    }

    protected Object accept(Visitor visitor, Context context) {
        return this.getNode().accept(visitor, context);
    }

    protected String unparse(Context context) {
        return Runtime.unparse(this.getNode(), context);
    }

    public String toString() {
        String s = "function ";
        s = s + this.getName();
        s = s + this.paramString();
        return s;
    }

    void readAttributes(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.name = s.readUTF().intern();
        this.anonymous = s.readBoolean();
        this.finallySet = s.readBoolean();
        this.nargs = s.readInt();
        String[] locals = (String[])s.readObject();
        this.locals = locals;
        for (int j = 0; j < locals.length; ++j) {
            locals[j] = locals[j].intern();
        }
        this.importEnv = (ImportEnv)s.readObject();
        this.moduleList = (ModuleList)s.readObject();
        this.pkgName = s.readUTF();
        this.config = (Configuration)s.readObject();
        this.file = s.readObject();
    }

    void writeAttributes(ObjectOutputStream s) throws IOException {
        s.writeUTF(this.name);
        s.writeBoolean(this.anonymous);
        s.writeBoolean(this.finallySet);
        s.writeInt(this.nargs);
        s.writeObject(this.locals);
        s.writeObject(this.importEnv);
        s.writeObject(this.moduleList);
        s.writeUTF(this.pkgName);
        s.writeObject(this.config);
        s.writeObject(this.file);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        for (int i = 0; i < this.locals.length; ++i) {
            this.locals[i] = this.locals[i].intern();
        }
        this.pkg = Package.getPackage(this.pkgName, null);
        this.file = s.readObject();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.file);
    }
}

