/*
 * Decompiled with CFR 0.152.
 */
package pnuts.ext;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.pnuts.util.MemoryCache;
import pnuts.lang.AutoloadHook;
import pnuts.lang.Context;
import pnuts.lang.Executable;
import pnuts.lang.Package;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;
import pnuts.lang.Property;
import pnuts.lang.Runtime;

public abstract class ModuleBase
implements Executable,
Serializable {
    private transient MemoryCache cache = new MemoryCache();
    private static final String SYMBOL_ERROR = "ERROR".intern();
    private static final String SYMBOL_EXPORTS = "EXPORTS".intern();

    AutoloadFunction getAutoloadFunctionHook(Package pkg) {
        AutoloadFunction af = (AutoloadFunction)this.cache.get(pkg);
        if (af == null) {
            af = new AutoloadFunction(pkg);
            this.cache.put(pkg, af);
        }
        return af;
    }

    protected void autoload(String[] functionNames, String file, Context context) {
        Package pkg = context.getCurrentPackage();
        for (int i = 0; i < functionNames.length; ++i) {
            String symbol = functionNames[i].intern();
            pkg.autoload(symbol, file, context);
            pkg.export(symbol);
        }
    }

    protected void autoloadFunction(String functionName, Context context) {
        Package pkg = context.getCurrentPackage();
        String symbol = functionName.intern();
        pkg.autoload(symbol, this.getAutoloadFunctionHook(pkg));
        pkg.export(symbol);
    }

    protected void autoloadClass(String javaPackage, String name, Context context) {
        Package pkg = context.getCurrentPackage();
        String symbol = name.intern();
        pkg.autoload(symbol, new AutoloadClass(pkg, javaPackage));
        pkg.export(symbol);
    }

    protected String getPrefix() {
        return null;
    }

    protected Package getPackage(Context context) {
        return context.getCurrentPackage();
    }

    protected Object newInstance(Class cls) throws IllegalAccessException, InstantiationException {
        return cls.newInstance();
    }

    protected String getClassName(Package pkg, String name) {
        String pkgName = pkg.getName();
        StringBuffer sbuf = new StringBuffer();
        String prefix = this.getPrefix();
        if (prefix != null) {
            sbuf.append(prefix);
            sbuf.append('.');
        }
        sbuf.append(pkgName);
        sbuf.append('.');
        sbuf.append(name);
        return sbuf.toString().replace('-', '_');
    }

    public Object run(Context context) {
        String[] requiredModules;
        Package pkg = this.getPackage(context);
        pkg.set(SYMBOL_ERROR, ModuleBase.errorFunction(), context);
        pkg.set(SYMBOL_EXPORTS, ModuleBase.exports(pkg), context);
        String[] subModules = this.getSubModules();
        boolean refreshed = false;
        if (subModules != null) {
            for (int i = 0; i < subModules.length; ++i) {
                String module = subModules[i];
                context.usePackage(module);
            }
            context.clearPackages();
            refreshed = true;
        }
        if ((requiredModules = this.getRequiredModules()) != null) {
            if (!refreshed) {
                context.clearPackages();
            }
            for (int i = 0; i < requiredModules.length; ++i) {
                String module = requiredModules[i];
                context.usePackage(module);
            }
        }
        return this.execute(context);
    }

    protected Object execute(Context context) {
        return null;
    }

    protected String[] getRequiredModules() {
        return null;
    }

    protected String[] getSubModules() {
        return null;
    }

    static Property exports(Package pkg) {
        return new ExportProperty(pkg);
    }

    static PnutsFunction errorFunction() {
        return new PnutsFunction(){

            public boolean defined(int nargs) {
                return nargs > 0;
            }

            protected Object exec(Object[] args, Context context) {
                int nargs = args.length;
                String key = (String)args[0];
                Object[] param = null;
                if (nargs > 1) {
                    param = new String[nargs - 1];
                    for (int i = 0; i < param.length; ++i) {
                        param[i] = (String)args[i + 1];
                    }
                }
                Package pkg = context.getCurrentPackage();
                String rsrc = pkg.getName().replace('.', '/') + "/errors";
                ResourceBundle bundle = ResourceBundle.getBundle(rsrc);
                String msg = bundle.getString(key);
                if (param != null && param.length > 0) {
                    throw new PnutsException(MessageFormat.format(msg, param), context);
                }
                throw new PnutsException(msg, context);
            }
        };
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.cache = new MemoryCache();
    }

    static class ExportProperty
    implements Property,
    Serializable {
        Package pkg;

        ExportProperty(Package pkg) {
            this.pkg = pkg;
        }

        public Object get(String name, Context context) {
            this.pkg.export(name);
            return null;
        }

        public void set(String name, Object value, Context context) {
            this.pkg.set(name, value, context);
            this.pkg.export(name);
        }
    }

    static class AutoloadClass
    implements AutoloadHook,
    Serializable {
        Package pnutsPackage;
        String javaPackage;

        AutoloadClass(Package pnutsPackage, String javaPackage) {
            this.pnutsPackage = pnutsPackage;
            this.javaPackage = javaPackage;
        }

        public void load(String name, Context context) {
            block2: {
                try {
                    String className = this.javaPackage + "." + name;
                    Class cls = Pnuts.loadClass(className, context);
                    this.pnutsPackage.set(name, cls, context);
                }
                catch (Exception e) {
                    if (!context.isVerbose()) break block2;
                    Runtime.printError(e, context);
                }
            }
        }
    }

    class AutoloadFunction
    implements AutoloadHook,
    Serializable {
        Package pkg;

        AutoloadFunction(Package pkg) {
            this.pkg = pkg;
        }

        public void load(String name, Context context) {
            try {
                String className = ModuleBase.this.getClassName(this.pkg, name);
                Class cls = Pnuts.loadClass(className, context);
                PnutsFunction func = (PnutsFunction)ModuleBase.this.newInstance(cls);
                this.pkg.set(name, func, context);
            }
            catch (Exception e) {
                Runtime.printError(e, context);
            }
        }
    }
}

