/*
 * Decompiled with CFR 0.152.
 */
package pnuts.ext;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.pnuts.util.Cache;
import org.pnuts.util.LRUCache;
import org.pnuts.util.MemoryCache;
import pnuts.compiler.Compiler;
import pnuts.lang.Context;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsImpl;
import pnuts.lang.Runtime;

public class CachedPnutsImpl
extends PnutsImpl {
    private static final boolean DEBUG = false;
    private static final boolean java2 = Pnuts.isJava2();
    private boolean useCompiler;
    private boolean useDynamicProxy;
    private boolean includeLineNo;
    private Cache file_cache;

    public CachedPnutsImpl() {
        this(true);
    }

    public CachedPnutsImpl(boolean useCompiler) {
        this(useCompiler, true, false);
    }

    public CachedPnutsImpl(boolean useCompiler, boolean useDynamicProxy, boolean includeLineNo) {
        this(useCompiler, useDynamicProxy, includeLineNo, CachedPnutsImpl.createCache());
    }

    public CachedPnutsImpl(boolean useCompiler, boolean useDynamicProxy, boolean includeLineNo, Cache cache) {
        this.useCompiler = useCompiler;
        this.useDynamicProxy = useDynamicProxy;
        this.includeLineNo = includeLineNo;
        this.file_cache = cache;
    }

    public void includeLineNo(boolean flag) {
        this.includeLineNo = flag;
    }

    protected static Cache createCache() {
        if (java2) {
            return new MemoryCache();
        }
        return new LRUCache(64);
    }

    public void reset() {
        this.file_cache.reset();
    }

    protected ScriptCacheEntry getCachedCode(Object key) {
        return (ScriptCacheEntry)this.file_cache.get(key);
    }

    protected void putCachedCode(Object key, ScriptCacheEntry entry) {
        this.file_cache.put(key, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(URL scriptURL, Context context) {
        Object conn;
        String protocol = scriptURL.getProtocol();
        Pnuts parsed = null;
        ScriptCacheEntry entry = null;
        InputStream in = null;
        Object reader = null;
        Context old = Runtime.getThreadContext();
        Runtime.setThreadContext(context);
        try {
            if ("file".equals(protocol)) {
                String fileName = scriptURL.getFile();
                File file = new File(fileName);
                String canon = file.getCanonicalPath();
                long lastModified = file.lastModified();
                entry = this.getCachedCode(scriptURL);
                if (entry == null || lastModified == 0L || entry.lastModified < lastModified) {
                    in = new FileInputStream(file);
                    parsed = Pnuts.parse(Runtime.getScriptReader(in, context), scriptURL, context);
                    if (this.useCompiler) {
                        Compiler compiler = new Compiler(null, false, this.useDynamicProxy);
                        compiler.includeLineNo(this.includeLineNo);
                        compiler.setConstantFolding(true);
                        try {
                            parsed = compiler.compile(parsed, context);
                        }
                        catch (ClassFormatError cfe) {
                            // empty catch block
                        }
                    }
                    if (lastModified != 0L) {
                        entry = new ScriptCacheEntry();
                        entry.lastModified = lastModified;
                        entry.parsedExpression = parsed;
                        this.putCachedCode(scriptURL, entry);
                    }
                } else {
                    parsed = entry.parsedExpression;
                }
            } else {
                conn = scriptURL.openConnection();
                long lastModified = ((URLConnection)conn).getLastModified();
                entry = this.getCachedCode(scriptURL);
                if (entry == null || lastModified == 0L || entry.lastModified < lastModified) {
                    in = ((URLConnection)conn).getInputStream();
                    parsed = Pnuts.parse(Runtime.getScriptReader(in, context), scriptURL, context);
                    if (this.useCompiler) {
                        Compiler compiler = new Compiler(null, false, this.useDynamicProxy);
                        compiler.includeLineNo(this.includeLineNo);
                        compiler.setConstantFolding(true);
                        try {
                            parsed = compiler.compile(parsed, context);
                        }
                        catch (ClassFormatError cfe) {
                            // empty catch block
                        }
                    }
                    if (lastModified != 0L) {
                        entry = new ScriptCacheEntry();
                        entry.lastModified = lastModified;
                        entry.parsedExpression = parsed;
                        this.putCachedCode(scriptURL, entry);
                    }
                } else {
                    parsed = entry.parsedExpression;
                }
            }
            conn = parsed.run(context);
        }
        catch (Throwable t) {
            try {
                Runtime.checkException(context, t);
                Object var10_14 = null;
                return var10_14;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                Runtime.setThreadContext(old);
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException io) {}
                }
            }
        }
        Runtime.setThreadContext(old);
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException io) {
                // empty catch block
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String script, Context context) {
        Context old = Runtime.getThreadContext();
        Runtime.setThreadContext(context);
        try {
            ScriptCacheEntry entry = this.getCachedCode(script);
            if (entry == null) {
                Pnuts parsed = Pnuts.parse(script);
                try {
                    Compiler compiler = new Compiler(null, false, this.useDynamicProxy);
                    compiler.includeLineNo(this.includeLineNo);
                    compiler.setConstantFolding(true);
                    parsed = compiler.compile(parsed, context);
                }
                catch (ClassFormatError e) {
                    // empty catch block
                }
                entry = new ScriptCacheEntry();
                entry.parsedExpression = parsed;
                this.putCachedCode(script, entry);
            }
            Object object = entry.parsedExpression.run(context);
            return object;
        }
        catch (Exception e) {
            Runtime.checkException(context, e);
            Object var5_7 = null;
            return var5_7;
        }
        finally {
            Runtime.setThreadContext(old);
        }
    }

    public static class ScriptCacheEntry {
        public long lastModified;
        public Pnuts parsedExpression;
    }
}

