/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import java.io.FileReader;
import java.io.Reader;
import pnuts.compiler.FrameInfo;
import pnuts.compiler.Reference;
import pnuts.compiler.TranslateContext;
import pnuts.lang.Context;
import pnuts.lang.ParseException;
import pnuts.lang.PnutsParser;
import pnuts.lang.SimpleNode;
import pnuts.lang.Visitor;

public class ScopeAnalyzer
implements Visitor {
    public Object start(SimpleNode node, Context context) {
        return this.expressionList(node, context);
    }

    public Object startSet(SimpleNode node, Context context) {
        return this.expressionList(node, context);
    }

    public Object expressionList(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    protected boolean isTargetIdNode(SimpleNode node, Context context) {
        return true;
    }

    protected void handleFreeVariable(SimpleNode node, Context context) {
    }

    protected void handleLocalVariable(SimpleNode node, Context context) {
    }

    protected void declared(SimpleNode node, Context context, String symbol) {
    }

    public Object idNode(SimpleNode node, Context context) {
        TranslateContext cc = (TranslateContext)context;
        if (this.isTargetIdNode(node, cc)) {
            Reference ref = cc.getReference(node.str);
            if (ref == null) {
                this.handleFreeVariable(node, cc);
            } else {
                this.handleLocalVariable(node, cc);
            }
        }
        return null;
    }

    public Object global(SimpleNode node, Context context) {
        return null;
    }

    public Object className(SimpleNode node, Context context) {
        return null;
    }

    public Object arrayType(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object castExpression(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object listElements(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object mapNode(SimpleNode node, Context context) {
        int num = node.jjtGetNumChildren();
        for (int i = 0; i < num; ++i) {
            SimpleNode c = node.jjtGetChild(i);
            this.acceptChildren(c, context);
        }
        return null;
    }

    public Object classNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object newNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object classDef(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object methodDef(SimpleNode node, Context context) {
        FrameInfo info = (FrameInfo)node.getAttribute("frameInfo");
        if (info == null) {
            info = new FrameInfo();
            node.setAttribute("frameInfo", info);
        }
        String name = node.str;
        TranslateContext cc = (TranslateContext)context;
        String[] locals = new String[]{};
        cc.openFrame(name, locals);
        this.acceptChildren(node, context);
        info.freeVars = cc.getFreeVarSet();
        cc.closeFrame();
        info.preprocessed = true;
        return null;
    }

    public Object primitiveNode(SimpleNode node, Context context) {
        return null;
    }

    public Object importNode(SimpleNode node, Context context) {
        return null;
    }

    public Object indexNode(SimpleNode node, Context context) {
        FrameInfo info = (FrameInfo)node.getAttribute("frameInfo");
        if (info == null) {
            node.setAttribute("frameInfo", new FrameInfo());
        }
        this.acceptChildren(node, context);
        return null;
    }

    public Object rangeNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object methodNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object staticMethodNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object memberNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object staticMemberNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object applicationNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object integerNode(SimpleNode node, Context context) {
        return null;
    }

    public Object floatingNode(SimpleNode node, Context context) {
        return null;
    }

    public Object characterNode(SimpleNode node, Context context) {
        return null;
    }

    public Object stringNode(SimpleNode node, Context context) {
        return null;
    }

    public Object trueNode(SimpleNode node, Context context) {
        return null;
    }

    public Object falseNode(SimpleNode node, Context context) {
        return null;
    }

    public Object nullNode(SimpleNode node, Context context) {
        return null;
    }

    public Object assignment(SimpleNode node, Context context) {
        node.jjtGetChild(1).accept(this, context);
        SimpleNode lhs = node.jjtGetChild(0);
        if (lhs.id == 5) {
            this.assignId(lhs, context);
        } else {
            lhs.accept(this, context);
        }
        return null;
    }

    public Object assignmentTA(SimpleNode node, Context context) {
        this.acceptChildren(node.jjtGetChild(1), context);
        return null;
    }

    public Object assignmentMA(SimpleNode node, Context context) {
        this.acceptChildren(node.jjtGetChild(1), context);
        return null;
    }

    public Object assignmentDA(SimpleNode node, Context context) {
        this.acceptChildren(node.jjtGetChild(1), context);
        return null;
    }

    public Object assignmentPA(SimpleNode node, Context context) {
        this.acceptChildren(node.jjtGetChild(1), context);
        return null;
    }

    public Object assignmentSA(SimpleNode node, Context context) {
        this.acceptChildren(node.jjtGetChild(1), context);
        return null;
    }

    public Object assignmentLA(SimpleNode node, Context context) {
        this.acceptChildren(node.jjtGetChild(1), context);
        return null;
    }

    public Object assignmentRA(SimpleNode node, Context context) {
        this.acceptChildren(node.jjtGetChild(1), context);
        return null;
    }

    public Object assignmentRAA(SimpleNode node, Context context) {
        this.acceptChildren(node.jjtGetChild(1), context);
        return null;
    }

    public Object assignmentAA(SimpleNode node, Context context) {
        this.acceptChildren(node.jjtGetChild(1), context);
        return null;
    }

    public Object assignmentEA(SimpleNode node, Context context) {
        this.acceptChildren(node.jjtGetChild(1), context);
        return null;
    }

    public Object assignmentOA(SimpleNode node, Context context) {
        this.acceptChildren(node.jjtGetChild(1), context);
        return null;
    }

    public Object orNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object andNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object xorNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object logAndNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object logOrNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object logNotNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object equalNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object notEqNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object instanceofExpression(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object ltNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object gtNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object leNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object geNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object shiftLeftNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object shiftRightNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object shiftArithmeticNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object addNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object subtractNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object multNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object divideNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object modNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object negativeNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object preIncrNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object preDecrNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object notNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object postIncrNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object postDecrNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object breakNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object continueNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object returnNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object yieldNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object tryStatement(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object catchBlock(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object finallyBlock(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object blockNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object ifStatement(SimpleNode node, Context context) {
        TranslateContext cc = (TranslateContext)context;
        SimpleNode condNode = node.jjtGetChild(0);
        condNode.accept(this, context);
        cc.openBranchEnv();
        node.jjtGetChild(1).accept(this, context);
        int n = node.jjtGetNumChildren();
        for (int i = 2; i < n; ++i) {
            SimpleNode _node = node.jjtGetChild(i);
            if (_node.id == 79) {
                cc.addBranch();
                SimpleNode _condNode = _node.jjtGetChild(0);
                _condNode.accept(this, context);
                _node.jjtGetChild(1).accept(this, context);
                continue;
            }
            if (_node.id != 80) continue;
            cc.addBranch();
            _node.jjtGetChild(0).accept(this, context);
        }
        cc.closeBranchEnv();
        return null;
    }

    public Object doStatement(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object whileStatement(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object forStatement(SimpleNode node, Context context) {
        int j = 0;
        SimpleNode n = node.jjtGetChild(j);
        TranslateContext cc = (TranslateContext)context;
        SimpleNode blockNode = null;
        if (n.id == 90) {
            int num = n.jjtGetNumChildren();
            for (int i = 0; i < num; ++i) {
                n.jjtGetChild(i).accept(this, context);
            }
            int nc = n.jjtGetNumChildren();
            blockNode = node.jjtGetChild(1);
            if (nc != 1 && nc != 2) return null;
            cc.openScope(new String[]{n.str});
            this.acceptChildren(blockNode, context);
            cc.closeScope();
            return null;
        } else {
            String[] env;
            if (n.id == 91) {
                int _num = n.jjtGetNumChildren();
                env = new String[_num];
                for (int i = 0; i < _num; ++i) {
                    SimpleNode sn = n.jjtGetChild(i);
                    sn.jjtGetChild(0).accept(this, context);
                    env[i] = sn.str;
                }
                ++j;
            } else {
                env = new String[]{};
            }
            cc.openScope(env);
            n = node.jjtGetChild(j);
            if (n.id != 92 && n.id != 77) {
                n.accept(this, context);
                ++j;
            }
            n = node.jjtGetChild(j);
            if (n.id == 92) {
                n.jjtGetChild(0).accept(this, context);
                ++j;
            }
            blockNode = node.jjtGetChild(j);
            this.acceptChildren(blockNode, context);
            cc.closeScope();
        }
        return null;
    }

    public Object foreachStatement(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object switchStatement(SimpleNode node, Context context) {
        int num = node.jjtGetNumChildren();
        for (int i = 0; i < num; ++i) {
            SimpleNode c = node.jjtGetChild(i);
            if (c.id == 97) {
                if (c.jjtGetNumChildren() <= 0) continue;
                c.jjtGetChild(0).accept(this, context);
                continue;
            }
            c.accept(this, context);
        }
        return null;
    }

    public Object switchBlock(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Object functionStatement(SimpleNode node, Context context) {
        info = (FrameInfo)node.getAttribute("frameInfo");
        if (info == null) {
            info = new FrameInfo();
            node.setAttribute("frameInfo", info);
        }
        cc = (TranslateContext)context;
        name = node.str;
        block = node.jjtGetChild(1);
        param = node.jjtGetChild(0);
        nargs = param.jjtGetNumChildren();
        locals = new String[nargs];
        n0 = null;
        if (nargs != 1) ** GOTO lbl-1000
        n0 = param.jjtGetChild(0);
        if (n0.id == 15) {
            nargs = -1;
            locals[0] = n0.jjtGetChild((int)0).str;
        } else lbl-1000:
        // 3 sources

        {
            for (j = 0; j < nargs; ++j) {
                locals[j] = param.jjtGetChild((int)j).str;
            }
        }
        if (cc.env.parent != null && name != null) {
            cc.declare(name);
        }
        cc.openFrame(name, locals);
        block.accept(this, context);
        info.freeVars = cc.getFreeVarSet();
        cc.closeFrame();
        info.preprocessed = true;
        return null;
    }

    public Object ternary(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object catchNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object throwNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    public Object finallyNode(SimpleNode node, Context context) {
        this.acceptChildren(node, context);
        return null;
    }

    void assignId(SimpleNode lhs, Context context) {
        String symbol = lhs.str;
        TranslateContext cc = (TranslateContext)context;
        Reference ref = cc.getReference(symbol);
        if (cc.env.parent != null && ref == null) {
            cc.declare(symbol);
            this.declared(lhs, context, symbol);
        }
    }

    void acceptChildren(SimpleNode node, Context context) {
        FrameInfo info = (FrameInfo)node.getAttribute("frameInfo");
        if (info == null) {
            node.setAttribute("frameInfo", new FrameInfo());
        }
        int num = node.jjtGetNumChildren();
        for (int i = 0; i < num; ++i) {
            node.jjtGetChild(i).accept(this, context);
        }
    }

    public void analyze(Reader reader) throws ParseException {
        this.analyze(new PnutsParser(reader));
    }

    public void analyze(PnutsParser parser) throws ParseException {
        parser.StartSet(null).accept(this, new TranslateContext());
    }

    public void analyze(SimpleNode node) {
        node.accept(this, new TranslateContext());
    }

    public static void main(String[] args) throws Exception {
        ScopeAnalyzer analyzer = new ScopeAnalyzer(){

            protected void handleFreeVariable(SimpleNode node, Context context) {
                System.out.println("free: " + node.str + ", " + node.beginLine);
            }

            protected void handleLocalVariable(SimpleNode node, Context context) {
                System.out.println("local: " + node.str + ", " + node.beginLine);
            }
        };
        analyzer.analyze(new FileReader(args[0]));
    }
}

