/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import pnuts.compiler.Slot;

class ConstantSet {
    Slot[] table;
    int count = 0;
    static final float THRESHOLD = 0.7f;

    public ConstantSet() {
        this(256);
    }

    public ConstantSet(int initialCapacity) {
        this.table = new Slot[initialCapacity];
    }

    public Slot getSlot(Object key) {
        int hash = key.hashCode();
        int idx = (hash & Integer.MAX_VALUE) % this.table.length;
        Slot s = this.table[idx];
        while (s != null) {
            if (key.equals(s.key)) {
                return s;
            }
            s = s.chain;
        }
        if ((float)this.count >= (float)this.table.length * 0.7f) {
            this.rehash(2 * this.table.length);
        }
        ++this.count;
        s = new Slot(key, null);
        s.chain = this.table[idx];
        this.table[idx] = s;
        return s;
    }

    void rehash(int new_capacity) {
        Slot[] new_table = new Slot[new_capacity];
        int i = this.table.length;
        while (--i >= 0) {
            Slot prev = null;
            Slot cur = this.table[i];
            while (cur != null) {
                Slot next = cur.chain;
                cur.chain = prev;
                prev = cur;
                cur = next;
            }
            this.table[i] = prev;
            cur = this.table[i];
            while (cur != null) {
                int hash = cur.key.hashCode();
                int new_index = (hash & Integer.MAX_VALUE) % new_capacity;
                Slot next = cur.chain;
                cur.chain = new_table[new_index];
                new_table[new_index] = cur;
                cur = next;
            }
        }
        this.table = new_table;
    }
}

