/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import pnuts.compiler.Compiled;
import pnuts.compiler.Compiler;
import pnuts.lang.Context;
import pnuts.lang.Pnuts;
import pnuts.lang.Runtime;
import pnuts.lang.Visitor;

class CompiledScript
extends Pnuts
implements Compiled {
    static final long serialVersionUID = -6820627137085836944L;
    private Pnuts script;
    transient Runtime rt;

    public CompiledScript(Runtime rt, Pnuts script) {
        this.scriptSource = script.getScriptSource();
        if (script instanceof CompiledScript) {
            CompiledScript compiled = (CompiledScript)script;
            this.rt = compiled.rt;
            this.script = compiled.script;
        } else {
            this.rt = rt;
            this.script = script;
        }
    }

    public Object accept(Visitor visitor, Context context) {
        if (visitor instanceof Compiler) {
            Compiler c = (Compiler)visitor;
            if (c.automatic) {
                return this.accept(context);
            }
            return this;
        }
        throw new RuntimeException("unsupported operation for compiled code");
    }

    public Object accept(Context context) {
        return this.rt.run(context);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.script);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.script = (Pnuts)s.readObject();
        Context ctx = Runtime.getThreadContext();
        if (ctx == null) {
            ctx = new Context();
        }
        CompiledScript compiled = (CompiledScript)new Compiler().compile(this.script, ctx);
        this.rt = compiled.rt;
    }
}

