/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import pnuts.compiler.ClassFile;
import pnuts.compiler.CodeLoader;
import pnuts.compiler.ControlEnv;
import pnuts.compiler.Frame;
import pnuts.compiler.Label;
import pnuts.compiler.LocalInfo;
import pnuts.compiler.Reference;
import pnuts.compiler.Symbol;
import pnuts.lang.Context;
import pnuts.lang.PnutsException;

class CompileContext
extends Context {
    private static final boolean DEBUG = false;
    Frame env = new Frame();
    Symbol sym = new Symbol();
    Hashtable constants = new Hashtable();
    ClassFile cf;
    Vector classFiles = new Vector();
    String constClassName;
    Vector classes = new Vector();
    int line = -1;
    int column = -1;
    Label returnLabel;
    boolean inGeneratorBlock;
    Object scriptSource;
    int contextIndex = 0;
    ControlEnv ctrl_env;
    Stack finallyBlocks = new Stack();

    CompileContext() {
    }

    CompileContext(Context context) {
        super(context);
    }

    Class loadClasses(CodeLoader loader) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Class ret = this.load(this.cf, loader, bout);
        Enumeration e = this.classFiles.elements();
        while (e.hasMoreElements()) {
            this.load((ClassFile)e.nextElement(), loader, bout);
        }
        this.resolve(loader);
        return ret;
    }

    void resolve(CodeLoader loader) {
        Enumeration e = this.classes.elements();
        while (e.hasMoreElements()) {
            Class c = (Class)e.nextElement();
            loader.resolve(c);
        }
    }

    Class load(ClassFile file, CodeLoader loader) throws IOException {
        return this.load(file, loader, new ByteArrayOutputStream());
    }

    Class load(ClassFile file, CodeLoader loader, ByteArrayOutputStream bout) throws IOException {
        bout.reset();
        file.write(new DataOutputStream(bout));
        byte[] array = bout.toByteArray();
        Class ret = loader.define(file.getClassName(), array, 0, array.length);
        this.classes.addElement(ret);
        return ret;
    }

    public ClassFile getClassFile() {
        return this.cf;
    }

    public Enumeration getClassFiles() {
        return this.classFiles.elements();
    }

    public void write(DataOutputStream out) throws IOException {
        this.cf.write(out);
    }

    void debug(ClassFile file) {
        try {
            String fileName = "/tmp/" + file.getClassName() + ".class";
            System.out.println(fileName);
            FileOutputStream fout = new FileOutputStream(fileName);
            DataOutputStream dout = new DataOutputStream(fout);
            file.write(dout);
            fout.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void debug() {
        this.debug(this.cf);
        Enumeration e = this.classFiles.elements();
        while (e.hasMoreElements()) {
            ClassFile file = (ClassFile)e.nextElement();
            this.debug(file);
        }
    }

    void _openFrame(String func, String[] locals, boolean leaf) {
        this.env = new Frame(locals, func, this.env, leaf);
    }

    void _closeFrame() {
        this.env = this.env.parent;
    }

    void openScope(String[] locals) {
        this.env.openLocal();
        for (int i = 0; i < locals.length; ++i) {
            this._declare(locals[i]);
        }
    }

    void closeScope() {
        this.env.closeLocal();
    }

    void setReference(String symbol) {
        String sym = symbol.intern();
        Frame f = this.env;
        f.setReference(sym);
    }

    Reference findReference(String symbol) {
        return this.getReference(symbol, true);
    }

    Reference getReference(String symbol) {
        return this.getReference(symbol, false);
    }

    Reference getReference(String symbol, boolean flag) {
        Frame f = this.env;
        String sym = symbol.intern();
        Reference ref = f.getReference(sym, flag);
        if (ref != null) {
            return ref;
        }
        f = f.parent;
        while (f != null) {
            Reference r = f.getReference(sym, flag);
            if (r != null) {
                Frame f0 = this.env;
                Frame f1 = null;
                while (f0 != f) {
                    f1 = f0;
                    if (!f0.imports.contains(sym)) {
                        f0.imports.addElement(sym);
                    }
                    f0 = f0.parent;
                }
                Reference ret = new Reference(sym, -1, r.offset >= 0 ? r.offset : 0);
                Reference _ref = f.getReference(sym, flag);
                Vector<Reference> vec = (Vector<Reference>)f.exports.get(f1);
                if (vec == null) {
                    vec = new Vector<Reference>();
                    f.exports.put(f1, vec);
                }
                if (!vec.contains(_ref)) {
                    vec.addElement(_ref);
                }
                f0 = this.env;
                while (f0 != f1) {
                    Frame p = f0.parent;
                    vec = (Vector<Reference>)p.exports.get(f0);
                    if (vec == null) {
                        vec = new Vector<Reference>();
                        p.exports.put(f0, vec);
                    }
                    if (!vec.contains(ret)) {
                        vec.addElement(ret);
                    }
                    f0 = p;
                }
                return ret;
            }
            f = f.parent;
        }
        return null;
    }

    int _declare(String symbol) {
        int local = this.cf.getLocal();
        this._declare(symbol, local);
        return local;
    }

    void _declare_frame(String symbol, int local) {
        this.env._declare_frame(symbol, local);
    }

    void redefine(String symbol) {
        LocalInfo i = this.env.lookup(symbol);
        if (i != null) {
            i.frame = null;
        }
    }

    void _declare(String symbol, int local) {
        this._declare(symbol, local, this.env.leaf ? -1 : 0);
    }

    void _declare(String symbol, int local, int idx) {
        this.env._declare(symbol, local, idx);
    }

    int declare(String symbol) {
        int local = this.cf.declareLocal();
        this.declare(symbol, local);
        return local;
    }

    void declare(String symbol, int local) {
        this.declare(symbol, local, this.env.leaf ? -1 : 0);
    }

    void declare(String symbol, int local, int idx) {
        this.env.declare(symbol, local, idx);
    }

    int getContextIndex() {
        return this.contextIndex;
    }

    void setContextIndex(int index) {
        this.contextIndex = index;
    }

    ControlEnv openControlEnv(int id) {
        this.ctrl_env = new ControlEnv(id, this.ctrl_env);
        return this.ctrl_env;
    }

    void closeControlEnv() {
        this.ctrl_env = this.ctrl_env.parent;
    }

    Label getContinueLabel() {
        if (this.ctrl_env == null) {
            return null;
        }
        return this.ctrl_env.continueLabel;
    }

    Label getBreakLabel() {
        if (this.ctrl_env == null) {
            return null;
        }
        return this.ctrl_env.breakLabel;
    }

    void pushFinallyBlock(Label label) {
        if (this.ctrl_env != null) {
            this.ctrl_env.pushFinallyBlock(label);
        } else {
            this.finallyBlocks.push(label);
        }
    }

    Label popFinallyBlock() {
        if (this.ctrl_env != null) {
            return this.ctrl_env.popFinallyBlock();
        }
        return (Label)this.finallyBlocks.pop();
    }

    void leaveControlEnv() {
        if (this.ctrl_env != null) {
            this.leaveControlEnv(this.ctrl_env);
        }
    }

    void leaveControlEnv(ControlEnv env) {
        Stack finallyBlocks = env.finallyBlocks;
        for (int i = 0; i < finallyBlocks.size(); ++i) {
            Label finalTag = (Label)finallyBlocks.get(finallyBlocks.size() - 1 - i);
            this.cf.add((byte)-88, finalTag);
        }
    }

    void leaveFrame() {
        ControlEnv env = this.ctrl_env;
        while (env != null) {
            this.leaveControlEnv(env);
            env = env.parent;
        }
        Stack blocks = this.finallyBlocks;
        for (int i = 0; i < blocks.size(); ++i) {
            Label finalTag = (Label)blocks.get(blocks.size() - 1 - i);
            this.cf.add((byte)-88, finalTag);
        }
    }

    void openBranchEnv() {
        this.env.openBranchEnv();
    }

    void addBranch() {
        this.env.addBranch();
    }

    void closeBranchEnv() {
        this.env.closeBranchEnv();
    }

    public Object clone() {
        try {
            CompileContext cc = (CompileContext)super.clone();
            cc.ctrl_env = null;
            cc.finallyBlocks = new Stack();
            cc.inGeneratorBlock = false;
            cc.env = (Frame)cc.env.clone();
            return cc;
        }
        catch (Throwable t) {
            throw new PnutsException(t, (Context)this);
        }
    }
}

